/*
 * Decompiled with CFR 0.152.
 */
package com.dianju;

import com.dianju.Result;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.security.NoSuchProviderException;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle149.jce.provider.BouncyCastleProvider;
import srvSeal.SrvSealUtil;

public class OFDVerifyUtil {
    private static final SrvSealUtil srvSealUtil = SrvSealUtil.getObj();

    public static Map<String, Result> OFDsVerify(List<File> ofdFiles) {
        HashMap<String, Result> result = new HashMap<String, Result>();
        if (ofdFiles != null && ofdFiles.size() != 0) {
            for (File ofdFile : ofdFiles) {
                Result res = new Result();
                int openObj = OFDVerifyUtil.openObj(ofdFile.getPath());
                if (openObj < 0) {
                    res.setCode(1);
                    res.setMsg("\u6253\u5f00\u6587\u4ef6\u5931\u8d25");
                    result.put(ofdFile.getName(), res);
                    continue;
                }
                res = OFDVerifyUtil.ofdVerify(openObj);
                result.put(ofdFile.getName(), res);
                OFDVerifyUtil.saveFileBase(openObj, "", "ofd");
            }
        } else {
            result.put("error", new Result(1, "\u5f85\u9a8c\u8bc1\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        return result;
    }

    private static Result ofdVerify(int openObj) {
        Result res = new Result();
        if (System.getProperty("os.name").toUpperCase().contains("WINDOWS")) {
            String sealData = srvSealUtil.verify(openObj);
            if ("".equals(sealData)) {
                res.setCode(1);
                res.setMsg("\u672a\u53d1\u73b0\u7b7e\u540d\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u5f85\u9a8c\u8bc1\u6587\u6863\u662f\u5426\u52a0\u76d6\u4e86\u5370\u7ae0!");
            } else if (OFDVerifyUtil.varifyDate(sealData)) {
                res.setCode(0);
                res.setMsg("\u6821\u9a8c\u901a\u8fc7");
            } else {
                res.setCode(1);
                res.setMsg("\u6821\u9a8c\u4e0d\u901a\u8fc7");
            }
            return res;
        }
        boolean sealNum = false;
        String sealNode = srvSealUtil.getNextSeal(openObj, "");
        if (StringUtils.isEmpty(sealNode) && !sealNum) {
            res.setCode(1);
            res.setMsg("\u672a\u53d1\u73b0\u7b7e\u540d\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u5f85\u9a8c\u8bc1\u6587\u6863\u662f\u5426\u52a0\u76d6\u4e86\u5370\u7ae0!");
            return res;
        }
        String certData = srvSealUtil.getValueEx(openObj, sealNode, 39, "", 0, "");
        Map<String, String> certMap = OFDVerifyUtil.pfxCert(Base64.decodeBase64(certData));
        while (StringUtils.isNotEmpty(sealNode)) {
            long cert;
            String sealType = srvSealUtil.getSealInfo(openObj, sealNode, 0);
            if ("1".equals(sealType)) {
                res.setCode(1);
                res.setMsg("\u9a8c\u8bc1\u4e0d\u901a\u8fc7:\u6b64\u6587\u6863\u4e2d\u6709\u975e\u5370\u7ae0\u7684\u5143\u7d20");
                return res;
            }
            String sealData = srvSealUtil.verifySeal(openObj, sealNode);
            Map<String, String> sealMap = OFDVerifyUtil.getDataMapFromVer(sealData);
            String sealTime = sealMap.get("CreTm");
            String endTime = certMap.get("endTime");
            long seal = OFDVerifyUtil.getSealTime(sealTime) / 1000L;
            if (seal > (cert = Long.parseLong(endTime))) {
                res.setCode(1);
                res.setMsg("\u9a8c\u8bc1\u4e0d\u901a\u8fc7:\u76d6\u7ae0\u65f6\u95f4\u5927\u4e8e\u8bc1\u4e66\u6709\u6548\u671f");
                return res;
            }
            if (!sealMap.containsKey("CertSerial")) {
                sealNode = srvSealUtil.getNextSeal(openObj, sealNode);
                continue;
            }
            boolean verifyRes = OFDVerifyUtil.varifyDate(sealData);
            if (!verifyRes) {
                res.setCode(1);
                res.setMsg("\u6587\u6863\u9a8c\u8bc1\u5931\u8d25\uff0c\u6587\u6863\u88ab\u7be1\u6539");
                return res;
            }
            res.setCode(0);
            res.setMsg("\u6821\u9a8c\u901a\u8fc7");
            return res;
        }
        if (!sealNum) {
            res.setCode(1);
            res.setMsg("\u672a\u53d1\u73b0\u7b7e\u540d\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u5f85\u9a8c\u8bc1\u6587\u6863\u662f\u5426\u52a0\u76d6\u4e86\u5370\u7ae0!");
            return res;
        }
        return null;
    }

    private static boolean varifyDate(String varifyDate) {
        if (varifyDate != null && !"".equals(varifyDate)) {
            String[] s = varifyDate.split("<+");
            for (int j = 1; j < s.length; ++j) {
                String s1 = s[j].substring(s[j].indexOf("+") + 1, s[j].indexOf("/;->"));
                String[] nodes = s1.split("/;");
                for (int i = 0; i < nodes.length; ++i) {
                    String[] node = nodes[i].split("=");
                    if (!"RetCode".equals(node[0]) || Integer.parseInt(node[1]) >= 0) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private static int openObj(String openPath) {
        int nFS1 = 0;
        int nFS2 = 0;
        int ret = System.getProperty("os.name").toUpperCase().contains("WINDOWS") ? srvSealUtil.openObj(openPath, nFS1, nFS2) : srvSealUtil.openObj(openPath, nFS1);
        return ret;
    }

    private static int loginEx(int nObjID, int nLoginType, String userID, String pwd) {
        int ret;
        if (System.getProperty("os.name").toUpperCase().contains("WINDOWS")) {
            ret = srvSealUtil.login(nObjID, nLoginType, userID, pwd);
        } else {
            ret = srvSealUtil.login(nObjID, userID, nLoginType, pwd);
            int n = ret == 1 ? 0 : (ret = ret == 0 ? 1 : ret);
        }
        if (ret != 0) {
            OFDVerifyUtil.saveFileBase(nObjID, "", "ofd");
        }
        return ret;
    }

    private static int saveFileBase(int nObjID, String savePath, String saveType) {
        int ret = System.getProperty("os.name").toUpperCase().contains("WINDOWS") ? srvSealUtil.saveFile(nObjID, savePath, saveType, 0) : srvSealUtil.saveFile(nObjID, savePath);
        return ret;
    }

    private static Map<String, String> getDataMapFromVer(String verify) {
        String substr = verify.substring(2, verify.length() - 2);
        String[] split = substr.split("/;");
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < split.length; ++i) {
            String[] splstr = split[i].split("=");
            map.put(splstr[0], splstr.length > 1 ? splstr[1] : "");
        }
        return map;
    }

    private static Map<String, String> pfxCert(byte[] certs) {
        X509Certificate cert = null;
        HashMap<String, String> certMap = null;
        try (ByteArrayInputStream in = new ByteArrayInputStream(certs);){
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
            cert = (X509Certificate)cf.generateCertificate(in);
        }
        catch (IOException | NoSuchProviderException | CertificateException e) {
            e.printStackTrace();
        }
        if (cert != null) {
            certMap = new HashMap<String, String>();
            String dn = cert.getSubjectDN().toString();
            String sn = cert.getSerialNumber().toString(16);
            certMap.put("dn", dn);
            certMap.put("sn", sn);
            certMap.put("beginTime", String.valueOf(cert.getNotBefore().getTime() / 1000L));
            certMap.put("endTime", String.valueOf(cert.getNotAfter().getTime() / 1000L));
        }
        return certMap;
    }

    private static long getSealTime(String sealTime) {
        SimpleDateFormat simple = System.getProperty("os.name").toUpperCase().contains("WINDOWS") ? new SimpleDateFormat("yyyyMMddHHmmss") : new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        long sealtime = 0L;
        try {
            sealtime = simple.parse(sealTime).getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return sealtime;
    }

    static {
        Security.addProvider(new BouncyCastleProvider());
    }
}

