/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle149.cert;

import java.math.BigInteger;
import java.util.Date;
import org.bouncycastle149.asn1.ASN1Encodable;
import org.bouncycastle149.asn1.ASN1GeneralizedTime;
import org.bouncycastle149.asn1.ASN1Integer;
import org.bouncycastle149.asn1.ASN1ObjectIdentifier;
import org.bouncycastle149.asn1.DERSet;
import org.bouncycastle149.asn1.x509.AttCertIssuer;
import org.bouncycastle149.asn1.x509.Attribute;
import org.bouncycastle149.asn1.x509.ExtensionsGenerator;
import org.bouncycastle149.asn1.x509.V2AttributeCertificateInfoGenerator;
import org.bouncycastle149.cert.AttributeCertificateHolder;
import org.bouncycastle149.cert.AttributeCertificateIssuer;
import org.bouncycastle149.cert.CertIOException;
import org.bouncycastle149.cert.CertUtils;
import org.bouncycastle149.cert.X509AttributeCertificateHolder;
import org.bouncycastle149.operator.ContentSigner;

public class X509v2AttributeCertificateBuilder {
    private V2AttributeCertificateInfoGenerator acInfoGen = new V2AttributeCertificateInfoGenerator();
    private ExtensionsGenerator extGenerator = new ExtensionsGenerator();

    public X509v2AttributeCertificateBuilder(AttributeCertificateHolder attributeCertificateHolder, AttributeCertificateIssuer attributeCertificateIssuer, BigInteger bigInteger, Date date, Date date2) {
        this.acInfoGen.setHolder(attributeCertificateHolder.holder);
        this.acInfoGen.setIssuer(AttCertIssuer.getInstance(attributeCertificateIssuer.form));
        this.acInfoGen.setSerialNumber(new ASN1Integer(bigInteger));
        this.acInfoGen.setStartDate(new ASN1GeneralizedTime(date));
        this.acInfoGen.setEndDate(new ASN1GeneralizedTime(date2));
    }

    public X509v2AttributeCertificateBuilder addAttribute(ASN1ObjectIdentifier aSN1ObjectIdentifier, ASN1Encodable aSN1Encodable) {
        this.acInfoGen.addAttribute(new Attribute(aSN1ObjectIdentifier, new DERSet(aSN1Encodable)));
        return this;
    }

    public X509v2AttributeCertificateBuilder addAttribute(ASN1ObjectIdentifier aSN1ObjectIdentifier, ASN1Encodable[] aSN1EncodableArray) {
        this.acInfoGen.addAttribute(new Attribute(aSN1ObjectIdentifier, new DERSet(aSN1EncodableArray)));
        return this;
    }

    public void setIssuerUniqueId(boolean[] blArray) {
        this.acInfoGen.setIssuerUniqueID(CertUtils.booleanToBitString(blArray));
    }

    public X509v2AttributeCertificateBuilder addExtension(ASN1ObjectIdentifier aSN1ObjectIdentifier, boolean bl, ASN1Encodable aSN1Encodable) throws CertIOException {
        CertUtils.addExtension(this.extGenerator, aSN1ObjectIdentifier, bl, aSN1Encodable);
        return this;
    }

    public X509AttributeCertificateHolder build(ContentSigner contentSigner) {
        this.acInfoGen.setSignature(contentSigner.getAlgorithmIdentifier());
        if (!this.extGenerator.isEmpty()) {
            this.acInfoGen.setExtensions(this.extGenerator.generate());
        }
        return CertUtils.generateFullAttrCert(contentSigner, this.acInfoGen.generateAttributeCertificateInfo());
    }
}

