/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle149.cms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle149.asn1.ASN1Encodable;
import org.bouncycastle149.asn1.ASN1EncodableVector;
import org.bouncycastle149.asn1.ASN1Object;
import org.bouncycastle149.asn1.ASN1ObjectIdentifier;
import org.bouncycastle149.asn1.ASN1Set;
import org.bouncycastle149.asn1.BEROctetString;
import org.bouncycastle149.asn1.DERSet;
import org.bouncycastle149.asn1.cms.AttributeTable;
import org.bouncycastle149.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle149.asn1.cms.ContentInfo;
import org.bouncycastle149.asn1.cms.SignedData;
import org.bouncycastle149.asn1.cms.SignerInfo;
import org.bouncycastle149.cms.CMSAbsentContent;
import org.bouncycastle149.cms.CMSAttributeTableGenerator;
import org.bouncycastle149.cms.CMSException;
import org.bouncycastle149.cms.CMSProcessable;
import org.bouncycastle149.cms.CMSProcessableByteArray;
import org.bouncycastle149.cms.CMSSignedData;
import org.bouncycastle149.cms.CMSSignedGenerator;
import org.bouncycastle149.cms.CMSSignedHelper;
import org.bouncycastle149.cms.CMSTypedData;
import org.bouncycastle149.cms.CMSUtils;
import org.bouncycastle149.cms.DefaultSignedAttributeTableGenerator;
import org.bouncycastle149.cms.SignerInfoGenerator;
import org.bouncycastle149.cms.SignerInformation;
import org.bouncycastle149.cms.SignerInformationStore;
import org.bouncycastle149.cms.SimpleAttributeTableGenerator;
import org.bouncycastle149.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle149.operator.ContentSigner;
import org.bouncycastle149.operator.OperatorCreationException;
import org.bouncycastle149.operator.bc.BcDigestCalculatorProvider;
import org.bouncycastle149.operator.jcajce.JcaContentSignerBuilder;

public class CMSSignedDataGenerator
extends CMSSignedGenerator {
    private List signerInfs = new ArrayList();

    public CMSSignedDataGenerator() {
    }

    public CMSSignedDataGenerator(SecureRandom secureRandom) {
        super(secureRandom);
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string) throws IllegalArgumentException {
        this.addSigner(privateKey, x509Certificate, this.getEncOID(privateKey, string), string);
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string, String string2) throws IllegalArgumentException {
        this.doAddSigner(privateKey, x509Certificate, string, string2, new DefaultSignedAttributeTableGenerator(), null, null);
    }

    public void addSigner(PrivateKey privateKey, byte[] byArray, String string) throws IllegalArgumentException {
        this.addSigner(privateKey, byArray, this.getEncOID(privateKey, string), string);
    }

    public void addSigner(PrivateKey privateKey, byte[] byArray, String string, String string2) throws IllegalArgumentException {
        this.doAddSigner(privateKey, byArray, string, string2, new DefaultSignedAttributeTableGenerator(), null, null);
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string, AttributeTable attributeTable, AttributeTable attributeTable2) throws IllegalArgumentException {
        this.addSigner(privateKey, x509Certificate, this.getEncOID(privateKey, string), string, attributeTable, attributeTable2);
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string, String string2, AttributeTable attributeTable, AttributeTable attributeTable2) throws IllegalArgumentException {
        this.doAddSigner(privateKey, x509Certificate, string, string2, new DefaultSignedAttributeTableGenerator(attributeTable), new SimpleAttributeTableGenerator(attributeTable2), attributeTable);
    }

    public void addSigner(PrivateKey privateKey, byte[] byArray, String string, AttributeTable attributeTable, AttributeTable attributeTable2) throws IllegalArgumentException {
        this.addSigner(privateKey, byArray, this.getEncOID(privateKey, string), string, attributeTable, attributeTable2);
    }

    public void addSigner(PrivateKey privateKey, byte[] byArray, String string, String string2, AttributeTable attributeTable, AttributeTable attributeTable2) throws IllegalArgumentException {
        this.doAddSigner(privateKey, byArray, string, string2, new DefaultSignedAttributeTableGenerator(attributeTable), new SimpleAttributeTableGenerator(attributeTable2), attributeTable);
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string, CMSAttributeTableGenerator cMSAttributeTableGenerator, CMSAttributeTableGenerator cMSAttributeTableGenerator2) throws IllegalArgumentException {
        this.addSigner(privateKey, x509Certificate, this.getEncOID(privateKey, string), string, cMSAttributeTableGenerator, cMSAttributeTableGenerator2);
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string, String string2, CMSAttributeTableGenerator cMSAttributeTableGenerator, CMSAttributeTableGenerator cMSAttributeTableGenerator2) throws IllegalArgumentException {
        this.doAddSigner(privateKey, x509Certificate, string, string2, cMSAttributeTableGenerator, cMSAttributeTableGenerator2, null);
    }

    public void addSigner(PrivateKey privateKey, byte[] byArray, String string, CMSAttributeTableGenerator cMSAttributeTableGenerator, CMSAttributeTableGenerator cMSAttributeTableGenerator2) throws IllegalArgumentException {
        this.addSigner(privateKey, byArray, this.getEncOID(privateKey, string), string, cMSAttributeTableGenerator, cMSAttributeTableGenerator2);
    }

    public void addSigner(PrivateKey privateKey, byte[] byArray, String string, String string2, CMSAttributeTableGenerator cMSAttributeTableGenerator, CMSAttributeTableGenerator cMSAttributeTableGenerator2) throws IllegalArgumentException {
        this.doAddSigner(privateKey, byArray, string, string2, cMSAttributeTableGenerator, cMSAttributeTableGenerator2, null);
    }

    private void doAddSigner(PrivateKey privateKey, Object object, String string, String string2, CMSAttributeTableGenerator cMSAttributeTableGenerator, CMSAttributeTableGenerator cMSAttributeTableGenerator2, AttributeTable attributeTable) throws IllegalArgumentException {
        this.signerInfs.add(new SignerInf(privateKey, object, string2, string, cMSAttributeTableGenerator, cMSAttributeTableGenerator2, attributeTable));
    }

    public CMSSignedData generate(CMSProcessable cMSProcessable, String string) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.generate(cMSProcessable, CMSUtils.getProvider(string));
    }

    public CMSSignedData generate(CMSProcessable cMSProcessable, Provider provider) throws NoSuchAlgorithmException, CMSException {
        return this.generate(cMSProcessable, false, provider);
    }

    public CMSSignedData generate(String string, CMSProcessable cMSProcessable, boolean bl, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.generate(string, cMSProcessable, bl, CMSUtils.getProvider(string2), true);
    }

    public CMSSignedData generate(String string, CMSProcessable cMSProcessable, boolean bl, Provider provider) throws NoSuchAlgorithmException, CMSException {
        return this.generate(string, cMSProcessable, bl, provider, true);
    }

    public CMSSignedData generate(String string, CMSProcessable cMSProcessable, boolean bl, String string2, boolean bl2) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.generate(string, cMSProcessable, bl, CMSUtils.getProvider(string2), bl2);
    }

    public CMSSignedData generate(String string, final CMSProcessable cMSProcessable, boolean bl, Provider provider, boolean bl2) throws NoSuchAlgorithmException, CMSException {
        boolean bl3 = string == null;
        final ASN1ObjectIdentifier aSN1ObjectIdentifier = bl3 ? null : new ASN1ObjectIdentifier(string);
        for (SignerInf signerInf : this.signerInfs) {
            try {
                this.signerGens.add(signerInf.toSignerInfoGenerator(this.rand, provider, bl2));
            }
            catch (OperatorCreationException operatorCreationException) {
                throw new CMSException("exception creating signerInf", operatorCreationException);
            }
            catch (IOException iOException) {
                throw new CMSException("exception encoding attributes", iOException);
            }
            catch (CertificateEncodingException certificateEncodingException) {
                throw new CMSException("error creating sid.", certificateEncodingException);
            }
        }
        this.signerInfs.clear();
        if (cMSProcessable != null) {
            return this.generate(new CMSTypedData(){

                public ASN1ObjectIdentifier getContentType() {
                    return aSN1ObjectIdentifier;
                }

                public void write(OutputStream outputStream) throws IOException, CMSException {
                    cMSProcessable.write(outputStream);
                }

                public Object getContent() {
                    return cMSProcessable.getContent();
                }
            }, bl);
        }
        return this.generate(new CMSAbsentContent(aSN1ObjectIdentifier), bl);
    }

    public CMSSignedData generate(CMSProcessable cMSProcessable, boolean bl, String string) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        if (cMSProcessable instanceof CMSTypedData) {
            return this.generate(((CMSTypedData)cMSProcessable).getContentType().getId(), cMSProcessable, bl, string);
        }
        return this.generate(DATA, cMSProcessable, bl, string);
    }

    public CMSSignedData generate(CMSProcessable cMSProcessable, boolean bl, Provider provider) throws NoSuchAlgorithmException, CMSException {
        if (cMSProcessable instanceof CMSTypedData) {
            return this.generate(((CMSTypedData)cMSProcessable).getContentType().getId(), cMSProcessable, bl, provider);
        }
        return this.generate(DATA, cMSProcessable, bl, provider);
    }

    public CMSSignedData generate(CMSTypedData cMSTypedData) throws CMSException {
        return this.generate(cMSTypedData, false);
    }

    public CMSSignedData generate(CMSTypedData cMSTypedData, boolean bl) throws CMSException {
        Object object;
        ASN1Object aSN1Object;
        Object object22;
        Object object3;
        Object object42;
        if (!this.signerInfs.isEmpty()) {
            throw new IllegalStateException("this method can only be used with SignerInfoGenerator");
        }
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        this.digests.clear();
        for (Object object42 : this._signers) {
            aSN1EncodableVector.add(CMSSignedHelper.INSTANCE.fixAlgID(((SignerInformation)object42).getDigestAlgorithmID()));
            aSN1EncodableVector2.add(((SignerInformation)object42).toASN1Structure());
        }
        ASN1ObjectIdentifier aSN1ObjectIdentifier = cMSTypedData.getContentType();
        object42 = null;
        if (cMSTypedData != null) {
            object3 = null;
            if (bl) {
                object3 = new ByteArrayOutputStream();
            }
            object22 = CMSUtils.attachSignersToOutputStream(this.signerGens, object3);
            object22 = CMSUtils.getSafeOutputStream((OutputStream)object22);
            try {
                cMSTypedData.write((OutputStream)object22);
                ((OutputStream)object22).close();
            }
            catch (IOException iOException) {
                throw new CMSException("data processing exception: " + iOException.getMessage(), iOException);
            }
            if (bl) {
                object42 = new BEROctetString(((ByteArrayOutputStream)object3).toByteArray());
            }
        }
        for (Object object22 : this.signerGens) {
            aSN1Object = ((SignerInfoGenerator)object22).generate(aSN1ObjectIdentifier);
            aSN1EncodableVector.add(((SignerInfo)aSN1Object).getDigestAlgorithm());
            aSN1EncodableVector2.add(aSN1Object);
            object = ((SignerInfoGenerator)object22).getCalculatedDigest();
            if (object == null) continue;
            this.digests.put(((SignerInfo)aSN1Object).getDigestAlgorithm().getAlgorithm().getId(), object);
        }
        object3 = null;
        if (this.certs.size() != 0) {
            object3 = CMSUtils.createBerSetFromList(this.certs);
        }
        object22 = null;
        if (this.crls.size() != 0) {
            object22 = CMSUtils.createBerSetFromList(this.crls);
        }
        aSN1Object = new ContentInfo(aSN1ObjectIdentifier, (ASN1Encodable)object42);
        object = new SignedData(new DERSet(aSN1EncodableVector), (ContentInfo)aSN1Object, (ASN1Set)object3, (ASN1Set)object22, new DERSet(aSN1EncodableVector2));
        ContentInfo contentInfo = new ContentInfo(CMSObjectIdentifiers.signedData, (ASN1Encodable)object);
        return new CMSSignedData((CMSProcessable)cMSTypedData, contentInfo);
    }

    public SignerInformationStore generateCounterSigners(SignerInformation signerInformation, Provider provider) throws NoSuchAlgorithmException, CMSException {
        return this.generate(null, (CMSProcessable)new CMSProcessableByteArray(signerInformation.getSignature()), false, provider).getSignerInfos();
    }

    public SignerInformationStore generateCounterSigners(SignerInformation signerInformation, String string) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.generate(null, (CMSProcessable)new CMSProcessableByteArray(signerInformation.getSignature()), false, CMSUtils.getProvider(string)).getSignerInfos();
    }

    public SignerInformationStore generateCounterSigners(SignerInformation signerInformation) throws CMSException {
        return this.generate(new CMSProcessableByteArray(null, signerInformation.getSignature()), false).getSignerInfos();
    }

    private class SignerInf {
        final PrivateKey key;
        final Object signerIdentifier;
        final String digestOID;
        final String encOID;
        final CMSAttributeTableGenerator sAttr;
        final CMSAttributeTableGenerator unsAttr;
        final AttributeTable baseSignedTable;

        SignerInf(PrivateKey privateKey, Object object, String string, String string2, CMSAttributeTableGenerator cMSAttributeTableGenerator, CMSAttributeTableGenerator cMSAttributeTableGenerator2, AttributeTable attributeTable) {
            this.key = privateKey;
            this.signerIdentifier = object;
            this.digestOID = string;
            this.encOID = string2;
            this.sAttr = cMSAttributeTableGenerator;
            this.unsAttr = cMSAttributeTableGenerator2;
            this.baseSignedTable = attributeTable;
        }

        SignerInfoGenerator toSignerInfoGenerator(SecureRandom secureRandom, Provider provider, boolean bl) throws IOException, CertificateEncodingException, CMSException, OperatorCreationException, NoSuchAlgorithmException {
            JcaContentSignerBuilder jcaContentSignerBuilder;
            String string = CMSSignedHelper.INSTANCE.getDigestAlgName(this.digestOID);
            String string2 = string + "with" + CMSSignedHelper.INSTANCE.getEncryptionAlgName(this.encOID);
            JcaSignerInfoGeneratorBuilder jcaSignerInfoGeneratorBuilder = new JcaSignerInfoGeneratorBuilder(new BcDigestCalculatorProvider());
            if (bl) {
                jcaSignerInfoGeneratorBuilder.setSignedAttributeGenerator(this.sAttr);
            }
            jcaSignerInfoGeneratorBuilder.setDirectSignature(!bl);
            jcaSignerInfoGeneratorBuilder.setUnsignedAttributeGenerator(this.unsAttr);
            try {
                jcaContentSignerBuilder = new JcaContentSignerBuilder(string2).setSecureRandom(secureRandom);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new NoSuchAlgorithmException(illegalArgumentException.getMessage());
            }
            if (provider != null) {
                jcaContentSignerBuilder.setProvider(provider);
            }
            ContentSigner contentSigner = jcaContentSignerBuilder.build(this.key);
            if (this.signerIdentifier instanceof X509Certificate) {
                return jcaSignerInfoGeneratorBuilder.build(contentSigner, (X509Certificate)this.signerIdentifier);
            }
            return jcaSignerInfoGeneratorBuilder.build(contentSigner, (byte[])this.signerIdentifier);
        }
    }
}

