/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle149.cms;

import java.io.IOException;
import java.security.Key;
import java.security.NoSuchProviderException;
import java.security.Provider;
import javax.crypto.SecretKey;
import org.bouncycastle149.asn1.cms.KEKIdentifier;
import org.bouncycastle149.asn1.cms.KEKRecipientInfo;
import org.bouncycastle149.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle149.cms.AuthAttributesProvider;
import org.bouncycastle149.cms.CMSEnvelopedHelper;
import org.bouncycastle149.cms.CMSException;
import org.bouncycastle149.cms.CMSSecureReadable;
import org.bouncycastle149.cms.CMSTypedStream;
import org.bouncycastle149.cms.CMSUtils;
import org.bouncycastle149.cms.KEKRecipient;
import org.bouncycastle149.cms.KEKRecipientId;
import org.bouncycastle149.cms.Recipient;
import org.bouncycastle149.cms.RecipientInformation;
import org.bouncycastle149.cms.RecipientOperator;
import org.bouncycastle149.cms.jcajce.JceKEKAuthenticatedRecipient;
import org.bouncycastle149.cms.jcajce.JceKEKEnvelopedRecipient;
import org.bouncycastle149.cms.jcajce.JceKEKRecipient;

public class KEKRecipientInformation
extends RecipientInformation {
    private KEKRecipientInfo info;

    KEKRecipientInformation(KEKRecipientInfo kEKRecipientInfo, AlgorithmIdentifier algorithmIdentifier, CMSSecureReadable cMSSecureReadable, AuthAttributesProvider authAttributesProvider) {
        super(kEKRecipientInfo.getKeyEncryptionAlgorithm(), algorithmIdentifier, cMSSecureReadable, authAttributesProvider);
        this.info = kEKRecipientInfo;
        KEKIdentifier kEKIdentifier = kEKRecipientInfo.getKekid();
        this.rid = new KEKRecipientId(kEKIdentifier.getKeyIdentifier().getOctets());
    }

    public CMSTypedStream getContentStream(Key key, String string) throws CMSException, NoSuchProviderException {
        return this.getContentStream(key, CMSUtils.getProvider(string));
    }

    public CMSTypedStream getContentStream(Key key, Provider provider) throws CMSException {
        try {
            JceKEKRecipient jceKEKRecipient = this.secureReadable instanceof CMSEnvelopedHelper.CMSEnvelopedSecureReadable ? new JceKEKEnvelopedRecipient((SecretKey)key) : new JceKEKAuthenticatedRecipient((SecretKey)key);
            if (provider != null) {
                jceKEKRecipient.setProvider(provider);
            }
            return this.getContentStream(jceKEKRecipient);
        }
        catch (IOException iOException) {
            throw new CMSException("encoding error: " + iOException.getMessage(), iOException);
        }
    }

    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException, IOException {
        return ((KEKRecipient)recipient).getRecipientOperator(this.keyEncAlg, this.messageAlgorithm, this.info.getEncryptedKey().getOctets());
    }
}

