/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle149.crypto.agreement;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle149.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle149.crypto.CipherParameters;
import org.bouncycastle149.crypto.generators.DHKeyPairGenerator;
import org.bouncycastle149.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle149.crypto.params.DHKeyGenerationParameters;
import org.bouncycastle149.crypto.params.DHParameters;
import org.bouncycastle149.crypto.params.DHPrivateKeyParameters;
import org.bouncycastle149.crypto.params.DHPublicKeyParameters;
import org.bouncycastle149.crypto.params.ParametersWithRandom;

public class DHAgreement {
    private DHPrivateKeyParameters key;
    private DHParameters dhParams;
    private BigInteger privateValue;
    private SecureRandom random;

    public void init(CipherParameters cipherParameters) {
        AsymmetricKeyParameter asymmetricKeyParameter;
        if (cipherParameters instanceof ParametersWithRandom) {
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
            this.random = parametersWithRandom.getRandom();
            asymmetricKeyParameter = (AsymmetricKeyParameter)parametersWithRandom.getParameters();
        } else {
            this.random = new SecureRandom();
            asymmetricKeyParameter = (AsymmetricKeyParameter)cipherParameters;
        }
        if (!(asymmetricKeyParameter instanceof DHPrivateKeyParameters)) {
            throw new IllegalArgumentException("DHEngine expects DHPrivateKeyParameters");
        }
        this.key = (DHPrivateKeyParameters)asymmetricKeyParameter;
        this.dhParams = this.key.getParameters();
    }

    public BigInteger calculateMessage() {
        DHKeyPairGenerator dHKeyPairGenerator = new DHKeyPairGenerator();
        dHKeyPairGenerator.init(new DHKeyGenerationParameters(this.random, this.dhParams));
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = dHKeyPairGenerator.generateKeyPair();
        this.privateValue = ((DHPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate()).getX();
        return ((DHPublicKeyParameters)asymmetricCipherKeyPair.getPublic()).getY();
    }

    public BigInteger calculateAgreement(DHPublicKeyParameters dHPublicKeyParameters, BigInteger bigInteger) {
        if (!dHPublicKeyParameters.getParameters().equals(this.dhParams)) {
            throw new IllegalArgumentException("Diffie-Hellman public key has wrong parameters.");
        }
        BigInteger bigInteger2 = this.dhParams.getP();
        return bigInteger.modPow(this.key.getX(), bigInteger2).multiply(dHPublicKeyParameters.getY().modPow(this.privateValue, bigInteger2)).mod(bigInteger2);
    }
}

