/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle149.crypto.agreement.kdf;

import java.io.IOException;
import org.bouncycastle149.asn1.ASN1Encodable;
import org.bouncycastle149.asn1.ASN1EncodableVector;
import org.bouncycastle149.asn1.ASN1ObjectIdentifier;
import org.bouncycastle149.asn1.DERNull;
import org.bouncycastle149.asn1.DEROctetString;
import org.bouncycastle149.asn1.DERSequence;
import org.bouncycastle149.asn1.DERTaggedObject;
import org.bouncycastle149.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle149.crypto.DataLengthException;
import org.bouncycastle149.crypto.DerivationFunction;
import org.bouncycastle149.crypto.DerivationParameters;
import org.bouncycastle149.crypto.Digest;
import org.bouncycastle149.crypto.agreement.kdf.DHKDFParameters;
import org.bouncycastle149.crypto.generators.KDF2BytesGenerator;
import org.bouncycastle149.crypto.params.KDFParameters;
import org.bouncycastle149.crypto.util.Pack;

public class ECDHKEKGenerator
implements DerivationFunction {
    private DerivationFunction kdf;
    private ASN1ObjectIdentifier algorithm;
    private int keySize;
    private byte[] z;

    public ECDHKEKGenerator(Digest digest) {
        this.kdf = new KDF2BytesGenerator(digest);
    }

    public void init(DerivationParameters derivationParameters) {
        DHKDFParameters dHKDFParameters = (DHKDFParameters)derivationParameters;
        this.algorithm = dHKDFParameters.getAlgorithm();
        this.keySize = dHKDFParameters.getKeySize();
        this.z = dHKDFParameters.getZ();
    }

    public Digest getDigest() {
        return this.kdf.getDigest();
    }

    public int generateBytes(byte[] byArray, int n, int n2) throws DataLengthException, IllegalArgumentException {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new AlgorithmIdentifier(this.algorithm, (ASN1Encodable)DERNull.INSTANCE));
        aSN1EncodableVector.add(new DERTaggedObject(true, 2, new DEROctetString(Pack.intToBigEndian(this.keySize))));
        try {
            this.kdf.init(new KDFParameters(this.z, new DERSequence(aSN1EncodableVector).getEncoded("DER")));
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("unable to initialise kdf: " + iOException.getMessage());
        }
        return this.kdf.generateBytes(byArray, n, n2);
    }
}

