/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle149.crypto.generators;

import java.math.BigInteger;
import org.bouncycastle149.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle149.crypto.AsymmetricCipherKeyPairGenerator;
import org.bouncycastle149.crypto.KeyGenerationParameters;
import org.bouncycastle149.crypto.generators.DHKeyGeneratorHelper;
import org.bouncycastle149.crypto.params.DHKeyGenerationParameters;
import org.bouncycastle149.crypto.params.DHParameters;
import org.bouncycastle149.crypto.params.DHPrivateKeyParameters;
import org.bouncycastle149.crypto.params.DHPublicKeyParameters;

public class DHKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private DHKeyGenerationParameters param;

    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.param = (DHKeyGenerationParameters)keyGenerationParameters;
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        DHKeyGeneratorHelper dHKeyGeneratorHelper = DHKeyGeneratorHelper.INSTANCE;
        DHParameters dHParameters = this.param.getParameters();
        BigInteger bigInteger = dHKeyGeneratorHelper.calculatePrivate(dHParameters, this.param.getRandom());
        BigInteger bigInteger2 = dHKeyGeneratorHelper.calculatePublic(dHParameters, bigInteger);
        return new AsymmetricCipherKeyPair(new DHPublicKeyParameters(bigInteger2, dHParameters), new DHPrivateKeyParameters(bigInteger, dHParameters));
    }
}

