/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle149.crypto.kems;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle149.crypto.CipherParameters;
import org.bouncycastle149.crypto.DerivationFunction;
import org.bouncycastle149.crypto.KeyEncapsulation;
import org.bouncycastle149.crypto.params.ECKeyParameters;
import org.bouncycastle149.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle149.crypto.params.ECPublicKeyParameters;
import org.bouncycastle149.crypto.params.KDFParameters;
import org.bouncycastle149.crypto.params.KeyParameter;
import org.bouncycastle149.math.ec.ECPoint;
import org.bouncycastle149.util.BigIntegers;

public class ECIESKeyEncapsulation
implements KeyEncapsulation {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private DerivationFunction kdf;
    private SecureRandom rnd;
    private ECKeyParameters key;
    private boolean CofactorMode;
    private boolean OldCofactorMode;
    private boolean SingleHashMode;

    public ECIESKeyEncapsulation(DerivationFunction derivationFunction, SecureRandom secureRandom) {
        this.kdf = derivationFunction;
        this.rnd = secureRandom;
        this.CofactorMode = false;
        this.OldCofactorMode = false;
        this.SingleHashMode = false;
    }

    public ECIESKeyEncapsulation(DerivationFunction derivationFunction, SecureRandom secureRandom, boolean bl, boolean bl2, boolean bl3) {
        this.kdf = derivationFunction;
        this.rnd = secureRandom;
        this.CofactorMode = bl;
        this.OldCofactorMode = bl2;
        this.SingleHashMode = bl3;
    }

    public void init(CipherParameters cipherParameters) throws IllegalArgumentException {
        if (!(cipherParameters instanceof ECKeyParameters)) {
            throw new IllegalArgumentException("EC key required");
        }
        this.key = (ECKeyParameters)cipherParameters;
    }

    public CipherParameters encrypt(byte[] byArray, int n, int n2) throws IllegalArgumentException {
        byte[] byArray2;
        if (!(this.key instanceof ECPublicKeyParameters)) {
            throw new IllegalArgumentException("Public key required for encryption");
        }
        BigInteger bigInteger = this.key.getParameters().getN();
        BigInteger bigInteger2 = this.key.getParameters().getH();
        BigInteger bigInteger3 = BigIntegers.createRandomInRange(ONE, bigInteger, this.rnd);
        ECPoint eCPoint = this.key.getParameters().getG().multiply(bigInteger3);
        byte[] byArray3 = eCPoint.getEncoded();
        System.arraycopy(byArray3, 0, byArray, n, byArray3.length);
        BigInteger bigInteger4 = this.CofactorMode ? bigInteger3.multiply(bigInteger2).mod(bigInteger) : bigInteger3;
        ECPoint eCPoint2 = ((ECPublicKeyParameters)this.key).getQ().multiply(bigInteger4);
        int n3 = (this.key.getParameters().getCurve().getFieldSize() + 7) / 8;
        byte[] byArray4 = BigIntegers.asUnsignedByteArray(n3, eCPoint2.getX().toBigInteger());
        if (this.SingleHashMode) {
            byArray2 = new byte[byArray3.length + byArray4.length];
            System.arraycopy(byArray3, 0, byArray2, 0, byArray3.length);
            System.arraycopy(byArray4, 0, byArray2, byArray3.length, byArray4.length);
        } else {
            byArray2 = byArray4;
        }
        this.kdf.init(new KDFParameters(byArray2, null));
        byte[] byArray5 = new byte[n2];
        this.kdf.generateBytes(byArray5, 0, byArray5.length);
        return new KeyParameter(byArray5);
    }

    public CipherParameters encrypt(byte[] byArray, int n) {
        return this.encrypt(byArray, 0, n);
    }

    public CipherParameters decrypt(byte[] byArray, int n, int n2, int n3) throws IllegalArgumentException {
        byte[] byArray2;
        if (!(this.key instanceof ECPrivateKeyParameters)) {
            throw new IllegalArgumentException("Private key required for encryption");
        }
        BigInteger bigInteger = this.key.getParameters().getN();
        BigInteger bigInteger2 = this.key.getParameters().getH();
        byte[] byArray3 = new byte[n2];
        System.arraycopy(byArray, n, byArray3, 0, n2);
        ECPoint eCPoint = this.key.getParameters().getCurve().decodePoint(byArray3);
        ECPoint eCPoint2 = this.CofactorMode || this.OldCofactorMode ? eCPoint.multiply(bigInteger2) : eCPoint;
        BigInteger bigInteger3 = this.CofactorMode ? ((ECPrivateKeyParameters)this.key).getD().multiply(bigInteger2.modInverse(bigInteger)).mod(bigInteger) : ((ECPrivateKeyParameters)this.key).getD();
        ECPoint eCPoint3 = eCPoint2.multiply(bigInteger3);
        int n4 = (this.key.getParameters().getCurve().getFieldSize() + 7) / 8;
        byte[] byArray4 = BigIntegers.asUnsignedByteArray(n4, eCPoint3.getX().toBigInteger());
        if (this.SingleHashMode) {
            byArray2 = new byte[byArray3.length + byArray4.length];
            System.arraycopy(byArray3, 0, byArray2, 0, byArray3.length);
            System.arraycopy(byArray4, 0, byArray2, byArray3.length, byArray4.length);
        } else {
            byArray2 = byArray4;
        }
        this.kdf.init(new KDFParameters(byArray2, null));
        byte[] byArray5 = new byte[n3];
        this.kdf.generateBytes(byArray5, 0, byArray5.length);
        return new KeyParameter(byArray5);
    }

    public CipherParameters decrypt(byte[] byArray, int n) {
        return this.decrypt(byArray, 0, byArray.length, n);
    }
}

