/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle149.crypto.tls;

import org.bouncycastle149.crypto.CipherParameters;
import org.bouncycastle149.crypto.CryptoException;
import org.bouncycastle149.crypto.DSA;
import org.bouncycastle149.crypto.Digest;
import org.bouncycastle149.crypto.Signer;
import org.bouncycastle149.crypto.digests.NullDigest;
import org.bouncycastle149.crypto.digests.SHA1Digest;
import org.bouncycastle149.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle149.crypto.params.ParametersWithRandom;
import org.bouncycastle149.crypto.signers.DSADigestSigner;
import org.bouncycastle149.crypto.tls.AbstractTlsSigner;

public abstract class TlsDSASigner
extends AbstractTlsSigner {
    public byte[] generateRawSignature(AsymmetricKeyParameter asymmetricKeyParameter, byte[] byArray) throws CryptoException {
        Signer signer = this.makeSigner(new NullDigest(), true, new ParametersWithRandom(asymmetricKeyParameter, this.context.getSecureRandom()));
        signer.update(byArray, 16, 20);
        return signer.generateSignature();
    }

    public boolean verifyRawSignature(byte[] byArray, AsymmetricKeyParameter asymmetricKeyParameter, byte[] byArray2) throws CryptoException {
        Signer signer = this.makeSigner(new NullDigest(), false, asymmetricKeyParameter);
        signer.update(byArray2, 16, 20);
        return signer.verifySignature(byArray);
    }

    public Signer createSigner(AsymmetricKeyParameter asymmetricKeyParameter) {
        return this.makeSigner(new SHA1Digest(), true, new ParametersWithRandom(asymmetricKeyParameter, this.context.getSecureRandom()));
    }

    public Signer createVerifyer(AsymmetricKeyParameter asymmetricKeyParameter) {
        return this.makeSigner(new SHA1Digest(), false, asymmetricKeyParameter);
    }

    protected Signer makeSigner(Digest digest, boolean bl, CipherParameters cipherParameters) {
        DSADigestSigner dSADigestSigner = new DSADigestSigner(this.createDSAImpl(), digest);
        dSADigestSigner.init(bl, cipherParameters);
        return dSADigestSigner;
    }

    protected abstract DSA createDSAImpl();
}

