/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle149.crypto.tls;

import org.bouncycastle149.crypto.AsymmetricBlockCipher;
import org.bouncycastle149.crypto.CipherParameters;
import org.bouncycastle149.crypto.CryptoException;
import org.bouncycastle149.crypto.Digest;
import org.bouncycastle149.crypto.Signer;
import org.bouncycastle149.crypto.encodings.PKCS1Encoding;
import org.bouncycastle149.crypto.engines.RSABlindedEngine;
import org.bouncycastle149.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle149.crypto.params.ParametersWithRandom;
import org.bouncycastle149.crypto.params.RSAKeyParameters;
import org.bouncycastle149.crypto.signers.GenericSigner;
import org.bouncycastle149.crypto.signers.RSADigestSigner;
import org.bouncycastle149.crypto.tls.AbstractTlsSigner;
import org.bouncycastle149.crypto.tls.CombinedHash;
import org.bouncycastle149.crypto.tls.ProtocolVersion;
import org.bouncycastle149.util.Arrays;

public class TlsRSASigner
extends AbstractTlsSigner {
    public byte[] generateRawSignature(AsymmetricKeyParameter asymmetricKeyParameter, byte[] byArray) throws CryptoException {
        AsymmetricBlockCipher asymmetricBlockCipher = this.createRSAImpl();
        asymmetricBlockCipher.init(true, new ParametersWithRandom(asymmetricKeyParameter, this.context.getSecureRandom()));
        return asymmetricBlockCipher.processBlock(byArray, 0, byArray.length);
    }

    public boolean verifyRawSignature(byte[] byArray, AsymmetricKeyParameter asymmetricKeyParameter, byte[] byArray2) throws CryptoException {
        AsymmetricBlockCipher asymmetricBlockCipher = this.createRSAImpl();
        asymmetricBlockCipher.init(false, asymmetricKeyParameter);
        byte[] byArray3 = asymmetricBlockCipher.processBlock(byArray, 0, byArray.length);
        return Arrays.constantTimeAreEqual(byArray3, byArray2);
    }

    public Signer createSigner(AsymmetricKeyParameter asymmetricKeyParameter) {
        return this.makeSigner(new CombinedHash(), true, new ParametersWithRandom(asymmetricKeyParameter, this.context.getSecureRandom()));
    }

    public Signer createVerifyer(AsymmetricKeyParameter asymmetricKeyParameter) {
        return this.makeSigner(new CombinedHash(), false, asymmetricKeyParameter);
    }

    public boolean isValidPublicKey(AsymmetricKeyParameter asymmetricKeyParameter) {
        return asymmetricKeyParameter instanceof RSAKeyParameters && !asymmetricKeyParameter.isPrivate();
    }

    protected Signer makeSigner(Digest digest, boolean bl, CipherParameters cipherParameters) {
        Signer signer = ProtocolVersion.TLSv12.isEqualOrEarlierVersionOf(this.context.getServerVersion().getEquivalentTLSVersion()) ? new RSADigestSigner(digest) : new GenericSigner(this.createRSAImpl(), digest);
        signer.init(bl, cipherParameters);
        return signer;
    }

    protected AsymmetricBlockCipher createRSAImpl() {
        return new PKCS1Encoding(new RSABlindedEngine());
    }
}

