/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle149.jcajce.provider.symmetric;

import org.bouncycastle149.crypto.CipherKeyGenerator;
import org.bouncycastle149.crypto.engines.Salsa20Engine;
import org.bouncycastle149.jcajce.provider.config.ConfigurableProvider;
import org.bouncycastle149.jcajce.provider.symmetric.util.BaseKeyGenerator;
import org.bouncycastle149.jcajce.provider.symmetric.util.BaseStreamCipher;
import org.bouncycastle149.jcajce.provider.util.AlgorithmProvider;

public final class Salsa20 {
    private Salsa20() {
    }

    public static class Base
    extends BaseStreamCipher {
        public Base() {
            super(new Salsa20Engine(), 8);
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            super("Salsa20", 128, new CipherKeyGenerator());
        }
    }

    public static class Mappings
    extends AlgorithmProvider {
        private static final String PREFIX = Salsa20.class.getName();

        public void configure(ConfigurableProvider configurableProvider) {
            configurableProvider.addAlgorithm("Cipher.SALSA20", PREFIX + "$Base");
            configurableProvider.addAlgorithm("KeyGenerator.SALSA20", PREFIX + "$KeyGen");
        }
    }
}

