/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle149.openssl.jcajce;

import java.security.Provider;
import org.bouncycastle149.jcajce.DefaultJcaJceHelper;
import org.bouncycastle149.jcajce.JcaJceHelper;
import org.bouncycastle149.jcajce.NamedJcaJceHelper;
import org.bouncycastle149.jcajce.ProviderJcaJceHelper;
import org.bouncycastle149.openssl.PEMDecryptor;
import org.bouncycastle149.openssl.PEMDecryptorProvider;
import org.bouncycastle149.openssl.PEMException;
import org.bouncycastle149.openssl.PasswordException;
import org.bouncycastle149.openssl.jcajce.PEMUtilities;

public class JcePEMDecryptorProviderBuilder {
    private JcaJceHelper helper = new DefaultJcaJceHelper();

    public JcePEMDecryptorProviderBuilder setProvider(Provider provider) {
        this.helper = new ProviderJcaJceHelper(provider);
        return this;
    }

    public JcePEMDecryptorProviderBuilder setProvider(String string) {
        this.helper = new NamedJcaJceHelper(string);
        return this;
    }

    public PEMDecryptorProvider build(final char[] cArray) {
        return new PEMDecryptorProvider(){

            public PEMDecryptor get(final String string) {
                return new PEMDecryptor(){

                    public byte[] decrypt(byte[] byArray, byte[] byArray2) throws PEMException {
                        if (cArray == null) {
                            throw new PasswordException("Password is null, but a password is required");
                        }
                        return PEMUtilities.crypt(false, JcePEMDecryptorProviderBuilder.this.helper, byArray, cArray, string, byArray2);
                    }
                };
            }
        };
    }
}

