/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.eepsp.service.explain.verify.domain.dto;

import com.ygsoft.abc.eepsp.service.explain.verify.util.DateUtil;
import com.ygsoft.abc.mapp.ygca.gwcw.domain.vo.X509CertVO;
import com.ygsoft.ecp.service.model.IValueObject;

public class X509CertDTO
implements IValueObject {
    private static final long serialVersionUID = 239951717484263911L;
    private String subject;
    private String serialNumber;
    private String beginDate;
    private String endDate;
    private String issuer;

    public static X509CertDTO createFrom(X509CertVO x509CertVO) {
        if (x509CertVO == null) {
            return null;
        }
        X509CertDTO dto = new X509CertDTO();
        dto.setSubject(x509CertVO.getSubject());
        dto.setSerialNumber(x509CertVO.getSerialNumber());
        dto.setBeginDate(DateUtil.format(x509CertVO.getBeginDate()));
        dto.setEndDate(DateUtil.format(x509CertVO.getEndDate()));
        dto.setIssuer(x509CertVO.getIssuer());
        return dto;
    }

    public X509CertVO convert() {
        X509CertVO x509CertVO = new X509CertVO();
        x509CertVO.setSubject(this.getSubject());
        x509CertVO.setSerialNumber(this.getSerialNumber());
        x509CertVO.setBeginDate(DateUtil.parse(this.getBeginDate()));
        x509CertVO.setEndDate(DateUtil.parse(this.getEndDate()));
        x509CertVO.setIssuer(this.getIssuer());
        return x509CertVO;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public String getBeginDate() {
        return this.beginDate;
    }

    public void setBeginDate(String beginDate) {
        this.beginDate = beginDate;
    }

    public String getEndDate() {
        return this.endDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public String toString() {
        return "X509CertDTO [subject=" + this.subject + ", serialNumber=" + this.serialNumber + ", beginDate=" + this.beginDate + ", endDate=" + this.endDate + ", issuer=" + this.issuer + "]";
    }
}

