/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.eepsp.service.explain.verify.strategy.impl;

import api.VoucherFileInfo;
import api.VoucherFileUtil;
import api.loader.OFDLoader;
import com.alibaba.fastjson.JSONObject;
import com.ygsoft.abc.eepsp.service.explain.common.type.ElecVoucherBOEnum;
import com.ygsoft.abc.eepsp.service.explain.verify.domain.vo.VerifyRecordVO;
import com.ygsoft.abc.eepsp.service.explain.verify.domain.vo.XbrlFileVO;
import com.ygsoft.abc.eepsp.service.explain.verify.impl.transfer.VerifyRecordTransfer;
import com.ygsoft.abc.eepsp.service.explain.verify.strategy.IEleVoucherParseStrategy;
import com.ygsoft.abc.eepsp.service.explain.verify.util.EepspCommonUtil;
import com.ygsoft.abc.mapp.ygca.gwcw.common.config.VerifyConfig;
import com.ygsoft.abc.mapp.ygca.gwcw.common.types.YesnoEnum;
import com.ygsoft.abc.mapp.ygca.gwcw.domain.vo.VerifyResultVO;
import com.ygsoft.abc.mapp.ygca.gwcw.factory.BizSignatureServiceFactory;
import com.ygsoft.abc.mapp.ygca.gwcw.service.IBizSignatureService;
import com.ygsoft.abc.service.annotation.TLog;
import com.ygsoft.abc.service.exception.AbcIOException;
import com.ygsoft.abc.service.exception.AbcIllegalArgumentException;
import com.ygsoft.abc.service.exception.CheckFailedException;
import com.ygsoft.abc.service.tool.BlockIOUtil;
import com.ygsoft.abc.service.tool.PreconditionUtil;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.StringUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Objects;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Component
public class EleVoucherParseOfd
implements IEleVoucherParseStrategy {
    private static final IEcpLog LOG = EcpLogFactory.getLog(EleVoucherParseOfd.class);
    private static final String NODE_NAME_TEXT = "#text";
    private static final int OFD_FILE_SIZE_MAX = 10240;

    @Override
    @TLog(text="\u9a8c\u7b7eOFD")
    public VerifyRecordVO parseSign(MultipartFile file) {
        VerifyRecordVO recordVO = new VerifyRecordVO();
        VerifyResultVO verifyResultVO = null;
        VerifyConfig verifyConfig = this.getVerifyConfig();
        IBizSignatureService service = BizSignatureServiceFactory.getInstance((VerifyConfig)verifyConfig);
        try {
            byte[] bytes = file.getBytes();
            verifyResultVO = service.verify(bytes, "ofd");
            recordVO = VerifyRecordTransfer.getInstance().verifyResultToVerifyRecordVO(verifyResultVO);
            recordVO.setFileName(file.getOriginalFilename());
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"\u9a8c\u7b7eOFD\u5931\u8d25", (Throwable)e);
            }
            recordVO.setSuccessed(YesnoEnum.NO);
        }
        recordVO.setVerifyTime(new Date());
        return recordVO;
    }

    @Override
    @TLog(text="\u89e3\u6790OFD")
    public JSONObject parseVoucher(MultipartFile file, String configId) {
        PreconditionUtil.checkNotNull((Object)file, (String)"ofd\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        JSONObject xbrl2Json = null;
        try {
            String canonicalPath = this.copyFileToTagetDir(file);
            VoucherFileInfo extractXBRLFromOFD = VoucherFileUtil.extractXBRLFromOFD((String)canonicalPath);
            String xbrl = this.targetDirXml2String(extractXBRLFromOFD.getXbrlFilePath());
            PreconditionUtil.checkNotTrimEmpty((String)xbrl, (String)"xbrl\u6587\u4ef6\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            PreconditionUtil.checkNotTrimEmpty((String)configId, (String)"configId\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            xbrl2Json = VoucherFileUtil.xbrl2Json((String)xbrl, (String)configId);
        }
        catch (Exception e) {
            LOG.error((Object)"\u8c03\u7528\u9a8c\u7b7e\u89e3\u6790OFD\u53d1\u751f\u5f02\u5e38\u3002", (Throwable)e);
        }
        return xbrl2Json;
    }

    @Override
    @TLog(text="\u89e3\u6790OFD\u4e3axbrl")
    public XbrlFileVO parse2XBRL(MultipartFile file, int voucherType) {
        PreconditionUtil.checkNotNull((Object)file, (String)"OFD\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        XbrlFileVO xbrlVO = new XbrlFileVO();
        String xbrl = "";
        VoucherFileInfo extractXBRLFromOFD = null;
        String tempXmlFolderPath = EepspCommonUtil.spliceStr(BlockIOUtil.getTempPath(), File.separator, "parse2xbrl");
        String orignFilePath = EepspCommonUtil.spliceStr(tempXmlFolderPath, File.separator, file.getOriginalFilename());
        try {
            File folder = new File(tempXmlFolderPath);
            if (!folder.exists()) {
                FileUtils.forceMkdir((File)folder);
            }
            BlockIOUtil.write((byte[])file.getBytes(), (String)orignFilePath);
            extractXBRLFromOFD = VoucherFileUtil.extractXBRLFromOFD((String)orignFilePath);
        }
        catch (Exception e) {
            LOG.error((Object)"\u8c03\u7528\u9a8c\u7b7e\u89e3\u6790OFD\u53d1\u751f\u5f02\u5e38\u3002", (Throwable)e);
        }
        if (extractXBRLFromOFD == null) {
            throw CheckFailedException.newInstance((String)("\u4e0d\u652f\u6301\u7684\u51ed\u8bc1\u7c7b\u578b\u3002\u6587\u4ef6\u540d\uff1a" + file.getOriginalFilename()));
        }
        String voucherTypeStr = extractXBRLFromOFD.getVoucherType();
        if (!StringUtil.isNotEmpty((String)voucherTypeStr)) {
            throw CheckFailedException.newInstance((String)"\u7535\u5b50\u51ed\u8bc1\u6587\u4ef6\u547d\u540d\u89c4\u5219\u4e0d\u89c4\u8303\uff0c\u65e0\u6cd5\u8bc6\u522b\u3002");
        }
        if (!voucherTypeStr.equals(ElecVoucherBOEnum.values()[voucherType].getConfigId())) {
            throw new AbcIllegalArgumentException("ABC.0030", "\u4e0a\u4f20\u6587\u4ef6\u4e0e\u6240\u9009\u6587\u4ef6\u7c7b\u578b\u4e0d\u5339\u914d\u3002");
        }
        String xbrlFilePath = extractXBRLFromOFD.getXbrlFilePath();
        File xml = new File(xbrlFilePath);
        String xmlPath = EepspCommonUtil.spliceStr(tempXmlFolderPath, File.separator, xml.getName());
        try (FileOutputStream outFile = new FileOutputStream(xmlPath);
             FileInputStream in = new FileInputStream(xbrlFilePath);
             ByteArrayOutputStream out = new ByteArrayOutputStream();){
            int n;
            byte[] buffer = new byte[10240];
            while ((n = ((InputStream)in).read(buffer)) != -1) {
                out.write(buffer, 0, n);
                outFile.write(buffer, 0, n);
                outFile.flush();
            }
            byte[] data = out.toByteArray();
            BlockIOUtil.deleteFile((String)orignFilePath);
            BlockIOUtil.deleteFile((String)xbrlFilePath);
            if (data == null) {
                throw CheckFailedException.newInstance((String)"\u83b7\u53d6xbrl\u6587\u4ef6\u5931\u8d25\u3002");
            }
            xbrl = new String(data, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new AbcIOException("ABC.0015", (Throwable)e);
        }
        PreconditionUtil.checkNotTrimEmpty((String)xbrl, (String)"xbrl\u6587\u4ef6\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        xbrlVO.setXbrlTempPath(xmlPath);
        xbrlVO.setXbrlJsonString(xbrl);
        return xbrlVO;
    }

    @Override
    public ElecVoucherBOEnum getElecVoucherBOEunm(MultipartFile file) {
        String originalFilename = file.getOriginalFilename();
        String voucherType = null;
        try {
            String canonicalPath = this.copyFileToTagetDir(file);
            VoucherFileInfo extractXBRLFromOFD = VoucherFileUtil.extractXBRLFromOFD((String)canonicalPath);
            voucherType = extractXBRLFromOFD.getVoucherType();
            if (voucherType == null) {
                throw CheckFailedException.newInstance((String)"\u7535\u5b50\u51ed\u8bc1\u6587\u4ef6\u547d\u540d\u89c4\u5219\u4e0d\u89c4\u8303\uff0c\u65e0\u6cd5\u8bc6\u522b\u3002");
            }
            for (ElecVoucherBOEnum boEnum : ElecVoucherBOEnum.values()) {
                String configId = boEnum.getConfigId();
                if (!StringUtil.isNotEmpty((String)configId) || !voucherType.startsWith(configId)) continue;
                return boEnum;
            }
            throw CheckFailedException.newInstance((String)("\u4e0d\u652f\u6301\u7684\u51ed\u8bc1\u7c7b\u578b\u3002\u6587\u4ef6\u540d\uff1a" + originalFilename));
        }
        catch (Exception e) {
            LOG.error((Object)"\u4eceOFD\u83b7\u53d6XBRL\u53d1\u751f\u5f02\u5e38\u3002", (Throwable)e);
            throw CheckFailedException.newInstance((String)"\u5904\u7406\u7535\u5b50\u51ed\u8bc1\u6587\u4ef6\u65f6\u53d1\u751f\u5f02\u5e38\u3002");
        }
    }

    @Override
    public Object getAllElec(MultipartFile file) {
        try {
            String canonicalPath = this.copyFileToTagetDir(file);
            OFDLoader loader = new OFDLoader();
            VoucherFileInfo voucherFileInfo = loader.extractAttach(canonicalPath, "");
            if (Objects.isNull(voucherFileInfo)) {
                return this.getOfdBaseJSON(canonicalPath);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"\u89e3\u6790\u6587\u6863\u5f02\u5e38\uff0c\u68c0\u67e5\u6587\u4ef6\u662f\u5426\u6b63\u786e\u3002", (Throwable)e);
        }
        return null;
    }

    @Override
    public Object getNotGwSpecialVat(MultipartFile file) {
        try {
            String canonicalPath = this.copyFileToTagetDir(file);
            OFDLoader loader = new OFDLoader();
            VoucherFileInfo voucherFileInfo = loader.extractAttach(canonicalPath, "");
            if (voucherFileInfo == null) {
                return this.getOfdBaseJSON(canonicalPath);
            }
            if (voucherFileInfo.getVoucherType() == null) {
                String xbrlFilePath = voucherFileInfo.getXbrlFilePath();
                String xbrl = this.targetDirXml2String(xbrlFilePath);
                PreconditionUtil.checkNotTrimEmpty((String)xbrl, (String)"xbrl\u6587\u4ef6\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\u3002");
                String[] split = xbrlFilePath.split("\\\\");
                String xbrlFileName = split[split.length - 1];
                String configId = xbrlFileName.split("\\.")[0];
                JSONObject xbrl2Json = VoucherFileUtil.xbrl2Json((String)xbrl, (String)configId);
                if (xbrl2Json == null) {
                    FileInputStream is = new FileInputStream(xbrlFilePath);
                    DocumentBuilderFactory fac = DocumentBuilderFactory.newInstance();
                    DocumentBuilder builder = fac.newDocumentBuilder();
                    Document d = builder.parse(is);
                    NodeList list = d.getElementsByTagName("eInvoice");
                    Node node = list.item(0);
                    JSONObject cObject = new JSONObject();
                    JSONObject jsonObject = this.toNotGwSpecialVatJsonObj(node, cObject);
                    ((InputStream)is).close();
                    return new JSONObject().put(node.getNodeName(), (Object)jsonObject);
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"\u89e3\u6790\u6587\u6863\u5f02\u5e38\uff0c\u68c0\u67e5\u6587\u4ef6\u662f\u5426\u6b63\u786e\u3002", (Throwable)e);
        }
        return null;
    }

    private String copyFileToTagetDir(MultipartFile file) throws IOException {
        File tempFile = File.createTempFile("test-ofd-", file.getOriginalFilename(), null);
        String canonicalPath = tempFile.getCanonicalPath();
        BlockIOUtil.write((byte[])file.getBytes(), (String)canonicalPath);
        tempFile.deleteOnExit();
        return canonicalPath;
    }

    private JSONObject getOfdBaseJSON(String canonicalPath) {
        LOG.info((Object)"extract OFD file ");
        JSONObject jsonRObject = new JSONObject();
        try {
            ZipFile zipfile = new ZipFile(canonicalPath);
            ZipArchiveEntry entry = zipfile.getEntry("OFD.xml");
            if (entry == null) {
                zipfile.close();
                throw CheckFailedException.newInstance((String)"\u65e0\u6cd5\u8bc6\u522b\u7684\u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u3002");
            }
            InputStream is = zipfile.getInputStream(entry);
            DocumentBuilderFactory fac = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = fac.newDocumentBuilder();
            Document d = builder.parse(is);
            NodeList list = d.getElementsByTagName("ofd:DocBody");
            Node node = list.item(0);
            JSONObject cObject = new JSONObject();
            JSONObject jsonObject = this.toJsonObj(node, cObject);
            jsonRObject.put(node.getNodeName().split(":")[1], (Object)jsonObject);
            LOG.info((Object)"extract success!");
            zipfile.close();
            return jsonRObject;
        }
        catch (Exception e) {
            LOG.error((Object)"\u4eceOFD\u83b7\u53d6\u57fa\u7840OFD.xml\u53d1\u751f\u5f02\u5e38\u3002", (Throwable)e);
            return jsonRObject;
        }
    }

    private String targetDirXml2String(String xbrlFilePath) throws IOException {
        FileInputStream in = new FileInputStream(xbrlFilePath);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        int n = 0;
        while ((n = ((InputStream)in).read(buffer)) != -1) {
            out.write(buffer, 0, n);
        }
        byte[] data = out.toByteArray();
        ((InputStream)in).close();
        out.close();
        if (null == data) {
            throw CheckFailedException.newInstance((String)"\u83b7\u53d6xbrl\u6587\u4ef6\u5931\u8d25\u3002");
        }
        String xbrl = new String(data, "UTF-8");
        return xbrl;
    }

    private JSONObject toJsonObj(Node node, JSONObject jsonObject) {
        if (node.hasChildNodes()) {
            Node firstChild = node.getChildNodes().item(0);
            String nodeName = firstChild.getNodeName().split(":")[1];
            if ("DocInfo".equalsIgnoreCase(nodeName)) {
                JSONObject docInfo = new JSONObject();
                NodeList childNodes = firstChild.getChildNodes();
                for (int i = 0; i < childNodes.getLength(); ++i) {
                    Node childNode = childNodes.item(i);
                    String childNodeName = childNode.getNodeName().split(":")[1];
                    if ("CustomDatas".equalsIgnoreCase(childNodeName)) {
                        JSONObject customData = this.processCustomDatas(childNode);
                        docInfo.put(childNodeName, (Object)customData);
                        continue;
                    }
                    docInfo.put(childNodeName, (Object)childNode.getTextContent());
                }
                jsonObject.put(nodeName, (Object)docInfo);
            } else {
                JSONObject jsonCObject = new JSONObject();
                jsonObject.put(nodeName, (Object)this.toJsonObj(firstChild, jsonCObject));
            }
        }
        return jsonObject;
    }

    private JSONObject processCustomDatas(Node customDatasNode) {
        JSONObject customData = new JSONObject();
        NodeList dataNodes = customDatasNode.getChildNodes();
        for (int j = 0; j < dataNodes.getLength(); ++j) {
            String dataNodeName;
            Node dataNode = dataNodes.item(j);
            if (dataNode == null || !"CustomData".equalsIgnoreCase(dataNodeName = dataNode.getNodeName().split(":")[1])) continue;
            String name = dataNode.getAttributes().getNamedItem("Name").getNodeValue().split("=")[1].replace("\"", "");
            customData.put(name, (Object)dataNode.getTextContent());
        }
        return customData;
    }

    private JSONObject toNotGwSpecialVatJsonObj(Node node, JSONObject jsonObject) {
        if (node.hasChildNodes()) {
            NodeList childNodes = node.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                JSONObject jsonCObject = new JSONObject();
                node = childNodes.item(i);
                if (node.hasChildNodes()) {
                    String nodeName = node.getNodeName();
                    JSONObject jsonObject1 = this.toNotGwSpecialVatJsonObj(node, jsonCObject);
                    jsonObject.put(nodeName, (Object)jsonObject1);
                    continue;
                }
                String pNodeName = node.getParentNode().getNodeName();
                String pContent = node.getParentNode().getTextContent();
                String nodeName = node.getNodeName();
                if (!Objects.equals(nodeName, NODE_NAME_TEXT)) continue;
                jsonObject.put(pNodeName.split(":")[1], (Object)pContent);
            }
        }
        return jsonObject;
    }
}

