/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io.support;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.UrlResource;
import org.springframework.core.io.VfsResource;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.io.support.VfsPatternUtils;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.PathMatcher;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;

public class PathMatchingResourcePatternResolver
implements ResourcePatternResolver {
    private static final Log logger = LogFactory.getLog(PathMatchingResourcePatternResolver.class);
    private final Log startCostLogger = LogFactory.getLog((String)"startcost");
    private static final boolean ENABLE_SCAN_CACHE = Boolean.parseBoolean(System.getProperty("ecp.scanBeanCache.enable", "true"));
    private static final int LOG_THRESHOLD = Integer.parseInt(System.getProperty("ecp.starcost.threshold", "100"));
    private static final String ROOT_PACKAGE = System.getProperty("ecp.scanBeanCache.rootPackage", "com/ygsoft").replace('.', '/');
    private static volatile boolean ROOT_PACAKGE_SCAN_CACHED = false;
    private static Method equinoxResolveMethod;
    private static final int MATCH_ALL = 0;
    private static final int MATCH_HEADER = 2;
    private static final int MATCH_TAIL = 1;
    private static final int MATCH_MIDDLE = 3;
    private final ResourceLoader resourceLoader;
    private PathMatcher pathMatcher = new AntPathMatcher();
    private static Map<String, Resource[]> PACKAGE_RESOURCE_CACHE;

    static {
        try {
            Class<?> fileLocatorClass = ClassUtils.forName("org.eclipse.core.runtime.FileLocator", PathMatchingResourcePatternResolver.class.getClassLoader());
            equinoxResolveMethod = fileLocatorClass.getMethod("resolve", URL.class);
            logger.debug((Object)"Found Equinox FileLocator for OSGi bundle URL resolution");
        }
        catch (Throwable ex) {
            equinoxResolveMethod = null;
        }
        PACKAGE_RESOURCE_CACHE = new ConcurrentHashMap<String, Resource[]>(150);
    }

    public PathMatchingResourcePatternResolver() {
        this.resourceLoader = new DefaultResourceLoader();
    }

    public PathMatchingResourcePatternResolver(ResourceLoader resourceLoader) {
        Assert.notNull(resourceLoader, "ResourceLoader must not be null");
        this.resourceLoader = resourceLoader;
    }

    public PathMatchingResourcePatternResolver(ClassLoader classLoader) {
        this.resourceLoader = new DefaultResourceLoader(classLoader);
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.getResourceLoader().getClassLoader();
    }

    public void setPathMatcher(PathMatcher pathMatcher) {
        Assert.notNull(pathMatcher, "PathMatcher must not be null");
        this.pathMatcher = pathMatcher;
    }

    public PathMatcher getPathMatcher() {
        return this.pathMatcher;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getClassPath(String classUrl) {
        int alartMarkIndex = classUrl.lastIndexOf(33);
        if (alartMarkIndex >= 0) return classUrl.substring(alartMarkIndex + 1);
        int classRootPos = classUrl.indexOf("/target/classes/");
        if (classRootPos > 0) {
            int classRootStart = classRootPos + "/target/classes".length();
            return classUrl.substring(classRootStart);
        }
        classRootPos = classUrl.indexOf("/bin/main/");
        if (classRootPos > 0) {
            int classRootStart = classRootPos + "/bin/main".length();
            return classUrl.substring(classRootStart);
        }
        classRootPos = classUrl.indexOf("/target/test-classes/");
        if (classRootPos > 0) {
            int classRootStart = classRootPos + "/target/test-classes".length();
            return classUrl.substring(classRootStart);
        }
        classRootPos = classUrl.indexOf("/bin/");
        if (classRootPos <= 0) throw new RuntimeException("neither jar class nor target|bin/main|test-classes|bin class , uri=" + classUrl);
        int classRootStart = classRootPos + "/bin".length();
        return classUrl.substring(classRootStart);
    }

    private void ensureRootPackageCache(String basePackage) {
        if (!ROOT_PACAKGE_SCAN_CACHED && basePackage.length() > ROOT_PACKAGE.length() && basePackage.startsWith(ROOT_PACKAGE)) {
            if (PACKAGE_RESOURCE_CACHE.containsKey(ROOT_PACKAGE)) {
                ROOT_PACAKGE_SCAN_CACHED = true;
                return;
            }
            logger.warn((Object)("start caching root package[" + ROOT_PACKAGE + "] beans scan result, it may take serval seconds..."));
            String searchClassPath = "classpath*:/" + ROOT_PACKAGE + "/**/*.class";
            try {
                Resource[] resources = this.findPathMatchingResources(searchClassPath);
                PACKAGE_RESOURCE_CACHE.put(ROOT_PACKAGE, resources);
                logger.warn((Object)("end caching root package[" + ROOT_PACKAGE + "] beans scan result.size=" + resources.length));
            }
            catch (IOException e) {
                logger.error((Object)"ensureRootPackageCache failed", (Throwable)e);
            }
            ROOT_PACAKGE_SCAN_CACHED = true;
        }
    }

    private Resource[] getResourceCache(String basePackage, String resourcePattern) throws IOException {
        Resource[] resources = null;
        Resource[] tempResources = PACKAGE_RESOURCE_CACHE.get(basePackage);
        if (tempResources != null) {
            boolean matchType;
            if (resourcePattern.equals("**/*.class")) {
                return tempResources;
            }
            int lastSlashPos = resourcePattern.lastIndexOf(47);
            String clazzPattern = resourcePattern.substring(lastSlashPos + 1);
            if (clazzPattern.startsWith("*")) {
                clazzPattern = clazzPattern.substring(1);
                matchType = true;
            } else {
                matchType = false;
            }
            if (clazzPattern.indexOf(42) >= 0 || clazzPattern.indexOf(63) >= 0) {
                return resources;
            }
            LinkedHashSet<Resource> matchedResources = new LinkedHashSet<Resource>();
            Resource[] resourceArray = tempResources;
            int n = tempResources.length;
            int n2 = 0;
            while (n2 < n) {
                Resource tmpResource = resourceArray[n2];
                String url = tmpResource.getURL().toString();
                int slashPos = url.lastIndexOf(47);
                String targetClazz = url.substring(slashPos);
                if (matchType && targetClazz.endsWith(clazzPattern) || !matchType && targetClazz.equals(clazzPattern)) {
                    matchedResources.add(tmpResource);
                }
                ++n2;
            }
            int matchCount = matchedResources.size();
            Resource[] tmp = new Resource[matchCount];
            resources = matchedResources.toArray(tmp);
            logger.info((Object)("scan " + basePackage + " search " + resourcePattern + " found " + resources.length + " resource cache in same package"));
            return resources;
        }
        String tmpPattern = resourcePattern.substring(4);
        if (!tmpPattern.contains("*")) {
            this.ensureRootPackageCache(basePackage);
            Iterator<Map.Entry<String, Resource[]>> iterator = PACKAGE_RESOURCE_CACHE.entrySet().iterator();
            int matchPosition = 0;
            if (resourcePattern.startsWith("**/")) {
                matchPosition |= 2;
            }
            while (iterator.hasNext()) {
                Map.Entry<String, Resource[]> entry = iterator.next();
                if (!basePackage.startsWith(entry.getKey()) || entry.getKey().indexOf(42) >= 0 || entry.getKey().indexOf(63) >= 0) continue;
                int cachePackageLen = entry.getKey().length();
                String packagePostfix = basePackage.substring(cachePackageLen);
                if (packagePostfix.startsWith("/**")) {
                    int prefixStrlen = 3;
                    packagePostfix = packagePostfix.substring(3);
                    matchPosition |= 1;
                }
                if (packagePostfix.endsWith("/**")) {
                    packagePostfix = packagePostfix.substring(0, packagePostfix.length() - 2);
                    matchPosition |= 2;
                }
                if (packagePostfix.contains("*")) continue;
                packagePostfix = String.valueOf(packagePostfix.replace('.', '/')) + "/";
                Resource[] packageResources = entry.getValue();
                LinkedHashSet<Resource> matchedResources = new LinkedHashSet<Resource>();
                Resource[] resourceArray = packageResources;
                int n = packageResources.length;
                int slashPos = 0;
                while (slashPos < n) {
                    Resource tmpRes = resourceArray[slashPos];
                    String uri = tmpRes.getURL().toString();
                    if (uri.endsWith(tmpPattern)) {
                        String tmpClassPath = this.getClassPath(uri);
                        int lastSlashIndex = tmpClassPath.lastIndexOf("/");
                        String tmpPackage = tmpClassPath.substring(cachePackageLen + 1, lastSlashIndex + 1);
                        boolean matched = false;
                        matched = matchPosition == 2 ? tmpPackage.startsWith(packagePostfix) : (matchPosition == 1 ? tmpPackage.endsWith(packagePostfix) : (matchPosition == 3 ? tmpPackage.contains(packagePostfix) : tmpPackage.equals(basePackage)));
                        if (matched) {
                            matchedResources.add(tmpRes);
                        }
                    }
                    ++slashPos;
                }
                int matchCount = matchedResources.size();
                Resource[] tmp = new Resource[matchCount];
                resources = matchedResources.toArray(tmp);
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("scan " + basePackage + " search " + resourcePattern + "  found  " + resources.length + " resource cache in prefix package: " + entry.getKey()));
                }
                return resources;
            }
        }
        return null;
    }

    @Override
    public Resource getResource(String location) {
        return this.getResourceLoader().getResource(location);
    }

    @Override
    public Resource[] getResources(String locationPattern) throws IOException {
        Assert.notNull(locationPattern, "Location pattern must not be null");
        if (locationPattern.startsWith("classpath*:")) {
            boolean useClassResCache = ENABLE_SCAN_CACHE && locationPattern.endsWith(".class");
            String resourcePattern = null;
            String basePackage = null;
            Resource[] cacheResources = null;
            if (useClassResCache) {
                int lastSlashPos = locationPattern.lastIndexOf("/**/");
                resourcePattern = locationPattern.substring(lastSlashPos + 1);
                basePackage = locationPattern.substring("classpath*:".length(), lastSlashPos);
                cacheResources = this.getResourceCache(basePackage, resourcePattern);
                if (cacheResources != null) {
                    return cacheResources;
                }
            }
            Resource[] resources = this.getPathMatcher().isPattern(locationPattern.substring("classpath*:".length())) ? this.findPathMatchingResources(locationPattern) : this.findAllClassPathResources(locationPattern.substring("classpath*:".length()));
            if (useClassResCache && resourcePattern.equals("**/*.class")) {
                PACKAGE_RESOURCE_CACHE.put(basePackage, resources);
            }
            return resources;
        }
        int prefixEnd = locationPattern.indexOf(":") + 1;
        if (this.getPathMatcher().isPattern(locationPattern.substring(prefixEnd))) {
            return this.findPathMatchingResources(locationPattern);
        }
        return new Resource[]{this.getResourceLoader().getResource(locationPattern)};
    }

    protected Resource[] findAllClassPathResources(String location) throws IOException {
        String path = location;
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        Set<Resource> result = this.doFindAllClassPathResources(path);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Resolved classpath location [" + location + "] to resources " + result));
        }
        return result.toArray(new Resource[result.size()]);
    }

    protected Set<Resource> doFindAllClassPathResources(String path) throws IOException {
        LinkedHashSet<Resource> result = new LinkedHashSet<Resource>(16);
        ClassLoader cl = this.getClassLoader();
        Enumeration<URL> resourceUrls = cl != null ? cl.getResources(path) : ClassLoader.getSystemResources(path);
        while (resourceUrls.hasMoreElements()) {
            URL url = resourceUrls.nextElement();
            result.add(this.convertClassLoaderURL(url));
        }
        if ("".equals(path)) {
            this.addAllClassLoaderJarRoots(cl, result);
        }
        return result;
    }

    protected Resource convertClassLoaderURL(URL url) {
        return new UrlResource(url);
    }

    protected void addAllClassLoaderJarRoots(ClassLoader classLoader, Set<Resource> result) {
        block14: {
            block13: {
                if (classLoader instanceof URLClassLoader) {
                    try {
                        URL[] uRLArray = ((URLClassLoader)classLoader).getURLs();
                        int n = uRLArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            block12: {
                                URL url = uRLArray[n2];
                                if (ResourceUtils.isJarFileURL(url)) {
                                    try {
                                        UrlResource jarResource = new UrlResource("jar:" + url.toString() + "!/");
                                        if (jarResource.exists()) {
                                            result.add(jarResource);
                                        }
                                    }
                                    catch (MalformedURLException ex) {
                                        if (!logger.isDebugEnabled()) break block12;
                                        logger.debug((Object)("Cannot search for matching files underneath [" + url + "] because it cannot be converted to a valid 'jar:' URL: " + ex.getMessage()));
                                    }
                                }
                            }
                            ++n2;
                        }
                    }
                    catch (Exception ex) {
                        if (!logger.isDebugEnabled()) break block13;
                        logger.debug((Object)("Cannot introspect jar files since ClassLoader [" + classLoader + "] does not support 'getURLs()': " + ex));
                    }
                }
            }
            if (classLoader == ClassLoader.getSystemClassLoader()) {
                this.addClassPathManifestEntries(result);
            }
            if (classLoader != null) {
                try {
                    this.addAllClassLoaderJarRoots(classLoader.getParent(), result);
                }
                catch (Exception ex) {
                    if (!logger.isDebugEnabled()) break block14;
                    logger.debug((Object)("Cannot introspect jar files in parent ClassLoader since [" + classLoader + "] does not support 'getParent()': " + ex));
                }
            }
        }
    }

    protected void addClassPathManifestEntries(Set<Resource> result) {
        block7: {
            try {
                String javaClassPathProperty = System.getProperty("java.class.path");
                String[] stringArray = StringUtils.delimitedListToStringArray(javaClassPathProperty, System.getProperty("path.separator"));
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    block6: {
                        String url = stringArray[n2];
                        try {
                            UrlResource jarResource;
                            if (url.endsWith(".jar") && (jarResource = new UrlResource("jar:file:" + url + "!/")).exists()) {
                                result.add(jarResource);
                            }
                        }
                        catch (MalformedURLException ex) {
                            if (!logger.isDebugEnabled()) break block6;
                            logger.debug((Object)("Cannot search for matching files underneath [" + url + "] because it cannot be converted to a valid 'jar:' URL: " + ex.getMessage()));
                        }
                    }
                    ++n2;
                }
            }
            catch (Exception ex) {
                if (!logger.isDebugEnabled()) break block7;
                logger.debug((Object)("Failed to evaluate 'java.class.path' manifest entries: " + ex));
            }
        }
    }

    protected Resource[] findPathMatchingResources(String locationPattern) throws IOException {
        long cost;
        long start = System.currentTimeMillis();
        String rootDirPath = this.determineRootDir(locationPattern);
        String subPattern = locationPattern.substring(rootDirPath.length());
        Resource[] rootDirResources = this.getResources(rootDirPath);
        LinkedHashSet<Resource> result = new LinkedHashSet<Resource>(16);
        Resource[] resourceArray = rootDirResources;
        int n = rootDirResources.length;
        int n2 = 0;
        while (n2 < n) {
            Resource rootDirResource = resourceArray[n2];
            rootDirResource = this.resolveRootDirResource(rootDirResource);
            URL rootDirURL = rootDirResource.getURL();
            if (equinoxResolveMethod != null && rootDirURL.getProtocol().startsWith("bundle")) {
                rootDirURL = (URL)ReflectionUtils.invokeMethod(equinoxResolveMethod, null, rootDirURL);
                rootDirResource = new UrlResource(rootDirURL);
            }
            if (rootDirURL.getProtocol().startsWith("vfs")) {
                result.addAll(VfsResourceMatchingDelegate.findMatchingResources(rootDirURL, subPattern, this.getPathMatcher()));
            } else if (ResourceUtils.isJarURL(rootDirURL) || this.isJarResource(rootDirResource)) {
                result.addAll(this.doFindPathMatchingJarResources(rootDirResource, rootDirURL, subPattern));
            } else {
                result.addAll(this.doFindPathMatchingFileResources(rootDirResource, subPattern));
            }
            ++n2;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Resolved location pattern [" + locationPattern + "] to resources " + result));
        }
        if ((cost = System.currentTimeMillis() - start) >= (long)LOG_THRESHOLD) {
            this.startCostLogger.info((Object)("\tPathMatchingResourcePatternResolver\tfindPathMatchingResources\t" + cost + "\t" + locationPattern));
            logger.warn((Object)("locationPattern=" + locationPattern + ", cost=" + cost));
        }
        return result.toArray(new Resource[result.size()]);
    }

    protected String determineRootDir(String location) {
        int prefixEnd = location.indexOf(":") + 1;
        int rootDirEnd = location.length();
        while (rootDirEnd > prefixEnd && this.getPathMatcher().isPattern(location.substring(prefixEnd, rootDirEnd))) {
            rootDirEnd = location.lastIndexOf(47, rootDirEnd - 2) + 1;
        }
        if (rootDirEnd == 0) {
            rootDirEnd = prefixEnd;
        }
        return location.substring(0, rootDirEnd);
    }

    protected Resource resolveRootDirResource(Resource original) throws IOException {
        return original;
    }

    protected boolean isJarResource(Resource resource) throws IOException {
        return false;
    }

    protected Set<Resource> doFindPathMatchingJarResources(Resource rootDirResource, URL rootDirURL, String subPattern) throws IOException {
        boolean closeJarFile;
        String rootEntryPath;
        String jarFileUrl;
        JarFile jarFile;
        Set<Resource> result = this.doFindPathMatchingJarResources(rootDirResource, subPattern);
        if (result != null) {
            return result;
        }
        URLConnection con = rootDirURL.openConnection();
        if (con instanceof JarURLConnection) {
            JarURLConnection jarCon = (JarURLConnection)con;
            ResourceUtils.useCachesIfNecessary(jarCon);
            jarFile = jarCon.getJarFile();
            jarFileUrl = jarCon.getJarFileURL().toExternalForm();
            JarEntry jarEntry = jarCon.getJarEntry();
            rootEntryPath = jarEntry != null ? jarEntry.getName() : "";
            closeJarFile = !jarCon.getUseCaches();
        } else {
            String urlFile = rootDirURL.getFile();
            try {
                int separatorIndex = urlFile.indexOf("!/");
                if (separatorIndex != -1) {
                    jarFileUrl = urlFile.substring(0, separatorIndex);
                    rootEntryPath = urlFile.substring(separatorIndex + "!/".length());
                    jarFile = this.getJarFile(jarFileUrl);
                } else {
                    jarFile = new JarFile(urlFile);
                    jarFileUrl = urlFile;
                    rootEntryPath = "";
                }
                closeJarFile = true;
            }
            catch (ZipException ex) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Skipping invalid jar classpath entry [" + urlFile + "]"));
                }
                return Collections.emptySet();
            }
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Looking for matching resources in jar file [" + jarFileUrl + "]"));
            }
            if (!"".equals(rootEntryPath) && !rootEntryPath.endsWith("/")) {
                rootEntryPath = String.valueOf(rootEntryPath) + "/";
            }
            result = new LinkedHashSet<Resource>(8);
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String entryPath = entry.getName();
                if (!entryPath.startsWith(rootEntryPath)) continue;
                String relativePath = entryPath.substring(rootEntryPath.length());
                if (!this.getPathMatcher().match(subPattern, relativePath)) continue;
                result.add(rootDirResource.createRelative(relativePath));
            }
            Set<Resource> set = result;
            return set;
        }
        finally {
            if (closeJarFile) {
                jarFile.close();
            }
        }
    }

    @Deprecated
    protected Set<Resource> doFindPathMatchingJarResources(Resource rootDirResource, String subPattern) throws IOException {
        return null;
    }

    protected JarFile getJarFile(String jarFileUrl) throws IOException {
        if (jarFileUrl.startsWith("file:")) {
            try {
                return new JarFile(ResourceUtils.toURI(jarFileUrl).getSchemeSpecificPart());
            }
            catch (URISyntaxException ex) {
                return new JarFile(jarFileUrl.substring("file:".length()));
            }
        }
        return new JarFile(jarFileUrl);
    }

    protected Set<Resource> doFindPathMatchingFileResources(Resource rootDirResource, String subPattern) throws IOException {
        File rootDir;
        try {
            rootDir = rootDirResource.getFile().getAbsoluteFile();
        }
        catch (IOException ex) {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("Cannot search for matching files underneath " + rootDirResource + " because it does not correspond to a directory in the file system"), (Throwable)ex);
            }
            return Collections.emptySet();
        }
        return this.doFindMatchingFileSystemResources(rootDir, subPattern);
    }

    protected Set<Resource> doFindMatchingFileSystemResources(File rootDir, String subPattern) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Looking for matching resources in directory tree [" + rootDir.getPath() + "]"));
        }
        Set<File> matchingFiles = this.retrieveMatchingFiles(rootDir, subPattern);
        LinkedHashSet<Resource> result = new LinkedHashSet<Resource>(matchingFiles.size());
        for (File file : matchingFiles) {
            result.add(new FileSystemResource(file));
        }
        return result;
    }

    protected Set<File> retrieveMatchingFiles(File rootDir, String pattern) throws IOException {
        if (!rootDir.exists()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Skipping [" + rootDir.getAbsolutePath() + "] because it does not exist"));
            }
            return Collections.emptySet();
        }
        if (!rootDir.isDirectory()) {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("Skipping [" + rootDir.getAbsolutePath() + "] because it does not denote a directory"));
            }
            return Collections.emptySet();
        }
        if (!rootDir.canRead()) {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("Cannot search for matching files underneath directory [" + rootDir.getAbsolutePath() + "] because the application is not allowed to read the directory"));
            }
            return Collections.emptySet();
        }
        String fullPattern = StringUtils.replace(rootDir.getAbsolutePath(), File.separator, "/");
        if (!pattern.startsWith("/")) {
            fullPattern = String.valueOf(fullPattern) + "/";
        }
        fullPattern = String.valueOf(fullPattern) + StringUtils.replace(pattern, File.separator, "/");
        LinkedHashSet<File> result = new LinkedHashSet<File>(8);
        this.doRetrieveMatchingFiles(fullPattern, rootDir, result);
        return result;
    }

    protected void doRetrieveMatchingFiles(String fullPattern, File dir, Set<File> result) throws IOException {
        Object[] dirContents;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Searching directory [" + dir.getAbsolutePath() + "] for files matching pattern [" + fullPattern + "]"));
        }
        if ((dirContents = dir.listFiles()) == null) {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("Could not retrieve contents of directory [" + dir.getAbsolutePath() + "]"));
            }
            return;
        }
        Arrays.sort(dirContents);
        Object[] objectArray = dirContents;
        int n = dirContents.length;
        int n2 = 0;
        while (n2 < n) {
            Object content = objectArray[n2];
            String currPath = StringUtils.replace(((File)content).getAbsolutePath(), File.separator, "/");
            if (((File)content).isDirectory() && this.getPathMatcher().matchStart(fullPattern, String.valueOf(currPath) + "/")) {
                if (!((File)content).canRead()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Skipping subdirectory [" + dir.getAbsolutePath() + "] because the application is not allowed to read the directory"));
                    }
                } else {
                    this.doRetrieveMatchingFiles(fullPattern, (File)content, result);
                }
            }
            if (this.getPathMatcher().match(fullPattern, currPath)) {
                result.add((File)content);
            }
            ++n2;
        }
    }

    private static class PatternVirtualFileVisitor
    implements InvocationHandler {
        private final String subPattern;
        private final PathMatcher pathMatcher;
        private final String rootPath;
        private final Set<Resource> resources = new LinkedHashSet<Resource>();

        public PatternVirtualFileVisitor(String rootPath, String subPattern, PathMatcher pathMatcher) {
            this.subPattern = subPattern;
            this.pathMatcher = pathMatcher;
            this.rootPath = rootPath.length() == 0 || rootPath.endsWith("/") ? rootPath : String.valueOf(rootPath) + "/";
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if (Object.class == method.getDeclaringClass()) {
                if (methodName.equals("equals")) {
                    if (proxy == args[0]) {
                        return true;
                    }
                    return false;
                }
                if (methodName.equals("hashCode")) {
                    return System.identityHashCode(proxy);
                }
            } else {
                if ("getAttributes".equals(methodName)) {
                    return this.getAttributes();
                }
                if ("visit".equals(methodName)) {
                    this.visit(args[0]);
                    return null;
                }
                if ("toString".equals(methodName)) {
                    return this.toString();
                }
            }
            throw new IllegalStateException("Unexpected method invocation: " + method);
        }

        public void visit(Object vfsResource) {
            if (this.pathMatcher.match(this.subPattern, VfsPatternUtils.getPath(vfsResource).substring(this.rootPath.length()))) {
                this.resources.add(new VfsResource(vfsResource));
            }
        }

        public Object getAttributes() {
            return VfsPatternUtils.getVisitorAttribute();
        }

        public Set<Resource> getResources() {
            return this.resources;
        }

        public int size() {
            return this.resources.size();
        }

        public String toString() {
            return "sub-pattern: " + this.subPattern + ", resources: " + this.resources;
        }
    }

    private static class VfsResourceMatchingDelegate {
        private VfsResourceMatchingDelegate() {
        }

        public static Set<Resource> findMatchingResources(URL rootDirURL, String locationPattern, PathMatcher pathMatcher) throws IOException {
            Object root = VfsPatternUtils.findRoot(rootDirURL);
            PatternVirtualFileVisitor visitor = new PatternVirtualFileVisitor(VfsPatternUtils.getPath(root), locationPattern, pathMatcher);
            VfsPatternUtils.visit(root, visitor);
            return visitor.getResources();
        }
    }
}

