/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.cert.crmf.bc;

import java.io.OutputStream;
import java.security.SecureRandom;
import org.bouncycastle162.asn1.ASN1ObjectIdentifier;
import org.bouncycastle162.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle162.cert.crmf.CRMFException;
import org.bouncycastle162.cert.crmf.bc.CRMFHelper;
import org.bouncycastle162.crypto.CipherKeyGenerator;
import org.bouncycastle162.crypto.CryptoServicesRegistrar;
import org.bouncycastle162.crypto.params.KeyParameter;
import org.bouncycastle162.crypto.util.CipherFactory;
import org.bouncycastle162.operator.GenericKey;
import org.bouncycastle162.operator.OutputEncryptor;

public class BcCRMFEncryptorBuilder {
    private final ASN1ObjectIdentifier encryptionOID;
    private final int keySize;
    private CRMFHelper helper = new CRMFHelper();
    private SecureRandom random;

    public BcCRMFEncryptorBuilder(ASN1ObjectIdentifier encryptionOID) {
        this(encryptionOID, -1);
    }

    public BcCRMFEncryptorBuilder(ASN1ObjectIdentifier encryptionOID, int keySize) {
        this.encryptionOID = encryptionOID;
        this.keySize = keySize;
    }

    public BcCRMFEncryptorBuilder setSecureRandom(SecureRandom random) {
        this.random = random;
        return this;
    }

    public OutputEncryptor build() throws CRMFException {
        return new CRMFOutputEncryptor(this.encryptionOID, this.keySize, this.random);
    }

    private class CRMFOutputEncryptor
    implements OutputEncryptor {
        private KeyParameter encKey;
        private AlgorithmIdentifier algorithmIdentifier;
        private Object cipher;

        CRMFOutputEncryptor(ASN1ObjectIdentifier encryptionOID, int keySize, SecureRandom random) throws CRMFException {
            if (random == null) {
                random = CryptoServicesRegistrar.getSecureRandom();
            }
            CipherKeyGenerator keyGen = BcCRMFEncryptorBuilder.this.helper.createKeyGenerator(encryptionOID, random);
            this.encKey = new KeyParameter(keyGen.generateKey());
            this.algorithmIdentifier = BcCRMFEncryptorBuilder.this.helper.generateEncryptionAlgID(encryptionOID, this.encKey, random);
            BcCRMFEncryptorBuilder.this.helper;
            this.cipher = CRMFHelper.createContentCipher(true, this.encKey, this.algorithmIdentifier);
        }

        public AlgorithmIdentifier getAlgorithmIdentifier() {
            return this.algorithmIdentifier;
        }

        public OutputStream getOutputStream(OutputStream dOut) {
            return CipherFactory.createOutputStream(dOut, this.cipher);
        }

        public GenericKey getKey() {
            return new GenericKey(this.algorithmIdentifier, this.encKey.getKey());
        }
    }
}

