/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.cms;

import org.bouncycastle162.asn1.ASN1ObjectIdentifier;
import org.bouncycastle162.asn1.ASN1Sequence;
import org.bouncycastle162.asn1.DERNull;
import org.bouncycastle162.asn1.DEROctetString;
import org.bouncycastle162.asn1.cms.KeyAgreeRecipientInfo;
import org.bouncycastle162.asn1.cms.OriginatorIdentifierOrKey;
import org.bouncycastle162.asn1.cms.OriginatorPublicKey;
import org.bouncycastle162.asn1.cms.RecipientInfo;
import org.bouncycastle162.asn1.cryptopro.CryptoProObjectIdentifiers;
import org.bouncycastle162.asn1.cryptopro.Gost2814789KeyWrapParameters;
import org.bouncycastle162.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle162.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle162.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle162.cms.CMSException;
import org.bouncycastle162.cms.CMSUtils;
import org.bouncycastle162.cms.RecipientInfoGenerator;
import org.bouncycastle162.operator.GenericKey;

public abstract class KeyAgreeRecipientInfoGenerator
implements RecipientInfoGenerator {
    private ASN1ObjectIdentifier keyAgreementOID;
    private ASN1ObjectIdentifier keyEncryptionOID;
    private SubjectPublicKeyInfo originatorKeyInfo;

    protected KeyAgreeRecipientInfoGenerator(ASN1ObjectIdentifier keyAgreementOID, SubjectPublicKeyInfo originatorKeyInfo, ASN1ObjectIdentifier keyEncryptionOID) {
        this.originatorKeyInfo = originatorKeyInfo;
        this.keyAgreementOID = keyAgreementOID;
        this.keyEncryptionOID = keyEncryptionOID;
    }

    public RecipientInfo generate(GenericKey contentEncryptionKey) throws CMSException {
        OriginatorIdentifierOrKey originator = new OriginatorIdentifierOrKey(this.createOriginatorPublicKey(this.originatorKeyInfo));
        AlgorithmIdentifier keyEncAlg = CMSUtils.isDES(this.keyEncryptionOID.getId()) || this.keyEncryptionOID.equals(PKCSObjectIdentifiers.id_alg_CMSRC2wrap) ? new AlgorithmIdentifier(this.keyEncryptionOID, DERNull.INSTANCE) : (CMSUtils.isGOST(this.keyAgreementOID) ? new AlgorithmIdentifier(this.keyEncryptionOID, new Gost2814789KeyWrapParameters(CryptoProObjectIdentifiers.id_Gost28147_89_CryptoPro_A_ParamSet)) : new AlgorithmIdentifier(this.keyEncryptionOID));
        AlgorithmIdentifier keyAgreeAlg = new AlgorithmIdentifier(this.keyAgreementOID, keyEncAlg);
        ASN1Sequence recipients = this.generateRecipientEncryptedKeys(keyAgreeAlg, keyEncAlg, contentEncryptionKey);
        byte[] userKeyingMaterial = this.getUserKeyingMaterial(keyAgreeAlg);
        if (userKeyingMaterial != null) {
            return new RecipientInfo(new KeyAgreeRecipientInfo(originator, new DEROctetString(userKeyingMaterial), keyAgreeAlg, recipients));
        }
        return new RecipientInfo(new KeyAgreeRecipientInfo(originator, null, keyAgreeAlg, recipients));
    }

    protected OriginatorPublicKey createOriginatorPublicKey(SubjectPublicKeyInfo originatorKeyInfo) {
        return new OriginatorPublicKey(new AlgorithmIdentifier(originatorKeyInfo.getAlgorithm().getAlgorithm(), DERNull.INSTANCE), originatorKeyInfo.getPublicKeyData().getBytes());
    }

    protected abstract ASN1Sequence generateRecipientEncryptedKeys(AlgorithmIdentifier var1, AlgorithmIdentifier var2, GenericKey var3) throws CMSException;

    protected abstract byte[] getUserKeyingMaterial(AlgorithmIdentifier var1) throws CMSException;
}

