/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.cms.jcajce;

import java.security.PrivateKey;
import java.security.Provider;
import javax.crypto.SecretKey;
import org.bouncycastle162.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle162.cms.jcajce.CMSUtils;
import org.bouncycastle162.cms.jcajce.JcaJceExtHelper;
import org.bouncycastle162.jcajce.util.ProviderJcaJceHelper;
import org.bouncycastle162.operator.SymmetricKeyUnwrapper;
import org.bouncycastle162.operator.jcajce.JceAsymmetricKeyUnwrapper;
import org.bouncycastle162.operator.jcajce.JceKTSKeyUnwrapper;
import org.bouncycastle162.operator.jcajce.JceSymmetricKeyUnwrapper;

class ProviderJcaJceExtHelper
extends ProviderJcaJceHelper
implements JcaJceExtHelper {
    public ProviderJcaJceExtHelper(Provider provider) {
        super(provider);
    }

    public JceAsymmetricKeyUnwrapper createAsymmetricUnwrapper(AlgorithmIdentifier keyEncryptionAlgorithm, PrivateKey keyEncryptionKey) {
        keyEncryptionKey = CMSUtils.cleanPrivateKey(keyEncryptionKey);
        return new JceAsymmetricKeyUnwrapper(keyEncryptionAlgorithm, keyEncryptionKey).setProvider(this.provider);
    }

    public JceKTSKeyUnwrapper createAsymmetricUnwrapper(AlgorithmIdentifier keyEncryptionAlgorithm, PrivateKey keyEncryptionKey, byte[] partyUInfo, byte[] partyVInfo) {
        keyEncryptionKey = CMSUtils.cleanPrivateKey(keyEncryptionKey);
        return new JceKTSKeyUnwrapper(keyEncryptionAlgorithm, keyEncryptionKey, partyUInfo, partyVInfo).setProvider(this.provider);
    }

    public SymmetricKeyUnwrapper createSymmetricUnwrapper(AlgorithmIdentifier keyEncryptionAlgorithm, SecretKey keyEncryptionKey) {
        return new JceSymmetricKeyUnwrapper(keyEncryptionAlgorithm, keyEncryptionKey).setProvider(this.provider);
    }
}

