/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.crypto.digests;

import org.bouncycastle162.crypto.digests.SHAKEDigest;
import org.bouncycastle162.util.Arrays;

public class CSHAKEDigest
extends SHAKEDigest {
    private static final byte[] padding = new byte[100];
    private final byte[] diff;

    public CSHAKEDigest(int bitLength, byte[] N, byte[] S) {
        super(bitLength);
        if (!(N != null && N.length != 0 || S != null && S.length != 0)) {
            this.diff = null;
        } else {
            this.diff = Arrays.concatenate(CSHAKEDigest.leftEncode(this.rate / 8), this.encodeString(N), this.encodeString(S));
            this.diffPadAndAbsorb();
        }
    }

    private void diffPadAndAbsorb() {
        int required;
        int blockSize = this.rate / 8;
        this.absorb(this.diff, 0, this.diff.length);
        for (required = blockSize - this.diff.length % blockSize; required > padding.length; required -= padding.length) {
            this.absorb(padding, 0, padding.length);
        }
        this.absorb(padding, 0, required);
    }

    private byte[] encodeString(byte[] str) {
        if (str == null || str.length == 0) {
            return CSHAKEDigest.leftEncode(0L);
        }
        return Arrays.concatenate(CSHAKEDigest.leftEncode((long)str.length * 8L), str);
    }

    private static byte[] leftEncode(long strLen) {
        int n = 1;
        long v = strLen;
        while ((v >>= 8) != 0L) {
            n = (byte)(n + 1);
        }
        byte[] b = new byte[n + 1];
        b[0] = n;
        for (int i = 1; i <= n; ++i) {
            b[i] = (byte)(strLen >> 8 * (n - i));
        }
        return b;
    }

    public int doOutput(byte[] out, int outOff, int outLen) {
        if (this.diff != null) {
            if (!this.squeezing) {
                this.absorbBits(0, 2);
            }
            this.squeeze(out, outOff, (long)outLen * 8L);
            return outLen;
        }
        return super.doOutput(out, outOff, outLen);
    }

    public void reset() {
        super.reset();
        if (this.diff != null) {
            this.diffPadAndAbsorb();
        }
    }
}

