/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.crypto.parsers;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import org.bouncycastle162.crypto.KeyParser;
import org.bouncycastle162.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle162.crypto.params.DHParameters;
import org.bouncycastle162.crypto.params.DHPublicKeyParameters;
import org.bouncycastle162.util.io.Streams;

public class DHIESPublicKeyParser
implements KeyParser {
    private DHParameters dhParams;

    public DHIESPublicKeyParser(DHParameters dhParams) {
        this.dhParams = dhParams;
    }

    public AsymmetricKeyParameter readKey(InputStream stream) throws IOException {
        byte[] V = new byte[(this.dhParams.getP().bitLength() + 7) / 8];
        Streams.readFully(stream, V, 0, V.length);
        return new DHPublicKeyParameters(new BigInteger(1, V), this.dhParams);
    }
}

