/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.crypto.test;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.bouncycastle162.crypto.BlockCipher;
import org.bouncycastle162.crypto.engines.AESEngine;
import org.bouncycastle162.crypto.engines.AESFastEngine;
import org.bouncycastle162.crypto.engines.AESLightEngine;
import org.bouncycastle162.crypto.params.KeyParameter;
import org.bouncycastle162.crypto.test.BlockCipherVectorTest;
import org.bouncycastle162.util.encoders.Hex;
import org.bouncycastle162.util.test.SimpleTestResult;
import org.bouncycastle162.util.test.Test;
import org.bouncycastle162.util.test.TestResult;

public class AESVectorFileTest
implements Test {
    private int countOfTests = 0;
    private int testNum = 0;
    private static final String[] zipFileNames = new String[]{"rijn.tv.ecbnk.zip", "rijn.tv.ecbnt.zip", "rijn.tv.ecbvk.zip", "rijn.tv.ecbvt.zip"};

    protected BlockCipher createNewEngineForTest() {
        return new AESEngine();
    }

    private Test[] readTestVectors(InputStream inStream) {
        ArrayList<BlockCipherVectorTest> tests = new ArrayList<BlockCipherVectorTest>();
        String key = null;
        String plaintext = null;
        String ciphertext = null;
        BufferedReader in = new BufferedReader(new InputStreamReader(inStream));
        try {
            String line = in.readLine();
            while (line != null) {
                int i;
                if ((line = line.trim().toLowerCase()).startsWith("blocksize=")) {
                    i = 0;
                    try {
                        i = Integer.parseInt(line.substring(10).trim());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (i != 128) {
                        return null;
                    }
                } else if (line.startsWith("keysize=")) {
                    i = 0;
                    try {
                        i = Integer.parseInt(line.substring(10).trim());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (i != 128 && i != 192 && i != 256) {
                        return null;
                    }
                } else if (line.startsWith("key=")) {
                    key = line.substring(4).trim();
                } else if (line.startsWith("pt=")) {
                    plaintext = line.substring(3).trim();
                } else if (line.startsWith("ct=")) {
                    ciphertext = line.substring(3).trim();
                } else if (line.startsWith("test=") && key != null && plaintext != null && ciphertext != null) {
                    tests.add(new BlockCipherVectorTest(this.testNum++, this.createNewEngineForTest(), new KeyParameter(Hex.decode(key)), plaintext, ciphertext));
                }
                line = in.readLine();
            }
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (key != null && plaintext != null && ciphertext != null) {
            tests.add(new BlockCipherVectorTest(this.testNum++, this.createNewEngineForTest(), new KeyParameter(Hex.decode(key)), plaintext, ciphertext));
        }
        return tests.toArray(new Test[tests.size()]);
    }

    public String getName() {
        return "AES";
    }

    private TestResult performTestsFromZipFile(File zfile) {
        try {
            ZipFile inZip = new ZipFile(zfile);
            Enumeration<? extends ZipEntry> files = inZip.entries();
            while (files.hasMoreElements()) {
                Test[] tests = null;
                try {
                    tests = this.readTestVectors(inZip.getInputStream(files.nextElement()));
                }
                catch (Exception e) {
                    return new SimpleTestResult(false, this.getName() + ": threw " + e);
                }
                if (tests == null) continue;
                for (int i = 0; i != tests.length; ++i) {
                    TestResult res = tests[i].perform();
                    ++this.countOfTests;
                    if (res.isSuccessful()) continue;
                    return res;
                }
            }
            inZip.close();
            return new SimpleTestResult(true, this.getName() + ": Okay");
        }
        catch (Exception e) {
            return new SimpleTestResult(false, this.getName() + ": threw " + e);
        }
    }

    public TestResult perform() {
        this.countOfTests = 0;
        for (int i = 0; i < zipFileNames.length; ++i) {
            File inf = new File(zipFileNames[i]);
            TestResult res = this.performTestsFromZipFile(inf);
            if (res.isSuccessful()) continue;
            return res;
        }
        return new SimpleTestResult(true, this.getName() + ": " + this.countOfTests + " performed Okay");
    }

    public static void main(String[] args) {
        AESVectorFileTest test = new AESVectorFileTest();
        TestResult result = test.perform();
        System.out.println(result);
        test = new AESLightVectorFileTest();
        result = test.perform();
        System.out.println(result);
        test = new AESFastVectorFileTest();
        result = test.perform();
        System.out.println(result);
    }

    private static class AESFastVectorFileTest
    extends AESVectorFileTest {
        private AESFastVectorFileTest() {
        }

        protected BlockCipher createNewEngineForTest() {
            return new AESFastEngine();
        }

        public String getName() {
            return "AESFast";
        }
    }

    private static class AESLightVectorFileTest
    extends AESVectorFileTest {
        private AESLightVectorFileTest() {
        }

        protected BlockCipher createNewEngineForTest() {
            return new AESLightEngine();
        }

        public String getName() {
            return "AESLight";
        }
    }
}

