/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.crypto.test;

import org.bouncycastle162.crypto.BlockCipher;
import org.bouncycastle162.crypto.BufferedBlockCipher;
import org.bouncycastle162.crypto.CipherParameters;
import org.bouncycastle162.crypto.DataLengthException;
import org.bouncycastle162.crypto.InvalidCipherTextException;
import org.bouncycastle162.crypto.engines.AESEngine;
import org.bouncycastle162.crypto.engines.DESEngine;
import org.bouncycastle162.crypto.engines.SkipjackEngine;
import org.bouncycastle162.crypto.modes.CBCBlockCipher;
import org.bouncycastle162.crypto.modes.CTSBlockCipher;
import org.bouncycastle162.crypto.modes.OldCTSBlockCipher;
import org.bouncycastle162.crypto.modes.SICBlockCipher;
import org.bouncycastle162.crypto.params.KeyParameter;
import org.bouncycastle162.crypto.params.ParametersWithIV;
import org.bouncycastle162.util.encoders.Hex;
import org.bouncycastle162.util.test.SimpleTest;

public class CTSTest
extends SimpleTest {
    static byte[] in1 = Hex.decode("4e6f7720697320746865207420");
    static byte[] in2 = Hex.decode("000102030405060708090a0b0c0d0e0fff0102030405060708090a0b0c0d0e0f0aaa");
    static byte[] out1 = Hex.decode("9952f131588465033fa40e8a98");
    static byte[] out2 = Hex.decode("358f84d01eb42988dc34efb994");
    static byte[] out3 = Hex.decode("170171cfad3f04530c509b0c1f0be0aefbd45a8e3755a873bff5ea198504b71683c6");

    private void testCTS(int id, BlockCipher cipher, CipherParameters params, byte[] input, byte[] output) throws Exception {
        byte[] out = new byte[input.length];
        CTSBlockCipher engine = new CTSBlockCipher(cipher);
        engine.init(true, params);
        int len = ((BufferedBlockCipher)engine).processBytes(input, 0, input.length, out, 0);
        ((BufferedBlockCipher)engine).doFinal(out, len);
        if (!this.areEqual(output, out)) {
            this.fail("failed encryption expected " + new String(Hex.encode(output)) + " got " + new String(Hex.encode(out)));
        }
        engine.init(false, params);
        len = ((BufferedBlockCipher)engine).processBytes(output, 0, output.length, out, 0);
        ((BufferedBlockCipher)engine).doFinal(out, len);
        if (!this.areEqual(input, out)) {
            this.fail("failed decryption expected " + new String(Hex.encode(input)) + " got " + new String(Hex.encode(out)));
        }
    }

    private void testOldCTS(int id, BlockCipher cipher, CipherParameters params, byte[] input, byte[] output) throws Exception {
        byte[] out = new byte[input.length];
        OldCTSBlockCipher engine = new OldCTSBlockCipher(cipher);
        engine.init(true, params);
        int len = ((BufferedBlockCipher)engine).processBytes(input, 0, input.length, out, 0);
        ((BufferedBlockCipher)engine).doFinal(out, len);
        if (!this.areEqual(output, out)) {
            this.fail("failed encryption expected " + new String(Hex.encode(output)) + " got " + new String(Hex.encode(out)));
        }
        engine.init(false, params);
        len = ((BufferedBlockCipher)engine).processBytes(output, 0, output.length, out, 0);
        ((BufferedBlockCipher)engine).doFinal(out, len);
        if (!this.areEqual(input, out)) {
            this.fail("failed decryption expected " + new String(Hex.encode(input)) + " got " + new String(Hex.encode(out)));
        }
    }

    private void testExceptions() throws InvalidCipherTextException {
        CTSBlockCipher engine = new CTSBlockCipher(new DESEngine());
        KeyParameter params = new KeyParameter(new byte[engine.getBlockSize()]);
        engine.init(true, params);
        byte[] out = new byte[((BufferedBlockCipher)engine).getOutputSize(engine.getBlockSize())];
        ((BufferedBlockCipher)engine).processBytes(new byte[engine.getBlockSize() - 1], 0, engine.getBlockSize() - 1, out, 0);
        try {
            ((BufferedBlockCipher)engine).doFinal(out, 0);
            this.fail("Expected CTS encrypt error on < 1 block input");
        }
        catch (DataLengthException dataLengthException) {
            // empty catch block
        }
        engine.init(true, params);
        ((BufferedBlockCipher)engine).processBytes(new byte[engine.getBlockSize()], 0, engine.getBlockSize(), out, 0);
        try {
            ((BufferedBlockCipher)engine).doFinal(out, 0);
        }
        catch (DataLengthException e) {
            this.fail("Unexpected CTS encrypt error on == 1 block input");
        }
        engine.init(false, params);
        ((BufferedBlockCipher)engine).processBytes(new byte[engine.getBlockSize() - 1], 0, engine.getBlockSize() - 1, out, 0);
        try {
            ((BufferedBlockCipher)engine).doFinal(out, 0);
            this.fail("Expected CTS decrypt error on < 1 block input");
        }
        catch (DataLengthException e) {
            // empty catch block
        }
        engine.init(false, params);
        ((BufferedBlockCipher)engine).processBytes(new byte[engine.getBlockSize()], 0, engine.getBlockSize(), out, 0);
        try {
            ((BufferedBlockCipher)engine).doFinal(out, 0);
        }
        catch (DataLengthException e) {
            this.fail("Unexpected CTS decrypt error on == 1 block input");
        }
        try {
            new CTSBlockCipher(new SICBlockCipher(new AESEngine()));
            this.fail("Expected CTS construction error - only ECB/CBC supported.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public String getName() {
        return "CTS";
    }

    public void performTest() throws Exception {
        byte[] key1 = new byte[]{1, 35, 69, 103, -119, -85, -51, -17};
        byte[] key2 = new byte[]{1, 35, 69, 103, -119, -85, -51, -17, -18, -1};
        byte[] iv = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        this.testCTS(1, new DESEngine(), new KeyParameter(key1), in1, out1);
        this.testCTS(2, new CBCBlockCipher(new DESEngine()), new ParametersWithIV(new KeyParameter(key1), iv), in1, out2);
        this.testCTS(3, new CBCBlockCipher(new SkipjackEngine()), new ParametersWithIV(new KeyParameter(key2), iv), in2, out3);
        byte[] aes128 = Hex.decode("636869636b656e207465726979616b69");
        byte[] aesIn1 = Hex.decode("4920776f756c64206c696b652074686520");
        byte[] aesOut1 = Hex.decode("c6353568f2bf8cb4d8a580362da7ff7f97");
        byte[] aesIn2 = Hex.decode("4920776f756c64206c696b65207468652047656e6572616c20476175277320");
        byte[] aesOut2 = Hex.decode("fc00783e0efdb2c1d445d4c8eff7ed2297687268d6ecccc0c07b25e25ecfe5");
        byte[] aesIn3 = Hex.decode("4920776f756c64206c696b65207468652047656e6572616c2047617527732043");
        byte[] aesOut3 = Hex.decode("39312523a78662d5be7fcbcc98ebf5a897687268d6ecccc0c07b25e25ecfe584");
        this.testCTS(4, new CBCBlockCipher(new AESEngine()), new ParametersWithIV(new KeyParameter(aes128), new byte[16]), aesIn1, aesOut1);
        this.testCTS(5, new CBCBlockCipher(new AESEngine()), new ParametersWithIV(new KeyParameter(aes128), new byte[16]), aesIn2, aesOut2);
        this.testCTS(6, new CBCBlockCipher(new AESEngine()), new ParametersWithIV(new KeyParameter(aes128), new byte[16]), aesIn3, aesOut3);
        this.testOldCTS(4, new CBCBlockCipher(new AESEngine()), new ParametersWithIV(new KeyParameter(aes128), new byte[16]), aesIn1, aesOut1);
        this.testOldCTS(5, new CBCBlockCipher(new AESEngine()), new ParametersWithIV(new KeyParameter(aes128), new byte[16]), aesIn2, aesOut2);
        this.testOldCTS(6, new CBCBlockCipher(new AESEngine()), new ParametersWithIV(new KeyParameter(aes128), new byte[16]), aesIn3, aesOut3);
        byte[] aes1Block = Hex.decode("4920776f756c64206c696b6520746865");
        byte[] preErrata = Hex.decode("e7664c13ff28c965b0d2a0e7ec353706");
        byte[] pstErrata = Hex.decode("97687268d6ecccc0c07b25e25ecfe584");
        byte[] pstErrataNonZeroIV = Hex.decode("571f5108c53fe95ab52df783df933fa3");
        this.testCTS(7, new CBCBlockCipher(new AESEngine()), new ParametersWithIV(new KeyParameter(aes128), new byte[16]), aes1Block, pstErrata);
        this.testCTS(8, new CBCBlockCipher(new AESEngine()), new ParametersWithIV(new KeyParameter(aes128), aes1Block), aes1Block, pstErrataNonZeroIV);
        this.testOldCTS(9, new CBCBlockCipher(new AESEngine()), new ParametersWithIV(new KeyParameter(aes128), new byte[16]), aes1Block, preErrata);
        byte[] aes128b = Hex.decode("aafd12f659cae63489b479e5076ddec2f06cb58faafd12f6");
        byte[] aesIn1b = Hex.decode("000102030405060708090a0b0c0d0e0fff0102030405060708090a0b0c0d0e0f");
        byte[] aesOut1b = Hex.decode("6db2f802d99e1ef0a5940f306079e083cf87f4d8bb9d1abb36cdd9f44ead7d04");
        this.testCTS(10, new CBCBlockCipher(new AESEngine()), new ParametersWithIV(new KeyParameter(aes128b), Hex.decode("aafd12f659cae63489b479e5076ddec2")), aesIn1b, aesOut1b);
        this.testExceptions();
    }

    public static void main(String[] args) {
        CTSTest.runTest(new CTSTest());
    }
}

