/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.crypto.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import org.bouncycastle162.crypto.BlockCipher;
import org.bouncycastle162.crypto.BufferedBlockCipher;
import org.bouncycastle162.crypto.CipherParameters;
import org.bouncycastle162.crypto.StreamCipher;
import org.bouncycastle162.crypto.engines.AESEngine;
import org.bouncycastle162.crypto.engines.BlowfishEngine;
import org.bouncycastle162.crypto.engines.CAST5Engine;
import org.bouncycastle162.crypto.engines.CAST6Engine;
import org.bouncycastle162.crypto.engines.CamelliaEngine;
import org.bouncycastle162.crypto.engines.ChaChaEngine;
import org.bouncycastle162.crypto.engines.DESEngine;
import org.bouncycastle162.crypto.engines.DESedeEngine;
import org.bouncycastle162.crypto.engines.Grain128Engine;
import org.bouncycastle162.crypto.engines.Grainv1Engine;
import org.bouncycastle162.crypto.engines.HC128Engine;
import org.bouncycastle162.crypto.engines.HC256Engine;
import org.bouncycastle162.crypto.engines.NoekeonEngine;
import org.bouncycastle162.crypto.engines.RC2Engine;
import org.bouncycastle162.crypto.engines.RC4Engine;
import org.bouncycastle162.crypto.engines.RC6Engine;
import org.bouncycastle162.crypto.engines.SEEDEngine;
import org.bouncycastle162.crypto.engines.Salsa20Engine;
import org.bouncycastle162.crypto.engines.SerpentEngine;
import org.bouncycastle162.crypto.engines.TEAEngine;
import org.bouncycastle162.crypto.engines.ThreefishEngine;
import org.bouncycastle162.crypto.engines.TwofishEngine;
import org.bouncycastle162.crypto.engines.XSalsa20Engine;
import org.bouncycastle162.crypto.engines.XTEAEngine;
import org.bouncycastle162.crypto.io.CipherInputStream;
import org.bouncycastle162.crypto.io.CipherOutputStream;
import org.bouncycastle162.crypto.io.InvalidCipherTextIOException;
import org.bouncycastle162.crypto.modes.AEADBlockCipher;
import org.bouncycastle162.crypto.modes.CBCBlockCipher;
import org.bouncycastle162.crypto.modes.CCMBlockCipher;
import org.bouncycastle162.crypto.modes.CFBBlockCipher;
import org.bouncycastle162.crypto.modes.CTSBlockCipher;
import org.bouncycastle162.crypto.modes.EAXBlockCipher;
import org.bouncycastle162.crypto.modes.NISTCTSBlockCipher;
import org.bouncycastle162.crypto.modes.OCBBlockCipher;
import org.bouncycastle162.crypto.modes.OFBBlockCipher;
import org.bouncycastle162.crypto.modes.SICBlockCipher;
import org.bouncycastle162.crypto.paddings.PKCS7Padding;
import org.bouncycastle162.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle162.crypto.params.KeyParameter;
import org.bouncycastle162.crypto.params.ParametersWithIV;
import org.bouncycastle162.util.Arrays;
import org.bouncycastle162.util.test.SimpleTest;

public class CipherStreamTest
extends SimpleTest {
    private int streamSize;

    public String getName() {
        return "CipherStreamTest";
    }

    private void testMode(Object cipher, CipherParameters params) throws Exception {
        this.testWriteRead(cipher, params, false);
        this.testWriteRead(cipher, params, true);
        this.testReadWrite(cipher, params, false);
        this.testReadWrite(cipher, params, true);
        if (!(cipher instanceof CTSBlockCipher) && !(cipher instanceof NISTCTSBlockCipher)) {
            this.testWriteReadEmpty(cipher, params, false);
            this.testWriteReadEmpty(cipher, params, true);
        }
        if (cipher instanceof AEADBlockCipher) {
            this.testTamperedRead((AEADBlockCipher)cipher, params);
            this.testTruncatedRead((AEADBlockCipher)cipher, params);
            this.testTamperedWrite((AEADBlockCipher)cipher, params);
        }
    }

    private OutputStream createCipherOutputStream(OutputStream output, Object cipher) {
        if (cipher instanceof BufferedBlockCipher) {
            return new CipherOutputStream(output, (BufferedBlockCipher)cipher);
        }
        if (cipher instanceof AEADBlockCipher) {
            return new CipherOutputStream(output, (AEADBlockCipher)cipher);
        }
        return new CipherOutputStream(output, (StreamCipher)cipher);
    }

    private InputStream createCipherInputStream(byte[] data, Object cipher) {
        ByteArrayInputStream input = new ByteArrayInputStream(data);
        if (cipher instanceof BufferedBlockCipher) {
            return new CipherInputStream((InputStream)input, (BufferedBlockCipher)cipher);
        }
        if (cipher instanceof AEADBlockCipher) {
            return new CipherInputStream((InputStream)input, (AEADBlockCipher)cipher);
        }
        return new CipherInputStream((InputStream)input, (StreamCipher)cipher);
    }

    private void testTamperedRead(AEADBlockCipher cipher, CipherParameters params) throws Exception {
        cipher.init(true, params);
        byte[] ciphertext = new byte[cipher.getOutputSize(this.streamSize)];
        cipher.doFinal(ciphertext, cipher.processBytes(new byte[this.streamSize], 0, this.streamSize, ciphertext, 0));
        ciphertext[0] = (byte)(ciphertext[0] + 1);
        cipher.init(false, params);
        InputStream input = this.createCipherInputStream(ciphertext, cipher);
        try {
            while (input.read() >= 0) {
            }
            this.fail("Expected invalid ciphertext after tamper and read : " + cipher.getAlgorithmName());
        }
        catch (InvalidCipherTextIOException invalidCipherTextIOException) {
            // empty catch block
        }
        try {
            input.close();
        }
        catch (Exception e) {
            this.fail("Unexpected exception after tamper and read : " + cipher.getAlgorithmName());
        }
    }

    private void testTruncatedRead(AEADBlockCipher cipher, CipherParameters params) throws Exception {
        InputStream input;
        block6: {
            int read;
            cipher.init(true, params);
            byte[] ciphertext = new byte[cipher.getOutputSize(this.streamSize)];
            cipher.doFinal(ciphertext, cipher.processBytes(new byte[this.streamSize], 0, this.streamSize, ciphertext, 0));
            byte[] truncated = new byte[ciphertext.length - this.streamSize - 1];
            System.arraycopy(ciphertext, 0, truncated, 0, truncated.length);
            cipher.init(false, params);
            input = this.createCipherInputStream(truncated, cipher);
            do {
                read = 0;
                try {
                    read = input.read();
                }
                catch (InvalidCipherTextIOException e) {
                    break block6;
                }
                catch (Exception e) {
                    this.fail("Unexpected exception  on truncated read : " + cipher.getAlgorithmName());
                    break block6;
                }
            } while (read >= 0);
            this.fail("Expected invalid ciphertext after truncate and read : " + cipher.getAlgorithmName());
        }
        try {
            input.close();
        }
        catch (Exception e) {
            this.fail("Unexpected exception after truncate and read : " + cipher.getAlgorithmName());
        }
    }

    private void testTamperedWrite(AEADBlockCipher cipher, CipherParameters params) throws Exception {
        cipher.init(true, params);
        byte[] ciphertext = new byte[cipher.getOutputSize(this.streamSize)];
        cipher.doFinal(ciphertext, cipher.processBytes(new byte[this.streamSize], 0, this.streamSize, ciphertext, 0));
        ciphertext[0] = (byte)(ciphertext[0] + 1);
        cipher.init(false, params);
        ByteArrayOutputStream plaintext = new ByteArrayOutputStream();
        OutputStream output = this.createCipherOutputStream(plaintext, cipher);
        for (int i = 0; i < ciphertext.length; ++i) {
            output.write(ciphertext[i]);
        }
        try {
            output.close();
            this.fail("Expected invalid ciphertext after tamper and write : " + cipher.getAlgorithmName());
        }
        catch (InvalidCipherTextIOException invalidCipherTextIOException) {
            // empty catch block
        }
    }

    private void testWriteRead(Object cipher, CipherParameters params, boolean blocks) throws Exception {
        byte[] data = new byte[this.streamSize];
        for (int i = 0; i < data.length; ++i) {
            data[i] = (byte)(i % 255);
        }
        this.testWriteRead(cipher, params, blocks, data);
    }

    private void testWriteReadEmpty(Object cipher, CipherParameters params, boolean blocks) throws Exception {
        byte[] data = new byte[]{};
        this.testWriteRead(cipher, params, blocks, data);
    }

    private void testWriteRead(Object cipher, CipherParameters params, boolean blocks, byte[] data) {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        try {
            this.init(cipher, true, params);
            OutputStream cOut = this.createCipherOutputStream(bOut, cipher);
            if (blocks) {
                int chunkSize = Math.max(1, data.length / 8);
                for (int i = 0; i < data.length; i += chunkSize) {
                    cOut.write(data, i, Math.min(chunkSize, data.length - i));
                }
            } else {
                for (int i = 0; i < data.length; ++i) {
                    cOut.write(data[i]);
                }
            }
            cOut.close();
            byte[] cipherText = bOut.toByteArray();
            bOut.reset();
            this.init(cipher, false, params);
            InputStream cIn = this.createCipherInputStream(cipherText, cipher);
            if (blocks) {
                int c;
                byte[] block = new byte[this.getBlockSize(cipher) + 1];
                while ((c = cIn.read(block)) >= 0) {
                    bOut.write(block, 0, c);
                }
            } else {
                int c;
                while ((c = cIn.read()) >= 0) {
                    bOut.write(c);
                }
            }
            cIn.close();
        }
        catch (Exception e) {
            this.fail("Unexpected exception " + this.getName(cipher), e);
        }
        byte[] decrypted = bOut.toByteArray();
        if (!Arrays.areEqual(data, decrypted)) {
            this.fail("Failed - decrypted data doesn't match: " + this.getName(cipher));
        }
    }

    private String getName(Object cipher) {
        if (cipher instanceof BufferedBlockCipher) {
            return ((BufferedBlockCipher)cipher).getUnderlyingCipher().getAlgorithmName();
        }
        if (cipher instanceof AEADBlockCipher) {
            return ((AEADBlockCipher)cipher).getUnderlyingCipher().getAlgorithmName();
        }
        if (cipher instanceof StreamCipher) {
            return ((StreamCipher)cipher).getAlgorithmName();
        }
        return null;
    }

    private int getBlockSize(Object cipher) {
        if (cipher instanceof BlockCipher) {
            return ((BlockCipher)cipher).getBlockSize();
        }
        if (cipher instanceof BufferedBlockCipher) {
            return ((BufferedBlockCipher)cipher).getBlockSize();
        }
        if (cipher instanceof AEADBlockCipher) {
            return ((AEADBlockCipher)cipher).getUnderlyingCipher().getBlockSize();
        }
        if (cipher instanceof StreamCipher) {
            return 1;
        }
        return 0;
    }

    private void init(Object cipher, boolean forEncrypt, CipherParameters params) {
        if (cipher instanceof BufferedBlockCipher) {
            ((BufferedBlockCipher)cipher).init(forEncrypt, params);
        } else if (cipher instanceof AEADBlockCipher) {
            ((AEADBlockCipher)cipher).init(forEncrypt, params);
        } else if (cipher instanceof StreamCipher) {
            ((StreamCipher)cipher).init(forEncrypt, params);
        }
    }

    protected void fail(String message, boolean authenticated, boolean bc) {
        if (bc || !authenticated) {
            super.fail(message);
        } else {
            System.err.println("Broken JCE Streams: " + message);
        }
    }

    private void testReadWrite(Object cipher, CipherParameters params, boolean blocks) throws Exception {
        String lCode = "ABCDEFGHIJKLMNOPQRSTU";
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        try {
            this.init(cipher, true, params);
            InputStream cIn = this.createCipherInputStream(lCode.getBytes(), cipher);
            ByteArrayOutputStream ct = new ByteArrayOutputStream();
            if (blocks) {
                int c;
                byte[] block = new byte[this.getBlockSize(cipher) + 1];
                while ((c = cIn.read(block)) >= 0) {
                    ct.write(block, 0, c);
                }
            } else {
                int c;
                while ((c = cIn.read()) >= 0) {
                    ct.write(c);
                }
            }
            cIn.close();
            this.init(cipher, false, params);
            ByteArrayInputStream dataIn = new ByteArrayInputStream(ct.toByteArray());
            OutputStream cOut = this.createCipherOutputStream(bOut, cipher);
            if (blocks) {
                int c;
                byte[] block = new byte[this.getBlockSize(cipher) + 1];
                while ((c = dataIn.read(block)) >= 0) {
                    cOut.write(block, 0, c);
                }
            } else {
                int c;
                while ((c = dataIn.read()) >= 0) {
                    cOut.write(c);
                }
            }
            cOut.flush();
            cOut.close();
        }
        catch (Exception e) {
            this.fail("Unexpected exception " + this.getName(cipher), e);
        }
        String res = new String(bOut.toByteArray());
        if (!res.equals(lCode)) {
            this.fail("Failed read/write - decrypted data doesn't match: " + this.getName(cipher), lCode, res);
        }
    }

    public void performTest() throws Exception {
        int[] testSizes = new int[]{0, 1, 7, 8, 9, 15, 16, 17, 1023, 1024, 1025, 2047, 2048, 2049, 4095, 4096, 4097};
        for (int i = 0; i < testSizes.length; ++i) {
            this.streamSize = testSizes[i];
            this.performTests();
        }
    }

    private void performTests() throws Exception {
        this.testModes(new BlowfishEngine(), new BlowfishEngine(), 16);
        this.testModes(new DESEngine(), new DESEngine(), 8);
        this.testModes(new DESedeEngine(), new DESedeEngine(), 24);
        this.testModes(new TEAEngine(), new TEAEngine(), 16);
        this.testModes(new CAST5Engine(), new CAST5Engine(), 16);
        this.testModes(new RC2Engine(), new RC2Engine(), 16);
        this.testModes(new XTEAEngine(), new XTEAEngine(), 16);
        this.testModes(new AESEngine(), new AESEngine(), 16);
        this.testModes(new NoekeonEngine(), new NoekeonEngine(), 16);
        this.testModes(new TwofishEngine(), new TwofishEngine(), 16);
        this.testModes(new CAST6Engine(), new CAST6Engine(), 16);
        this.testModes(new SEEDEngine(), new SEEDEngine(), 16);
        this.testModes(new SerpentEngine(), new SerpentEngine(), 16);
        this.testModes(new RC6Engine(), new RC6Engine(), 16);
        this.testModes(new CamelliaEngine(), new CamelliaEngine(), 16);
        this.testModes(new ThreefishEngine(512), new ThreefishEngine(512), 64);
        this.testMode(new RC4Engine(), new KeyParameter(new byte[16]));
        this.testMode(new Salsa20Engine(), new ParametersWithIV(new KeyParameter(new byte[16]), new byte[8]));
        this.testMode(new XSalsa20Engine(), new ParametersWithIV(new KeyParameter(new byte[32]), new byte[24]));
        this.testMode(new ChaChaEngine(), new ParametersWithIV(new KeyParameter(new byte[16]), new byte[8]));
        this.testMode(new Grainv1Engine(), new ParametersWithIV(new KeyParameter(new byte[16]), new byte[8]));
        this.testMode(new Grain128Engine(), new ParametersWithIV(new KeyParameter(new byte[16]), new byte[12]));
        this.testMode(new HC128Engine(), new KeyParameter(new byte[16]));
        this.testMode(new HC256Engine(), new ParametersWithIV(new KeyParameter(new byte[16]), new byte[16]));
        this.testSkipping(new Salsa20Engine(), new ParametersWithIV(new KeyParameter(new byte[16]), new byte[8]));
        this.testSkipping(new SICBlockCipher(new AESEngine()), new ParametersWithIV(new KeyParameter(new byte[16]), new byte[16]));
    }

    private void testModes(BlockCipher cipher1, BlockCipher cipher2, int keySize) throws Exception {
        KeyParameter key = new KeyParameter(new byte[keySize]);
        int blockSize = this.getBlockSize(cipher1);
        ParametersWithIV withIv = new ParametersWithIV(key, new byte[blockSize]);
        if (blockSize > 1) {
            this.testMode(new PaddedBufferedBlockCipher(cipher1, new PKCS7Padding()), key);
            this.testMode(new PaddedBufferedBlockCipher(new CBCBlockCipher(cipher1), new PKCS7Padding()), withIv);
            this.testMode(new BufferedBlockCipher(new OFBBlockCipher(cipher1, blockSize)), withIv);
            this.testMode(new BufferedBlockCipher(new CFBBlockCipher(cipher1, blockSize)), withIv);
            this.testMode(new BufferedBlockCipher(new SICBlockCipher(cipher1)), withIv);
        }
        if (blockSize <= 16 && this.streamSize >= blockSize) {
            this.testMode(new CTSBlockCipher(cipher1), key);
        }
        if (blockSize <= 16 && this.streamSize >= blockSize) {
            this.testMode(new NISTCTSBlockCipher(1, cipher1), key);
            this.testMode(new NISTCTSBlockCipher(2, cipher1), key);
            this.testMode(new NISTCTSBlockCipher(3, cipher1), key);
        }
        if (blockSize == 8 || blockSize == 16) {
            this.testMode(new EAXBlockCipher(cipher1), withIv);
        }
        if (blockSize == 16) {
            this.testMode(new CCMBlockCipher(cipher1), new ParametersWithIV(key, new byte[7]));
            this.testMode(new OCBBlockCipher(cipher1, cipher2), new ParametersWithIV(key, new byte[15]));
        }
    }

    private void testSkipping(StreamCipher cipher, CipherParameters params) throws Exception {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        this.init(cipher, true, params);
        OutputStream cOut = this.createCipherOutputStream(bOut, cipher);
        byte[] data = new byte[5000];
        new SecureRandom().nextBytes(data);
        cOut.write(data);
        cOut.close();
        this.init(cipher, false, params);
        InputStream cIn = this.createCipherInputStream(bOut.toByteArray(), cipher);
        long skip = cIn.skip(50L);
        if (skip != 50L) {
            this.fail("wrong number of bytes skipped: " + skip);
        }
        byte[] block = new byte[50];
        cIn.read(block);
        if (!this.areEqual(data, 50, block, 0)) {
            this.fail("initial skip mismatch");
        }
        if ((skip = cIn.skip(3000L)) != 3000L) {
            this.fail("wrong number of bytes skipped: " + skip);
        }
        cIn.read(block);
        if (!this.areEqual(data, 3100, block, 0)) {
            this.fail("second skip mismatch");
        }
        cipher.reset();
        cIn = this.createCipherInputStream(bOut.toByteArray(), cipher);
        if (!cIn.markSupported()) {
            this.fail("marking not supported");
        }
        cIn.mark(100);
        cIn.read(block);
        if (!this.areEqual(data, 0, block, 0)) {
            this.fail("initial mark read failed");
        }
        cIn.reset();
        cIn.read(block);
        if (!this.areEqual(data, 0, block, 0)) {
            this.fail(cipher.getAlgorithmName() + " initial reset read failed");
        }
        cIn.reset();
        cIn.read(block);
        cIn.mark(100);
        cIn.read(block);
        if (!this.areEqual(data, 50, block, 0)) {
            this.fail("second mark read failed");
        }
        cIn.reset();
        cIn.read(block);
        if (!this.areEqual(data, 50, block, 0)) {
            this.fail(cipher.getAlgorithmName() + " second reset read failed");
        }
        cIn.mark(3000);
        skip = cIn.skip(2050L);
        if (skip != 2050L) {
            this.fail("wrong number of bytes skipped: " + skip);
        }
        cIn.reset();
        cIn.read(block);
        if (!this.areEqual(data, 100, block, 0)) {
            this.fail(cipher.getAlgorithmName() + " third reset read failed");
        }
        cIn.read(new byte[2150]);
        cIn.reset();
        cIn.read(block);
        if (!this.areEqual(data, 100, block, 0)) {
            this.fail(cipher.getAlgorithmName() + " fourth reset read failed");
        }
        cIn.close();
    }

    private boolean areEqual(byte[] a, int aOff, byte[] b, int bOff) {
        for (int i = bOff; i != b.length; ++i) {
            if (a[aOff + i - bOff] == b[i]) continue;
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        CipherStreamTest.runTest(new CipherStreamTest());
    }
}

