/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.crypto.test;

import java.security.SecureRandom;
import org.bouncycastle162.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle162.crypto.agreement.X25519Agreement;
import org.bouncycastle162.crypto.generators.X25519KeyPairGenerator;
import org.bouncycastle162.crypto.params.X25519KeyGenerationParameters;
import org.bouncycastle162.util.test.SimpleTest;

public class X25519Test
extends SimpleTest {
    private static final SecureRandom RANDOM = new SecureRandom();

    public String getName() {
        return "X25519";
    }

    public static void main(String[] args) {
        X25519Test.runTest(new X25519Test());
    }

    public void performTest() {
        for (int i = 0; i < 10; ++i) {
            this.testAgreement();
        }
    }

    private void testAgreement() {
        X25519KeyPairGenerator kpGen = new X25519KeyPairGenerator();
        kpGen.init(new X25519KeyGenerationParameters(RANDOM));
        AsymmetricCipherKeyPair kpA = kpGen.generateKeyPair();
        AsymmetricCipherKeyPair kpB = kpGen.generateKeyPair();
        X25519Agreement agreeA = new X25519Agreement();
        agreeA.init(kpA.getPrivate());
        byte[] secretA = new byte[agreeA.getAgreementSize()];
        agreeA.calculateAgreement(kpB.getPublic(), secretA, 0);
        X25519Agreement agreeB = new X25519Agreement();
        agreeB.init(kpB.getPrivate());
        byte[] secretB = new byte[agreeB.getAgreementSize()];
        agreeB.calculateAgreement(kpA.getPublic(), secretB, 0);
        if (!this.areEqual(secretA, secretB)) {
            this.fail("X25519 agreement failed");
        }
    }
}

