/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.operator.bc;

import java.io.IOException;
import org.bouncycastle162.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle162.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle162.crypto.ExtendedDigest;
import org.bouncycastle162.crypto.Signer;
import org.bouncycastle162.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle162.crypto.signers.RSADigestSigner;
import org.bouncycastle162.crypto.util.PublicKeyFactory;
import org.bouncycastle162.operator.DigestAlgorithmIdentifierFinder;
import org.bouncycastle162.operator.OperatorCreationException;
import org.bouncycastle162.operator.bc.BcContentVerifierProviderBuilder;

public class BcRSAContentVerifierProviderBuilder
extends BcContentVerifierProviderBuilder {
    private DigestAlgorithmIdentifierFinder digestAlgorithmFinder;

    public BcRSAContentVerifierProviderBuilder(DigestAlgorithmIdentifierFinder digestAlgorithmFinder) {
        this.digestAlgorithmFinder = digestAlgorithmFinder;
    }

    protected Signer createSigner(AlgorithmIdentifier sigAlgId) throws OperatorCreationException {
        AlgorithmIdentifier digAlg = this.digestAlgorithmFinder.find(sigAlgId);
        ExtendedDigest dig = this.digestProvider.get(digAlg);
        return new RSADigestSigner(dig);
    }

    protected AsymmetricKeyParameter extractKeyParameters(SubjectPublicKeyInfo publicKeyInfo) throws IOException {
        return PublicKeyFactory.createKey(publicKeyInfo);
    }
}

