/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.operator.jcajce;

import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.bouncycastle162.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle162.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle162.cert.X509CertificateHolder;
import org.bouncycastle162.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle162.jcajce.io.OutputStreamFactory;
import org.bouncycastle162.jcajce.util.DefaultJcaJceHelper;
import org.bouncycastle162.jcajce.util.NamedJcaJceHelper;
import org.bouncycastle162.jcajce.util.ProviderJcaJceHelper;
import org.bouncycastle162.operator.ContentVerifier;
import org.bouncycastle162.operator.ContentVerifierProvider;
import org.bouncycastle162.operator.OperatorCreationException;
import org.bouncycastle162.operator.RawContentVerifier;
import org.bouncycastle162.operator.RuntimeOperatorException;
import org.bouncycastle162.operator.jcajce.OperatorHelper;

public class JcaContentVerifierProviderBuilder {
    private OperatorHelper helper = new OperatorHelper(new DefaultJcaJceHelper());

    public JcaContentVerifierProviderBuilder setProvider(Provider provider) {
        this.helper = new OperatorHelper(new ProviderJcaJceHelper(provider));
        return this;
    }

    public JcaContentVerifierProviderBuilder setProvider(String providerName) {
        this.helper = new OperatorHelper(new NamedJcaJceHelper(providerName));
        return this;
    }

    public ContentVerifierProvider build(X509CertificateHolder certHolder) throws OperatorCreationException, CertificateException {
        return this.build(this.helper.convertCertificate(certHolder));
    }

    public ContentVerifierProvider build(final X509Certificate certificate) throws OperatorCreationException {
        JcaX509CertificateHolder certHolder;
        try {
            certHolder = new JcaX509CertificateHolder(certificate);
        }
        catch (CertificateEncodingException e) {
            throw new OperatorCreationException("cannot process certificate: " + e.getMessage(), e);
        }
        return new ContentVerifierProvider(){

            public boolean hasAssociatedCertificate() {
                return true;
            }

            public X509CertificateHolder getAssociatedCertificate() {
                return certHolder;
            }

            public ContentVerifier get(AlgorithmIdentifier algorithm) throws OperatorCreationException {
                Signature sig;
                try {
                    sig = JcaContentVerifierProviderBuilder.this.helper.createSignature(algorithm);
                    sig.initVerify(certificate.getPublicKey());
                }
                catch (GeneralSecurityException e) {
                    throw new OperatorCreationException("exception on setup: " + e, e);
                }
                Signature rawSig = JcaContentVerifierProviderBuilder.this.createRawSig(algorithm, certificate.getPublicKey());
                if (rawSig != null) {
                    return new RawSigVerifier(algorithm, sig, rawSig);
                }
                return new SigVerifier(algorithm, sig);
            }
        };
    }

    public ContentVerifierProvider build(final PublicKey publicKey) throws OperatorCreationException {
        return new ContentVerifierProvider(){

            public boolean hasAssociatedCertificate() {
                return false;
            }

            public X509CertificateHolder getAssociatedCertificate() {
                return null;
            }

            public ContentVerifier get(AlgorithmIdentifier algorithm) throws OperatorCreationException {
                Signature sig = JcaContentVerifierProviderBuilder.this.createSignature(algorithm, publicKey);
                Signature rawSig = JcaContentVerifierProviderBuilder.this.createRawSig(algorithm, publicKey);
                if (rawSig != null) {
                    return new RawSigVerifier(algorithm, sig, rawSig);
                }
                return new SigVerifier(algorithm, sig);
            }
        };
    }

    public ContentVerifierProvider build(SubjectPublicKeyInfo publicKey) throws OperatorCreationException {
        return this.build(this.helper.convertPublicKey(publicKey));
    }

    private Signature createSignature(AlgorithmIdentifier algorithm, PublicKey publicKey) throws OperatorCreationException {
        try {
            Signature sig = this.helper.createSignature(algorithm);
            sig.initVerify(publicKey);
            return sig;
        }
        catch (GeneralSecurityException e) {
            throw new OperatorCreationException("exception on setup: " + e, e);
        }
    }

    private Signature createRawSig(AlgorithmIdentifier algorithm, PublicKey publicKey) {
        Signature rawSig;
        try {
            rawSig = this.helper.createRawSignature(algorithm);
            if (rawSig != null) {
                rawSig.initVerify(publicKey);
            }
        }
        catch (Exception e) {
            rawSig = null;
        }
        return rawSig;
    }

    private class RawSigVerifier
    extends SigVerifier
    implements RawContentVerifier {
        private Signature rawSignature;

        RawSigVerifier(AlgorithmIdentifier algorithm, Signature standardSig, Signature rawSignature) {
            super(algorithm, standardSig);
            this.rawSignature = rawSignature;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean verify(byte[] expected) {
            try {
                boolean bl = super.verify(expected);
                return bl;
            }
            finally {
                try {
                    this.rawSignature.verify(expected);
                }
                catch (Exception exception) {}
            }
        }

        public boolean verify(byte[] digest, byte[] expected) {
            try {
                this.rawSignature.update(digest);
                boolean bl = this.rawSignature.verify(expected);
                return bl;
            }
            catch (SignatureException e) {
                throw new RuntimeOperatorException("exception obtaining raw signature: " + e.getMessage(), e);
            }
            finally {
                try {
                    this.rawSignature.verify(expected);
                }
                catch (Exception exception) {}
            }
        }
    }

    private class SigVerifier
    implements ContentVerifier {
        private final AlgorithmIdentifier algorithm;
        private final Signature signature;
        protected final OutputStream stream;

        SigVerifier(AlgorithmIdentifier algorithm, Signature signature) {
            this.algorithm = algorithm;
            this.signature = signature;
            this.stream = OutputStreamFactory.createStream(signature);
        }

        public AlgorithmIdentifier getAlgorithmIdentifier() {
            return this.algorithm;
        }

        public OutputStream getOutputStream() {
            if (this.stream == null) {
                throw new IllegalStateException("verifier not initialised");
            }
            return this.stream;
        }

        public boolean verify(byte[] expected) {
            try {
                return this.signature.verify(expected);
            }
            catch (SignatureException e) {
                throw new RuntimeOperatorException("exception obtaining signature: " + e.getMessage(), e);
            }
        }
    }
}

