/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.pqc.crypto.qtesla;

import java.security.SecureRandom;
import org.bouncycastle162.pqc.crypto.qtesla.CommonFunction;
import org.bouncycastle162.pqc.crypto.qtesla.HashUtils;
import org.bouncycastle162.pqc.crypto.qtesla.Pack;
import org.bouncycastle162.pqc.crypto.qtesla.Polynomial;
import org.bouncycastle162.pqc.crypto.qtesla.PolynomialHeuristic;
import org.bouncycastle162.pqc.crypto.qtesla.PolynomialProvablySecure;
import org.bouncycastle162.pqc.crypto.qtesla.Sample;

public class QTESLA {
    private static void hashFunction(byte[] output, int outputOffset, int[] V, byte[] message, int messageOffset, int n, int d, int q) {
        byte[] T = new byte[n + 64];
        for (int i = 0; i < n; ++i) {
            int mask = q / 2 - V[i] >> 31;
            V[i] = V[i] - q & mask | V[i] & ~mask;
            int cL = V[i] & (1 << d) - 1;
            mask = (1 << d - 1) - cL >> 31;
            cL = cL - (1 << d) & mask | cL & ~mask;
            T[i] = (byte)(V[i] - cL >> d);
        }
        System.arraycopy(message, messageOffset, T, n, 64);
        if (q == 4205569) {
            HashUtils.secureHashAlgorithmKECCAK128(output, outputOffset, 32, T, 0, n + 64);
        }
        if (q == 4206593 || q == 8404993) {
            HashUtils.secureHashAlgorithmKECCAK256(output, outputOffset, 32, T, 0, n + 64);
        }
    }

    private static void hashFunction(byte[] output, int outputOffset, long[] V, byte[] message, int messageOffset, int n, int k, int d, int q) {
        byte[] T = new byte[n * k + 64];
        for (int j = 0; j < k; ++j) {
            int index = n * j;
            for (int i = 0; i < n; ++i) {
                long temporary = V[index];
                long mask = (long)(q / 2) - temporary >> 63;
                temporary = temporary - (long)q & mask | temporary & (mask ^ 0xFFFFFFFFFFFFFFFFL);
                long cL = temporary & (long)((1 << d) - 1);
                mask = (long)(1 << d - 1) - cL >> 63;
                cL = cL - (long)(1 << d) & mask | cL & (mask ^ 0xFFFFFFFFFFFFFFFFL);
                T[index++] = (byte)(temporary - cL >> d);
            }
        }
        System.arraycopy(message, messageOffset, T, n * k, 64);
        if (q == 485978113) {
            HashUtils.secureHashAlgorithmKECCAK128(output, outputOffset, 32, T, 0, n * k + 64);
        }
        if (q == 1129725953) {
            HashUtils.secureHashAlgorithmKECCAK256(output, outputOffset, 32, T, 0, n * k + 64);
        }
    }

    private static int absolute(int value) {
        return (value >> 31 ^ value) - (value >> 31);
    }

    private static long absolute(long value) {
        return (value >> 63 ^ value) - (value >> 63);
    }

    private static boolean testRejection(int[] Z, int n, int b, int u) {
        for (int i = 0; i < n; ++i) {
            if (QTESLA.absolute(Z[i]) <= b - u) continue;
            return true;
        }
        return false;
    }

    private static boolean testRejection(long[] Z, int n, int b, int u) {
        for (int i = 0; i < n; ++i) {
            if (QTESLA.absolute(Z[i]) <= (long)(b - u)) continue;
            return true;
        }
        return false;
    }

    private static boolean testZ(int[] Z, int n, int b, int u) {
        for (int i = 0; i < n; ++i) {
            if (Z[i] >= -(b - u) && Z[i] <= b - u) continue;
            return true;
        }
        return false;
    }

    private static boolean testZ(long[] Z, int n, int b, int u) {
        for (int i = 0; i < n; ++i) {
            if (Z[i] >= (long)(-(b - u)) && Z[i] <= (long)(b - u)) continue;
            return true;
        }
        return false;
    }

    private static boolean testV(int[] V, int n, int d, int q, int rejection) {
        for (int i = 0; i < n; ++i) {
            int mask = q / 2 - V[i] >> 31;
            int right = V[i] - q & mask | V[i] & ~mask;
            int test1 = ~(QTESLA.absolute(right) - (q / 2 - rejection)) >>> 31;
            int left = right;
            right = right + (1 << d - 1) - 1 >> d;
            int test2 = ~(QTESLA.absolute(right = left - (right << d)) - ((1 << d - 1) - rejection)) >>> 31;
            if ((test1 | test2) != 1) continue;
            return true;
        }
        return false;
    }

    private static boolean testV(long[] V, int vOffset, int n, int d, int q, int rejection) {
        for (int i = 0; i < n; ++i) {
            long mask = (long)(q / 2) - V[vOffset + i] >> 63;
            long right = V[vOffset + i] - (long)q & mask | V[vOffset + i] & (mask ^ 0xFFFFFFFFFFFFFFFFL);
            long test1 = (QTESLA.absolute(right) - (long)(q / 2 - rejection) ^ 0xFFFFFFFFFFFFFFFFL) >>> 63;
            long left = right;
            right = (int)(right + (long)(1 << d - 1) - 1L >> d);
            long test2 = (QTESLA.absolute(right = left - (right << d)) - (long)((1 << d - 1) - rejection) ^ 0xFFFFFFFFFFFFFFFFL) >>> 63;
            if ((test1 | test2) != 1L) continue;
            return true;
        }
        return false;
    }

    private static boolean checkPolynomial(int[] polynomial, int bound, int n, int h) {
        int i;
        int summation = 0;
        int limit = n;
        int[] list = new int[n];
        for (i = 0; i < n; ++i) {
            list[i] = QTESLA.absolute(polynomial[i]);
        }
        for (i = 0; i < h; ++i) {
            for (int j = 0; j < limit - 1; ++j) {
                int mask = list[j + 1] - list[j] >> 31;
                int temporary = list[j + 1] & mask | list[j] & ~mask;
                list[j + 1] = list[j] & mask | list[j + 1] & ~mask;
                list[j] = temporary;
            }
            summation += list[limit - 1];
            --limit;
        }
        return summation > bound;
    }

    private static boolean checkPolynomial(long[] polynomial, int offset, int bound, int n, int h) {
        int i;
        int summation = 0;
        int limit = n;
        short[] list = new short[n];
        for (i = 0; i < n; ++i) {
            list[i] = (short)QTESLA.absolute(polynomial[offset + i]);
        }
        for (i = 0; i < h; ++i) {
            for (int j = 0; j < limit - 1; ++j) {
                short mask = (short)(list[j + 1] - list[j] >> 15);
                short temporary = (short)(list[j + 1] & mask | list[j] & ~mask);
                list[j + 1] = (short)(list[j] & mask | list[j + 1] & ~mask);
                list[j] = temporary;
            }
            summation += list[limit - 1];
            --limit;
        }
        return summation > bound;
    }

    private static int generateKeyPair(byte[] publicKey, byte[] privateKey, SecureRandom secureRandom, int n, int h, int q, long qInverse, int qLogarithm, int generatorA, int inverseNumberTheoreticTransform, double xi, int[] zeta, int errorBound, int secretBound) {
        int nonce = 0;
        byte[] randomness = new byte[32];
        byte[] randomnessExtended = new byte[128];
        int[] secretPolynomial = new int[n];
        int[] errorPolynomial = new int[n];
        int[] A = new int[n];
        int[] T = new int[n];
        secureRandom.nextBytes(randomness);
        if (q == 4205569) {
            HashUtils.secureHashAlgorithmKECCAK128(randomnessExtended, 0, 128, randomness, 0, 32);
        }
        if (q == 4206593 || q == 8404993) {
            HashUtils.secureHashAlgorithmKECCAK256(randomnessExtended, 0, 128, randomness, 0, 32);
        }
        do {
            if (q == 4205569) {
                Sample.polynomialGaussSamplerI(errorPolynomial, 0, randomnessExtended, 0, ++nonce);
            }
            if (q == 4206593) {
                Sample.polynomialGaussSamplerIII(errorPolynomial, 0, randomnessExtended, 0, ++nonce, n, xi, Sample.EXPONENTIAL_DISTRIBUTION_III_SIZE);
            }
            if (q != 8404993) continue;
            Sample.polynomialGaussSamplerIII(errorPolynomial, 0, randomnessExtended, 0, ++nonce, n, xi, Sample.EXPONENTIAL_DISTRIBUTION_III_SPEED);
        } while (QTESLA.checkPolynomial(errorPolynomial, errorBound, n, h));
        do {
            if (q == 4205569) {
                Sample.polynomialGaussSamplerI(secretPolynomial, 0, randomnessExtended, 32, ++nonce);
            }
            if (q == 4206593) {
                Sample.polynomialGaussSamplerIII(secretPolynomial, 0, randomnessExtended, 32, ++nonce, n, xi, Sample.EXPONENTIAL_DISTRIBUTION_III_SIZE);
            }
            if (q != 8404993) continue;
            Sample.polynomialGaussSamplerIII(secretPolynomial, 0, randomnessExtended, 32, ++nonce, n, xi, Sample.EXPONENTIAL_DISTRIBUTION_III_SPEED);
        } while (QTESLA.checkPolynomial(secretPolynomial, secretBound, n, h));
        Polynomial.polynomialUniform(A, randomnessExtended, 64, n, q, qInverse, qLogarithm, generatorA, inverseNumberTheoreticTransform);
        Polynomial.polynomialMultiplication(T, A, secretPolynomial, n, q, qInverse, zeta);
        Polynomial.polynomialAdditionCorrection(T, T, errorPolynomial, n, q);
        if (q == 4205569) {
            Pack.encodePrivateKeyI(privateKey, secretPolynomial, errorPolynomial, randomnessExtended, 64);
            Pack.encodePublicKey(publicKey, T, randomnessExtended, 64, 512, 23);
        }
        if (q == 4206593) {
            Pack.encodePrivateKeyIIISize(privateKey, secretPolynomial, errorPolynomial, randomnessExtended, 64);
            Pack.encodePublicKey(publicKey, T, randomnessExtended, 64, 1024, 23);
        }
        if (q == 8404993) {
            Pack.encodePrivateKeyIIISpeed(privateKey, secretPolynomial, errorPolynomial, randomnessExtended, 64);
            Pack.encodePublicKeyIIISpeed(publicKey, T, randomnessExtended, 64);
        }
        return 0;
    }

    public static int generateKeyPairI(byte[] publicKey, byte[] privateKey, SecureRandom secureRandom) {
        return QTESLA.generateKeyPair(publicKey, privateKey, secureRandom, 512, 30, 4205569, 3098553343L, 23, 19, 113307, 27.0, PolynomialHeuristic.ZETA_I, 1586, 1586);
    }

    public static int generateKeyPairIIISize(byte[] publicKey, byte[] privateKey, SecureRandom secureRandom) {
        return QTESLA.generateKeyPair(publicKey, privateKey, secureRandom, 1024, 48, 4206593, 4148178943L, 23, 38, 1217638, 9.0, PolynomialHeuristic.ZETA_III_SIZE, 910, 910);
    }

    public static int generateKeyPairIIISpeed(byte[] publicKey, byte[] privateKey, SecureRandom secureRandom) {
        return QTESLA.generateKeyPair(publicKey, privateKey, secureRandom, 1024, 48, 8404993, 4034936831L, 24, 38, 237839, 12.0, PolynomialHeuristic.ZETA_III_SPEED, 1147, 1233);
    }

    private static int generateKeyPair(byte[] publicKey, byte[] privateKey, SecureRandom secureRandom, int n, int k, int h, int q, long qInverse, int qLogarithm, int generatorA, int inverseNumberTheoreticTransform, double xi, long[] zeta, int errorBound, int secretBound) {
        int i;
        int nonce = 0;
        byte[] randomness = new byte[32];
        byte[] randomnessExtended = new byte[32 * (k + 3)];
        long[] secretPolynomial = new long[n];
        long[] secretPolynomialNumberTheoreticTransform = new long[n];
        long[] errorPolynomial = new long[n * k];
        long[] A = new long[n * k];
        long[] T = new long[n * k];
        secureRandom.nextBytes(randomness);
        if (q == 485978113) {
            HashUtils.secureHashAlgorithmKECCAK128(randomnessExtended, 0, 32 * (k + 3), randomness, 0, 32);
        }
        if (q == 1129725953) {
            HashUtils.secureHashAlgorithmKECCAK256(randomnessExtended, 0, 32 * (k + 3), randomness, 0, 32);
        }
        for (i = 0; i < k; ++i) {
            do {
                if (q == 485978113) {
                    Sample.polynomialGaussSamplerIP(errorPolynomial, n * i, randomnessExtended, 32 * i, ++nonce);
                }
                if (q != 1129725953) continue;
                Sample.polynomialGaussSamplerIIIP(errorPolynomial, n * i, randomnessExtended, 32 * i, ++nonce);
            } while (QTESLA.checkPolynomial(errorPolynomial, n * i, errorBound, n, h));
        }
        do {
            if (q == 485978113) {
                Sample.polynomialGaussSamplerIP(secretPolynomial, 0, randomnessExtended, 32 * k, ++nonce);
            }
            if (q != 1129725953) continue;
            Sample.polynomialGaussSamplerIIIP(secretPolynomial, 0, randomnessExtended, 32 * k, ++nonce);
        } while (QTESLA.checkPolynomial(secretPolynomial, 0, secretBound, n, h));
        Polynomial.polynomialUniform(A, randomnessExtended, 32 * (k + 1), n, k, q, qInverse, qLogarithm, generatorA, inverseNumberTheoreticTransform);
        Polynomial.polynomialNumberTheoreticTransform(secretPolynomialNumberTheoreticTransform, secretPolynomial, n);
        for (i = 0; i < k; ++i) {
            Polynomial.polynomialMultiplication(T, n * i, A, n * i, secretPolynomialNumberTheoreticTransform, 0, n, q, qInverse);
            Polynomial.polynomialAddition(T, n * i, T, n * i, errorPolynomial, n * i, n);
            for (int j = 0; j < n; ++j) {
                long mask = (long)q - T[n * i + j] >> 63;
                int n2 = n * i + j;
                T[n2] = T[n2] - ((long)q & mask);
            }
        }
        Pack.packPrivateKey(privateKey, secretPolynomial, errorPolynomial, randomnessExtended, 32 * (k + 1), n, k);
        if (q == 485978113) {
            Pack.encodePublicKeyIP(publicKey, T, randomnessExtended, 32 * (k + 1));
        }
        if (q == 1129725953) {
            Pack.encodePublicKeyIIIP(publicKey, T, randomnessExtended, 32 * (k + 1));
        }
        return 0;
    }

    public static int generateKeyPairIP(byte[] publicKey, byte[] privateKey, SecureRandom secureRandom) {
        return QTESLA.generateKeyPair(publicKey, privateKey, secureRandom, 1024, 4, 25, 485978113, 3421990911L, 29, 108, 472064468, 10.0, PolynomialProvablySecure.ZETA_I_P, 554, 554);
    }

    public static int generateKeyPairIIIP(byte[] publicKey, byte[] privateKey, SecureRandom secureRandom) {
        return QTESLA.generateKeyPair(publicKey, privateKey, secureRandom, 2048, 5, 40, 1129725953, 861290495L, 31, 180, 851423148, 10.0, PolynomialProvablySecure.ZETA_III_P, 901, 901);
    }

    private static int signing(byte[] signature, byte[] message, int messageOffset, int messageLength, byte[] privateKey, SecureRandom secureRandom, int n, int h, int q, long qInverse, int qLogarithm, int b, int bBit, int d, int u, int rejection, int generatorA, int inverseNumberTheoreticTransform, int barrettMultiplication, int barrettDivision, int[] zeta) {
        byte[] C = new byte[32];
        byte[] randomness = new byte[32];
        byte[] randomnessInput = new byte[128];
        byte[] seed = new byte[64];
        byte[] temporaryRandomnessInput = new byte[32];
        int[] positionList = new int[h];
        short[] signList = new short[h];
        short[] secretPolynomial = new short[n];
        short[] errorPolynomial = new short[n];
        int[] A = new int[n];
        int[] V = new int[n];
        int[] Y = new int[n];
        int[] Z = new int[n];
        int[] SC = new int[n];
        int[] EC2 = new int[n];
        int nonce = 0;
        if (q == 4205569) {
            Pack.decodePrivateKeyI(seed, secretPolynomial, errorPolynomial, privateKey);
        }
        if (q == 4206593) {
            Pack.decodePrivateKeyIIISize(seed, secretPolynomial, errorPolynomial, privateKey);
        }
        if (q == 8404993) {
            Pack.decodePrivateKeyIIISpeed(seed, secretPolynomial, errorPolynomial, privateKey);
        }
        secureRandom.nextBytes(temporaryRandomnessInput);
        System.arraycopy(temporaryRandomnessInput, 0, randomnessInput, 32, 32);
        System.arraycopy(seed, 32, randomnessInput, 0, 32);
        if (q == 4205569) {
            HashUtils.secureHashAlgorithmKECCAK128(randomnessInput, 64, 64, message, 0, messageLength);
            HashUtils.secureHashAlgorithmKECCAK128(randomness, 0, 32, randomnessInput, 0, 128);
        }
        if (q == 4206593 || q == 8404993) {
            HashUtils.secureHashAlgorithmKECCAK256(randomnessInput, 64, 64, message, 0, messageLength);
            HashUtils.secureHashAlgorithmKECCAK256(randomness, 0, 32, randomnessInput, 0, 128);
        }
        Polynomial.polynomialUniform(A, seed, 0, n, q, qInverse, qLogarithm, generatorA, inverseNumberTheoreticTransform);
        while (true) {
            Sample.sampleY(Y, randomness, 0, ++nonce, n, q, b, bBit);
            Polynomial.polynomialMultiplication(V, A, Y, n, q, qInverse, zeta);
            QTESLA.hashFunction(C, 0, V, randomnessInput, 64, n, d, q);
            Sample.encodeC(positionList, signList, C, 0, n, h);
            Polynomial.sparsePolynomialMultiplication16(SC, secretPolynomial, positionList, signList, n, h);
            Polynomial.polynomialAddition(Z, Y, SC, n);
            if (QTESLA.testRejection(Z, n, b, u)) continue;
            Polynomial.sparsePolynomialMultiplication16(EC2, errorPolynomial, positionList, signList, n, h);
            Polynomial.polynomialSubtractionCorrection(V, V, EC2, n, q);
            if (!QTESLA.testV(V, n, d, q, rejection)) break;
        }
        if (q == 4205569) {
            Pack.encodeSignature(signature, 0, C, 0, Z, n, d);
        }
        if (q == 4206593) {
            Pack.encodeSignature(signature, 0, C, 0, Z, n, d);
        }
        if (q == 8404993) {
            Pack.encodeSignatureIIISpeed(signature, 0, C, 0, Z);
        }
        return 0;
    }

    static int signingI(byte[] signature, byte[] message, int messageOffset, int messageLength, byte[] privateKey, SecureRandom secureRandom) {
        return QTESLA.signing(signature, message, messageOffset, messageLength, privateKey, secureRandom, 512, 30, 4205569, 3098553343L, 23, 1048575, 20, 21, 1586, 1586, 19, 113307, 1021, 32, PolynomialHeuristic.ZETA_I);
    }

    static int signingIIISize(byte[] signature, byte[] message, int messageOffset, int messageLength, byte[] privateKey, SecureRandom secureRandom) {
        return QTESLA.signing(signature, message, messageOffset, messageLength, privateKey, secureRandom, 1024, 48, 4206593, 4148178943L, 23, 1048575, 20, 21, 910, 910, 38, 1217638, 1021, 32, PolynomialHeuristic.ZETA_III_SIZE);
    }

    static int signingIIISpeed(byte[] signature, byte[] message, int messageOffset, int messageLength, byte[] privateKey, SecureRandom secureRandom) {
        return QTESLA.signing(signature, message, messageOffset, messageLength, privateKey, secureRandom, 1024, 48, 8404993, 4034936831L, 24, 0x1FFFFF, 21, 22, 1233, 1147, 38, 237839, 511, 32, PolynomialHeuristic.ZETA_III_SPEED);
    }

    private static int signing(byte[] signature, byte[] message, int messageOffset, int messageLength, byte[] privateKey, SecureRandom secureRandom, int n, int k, int h, int q, long qInverse, int qLogarithm, int b, int bBit, int d, int u, int rejection, int generatorA, int inverseNumberTheoreticTransform, int privateKeySize, int barrettMultiplication, int barrettDivision) {
        byte[] C = new byte[32];
        byte[] randomness = new byte[32];
        byte[] randomnessInput = new byte[128];
        byte[] temporaryRandomnessInput = new byte[32];
        int[] positionList = new int[h];
        short[] signList = new short[h];
        long[] A = new long[n * k];
        long[] V = new long[n * k];
        long[] Y = new long[n];
        long[] numberTheoreticTransformY = new long[n];
        long[] Z = new long[n];
        long[] SC = new long[n];
        long[] EC2 = new long[n * k];
        boolean response = false;
        int nonce = 0;
        secureRandom.nextBytes(temporaryRandomnessInput);
        System.arraycopy(temporaryRandomnessInput, 0, randomnessInput, 32, 32);
        System.arraycopy(privateKey, privateKeySize - 32, randomnessInput, 0, 32);
        if (q == 485978113) {
            HashUtils.secureHashAlgorithmKECCAK128(randomnessInput, 64, 64, message, 0, messageLength);
            HashUtils.secureHashAlgorithmKECCAK128(randomness, 0, 32, randomnessInput, 0, 128);
        }
        if (q == 1129725953) {
            HashUtils.secureHashAlgorithmKECCAK256(randomnessInput, 64, 64, message, 0, messageLength);
            HashUtils.secureHashAlgorithmKECCAK256(randomness, 0, 32, randomnessInput, 0, 128);
        }
        Polynomial.polynomialUniform(A, privateKey, privateKeySize - 64, n, k, q, qInverse, qLogarithm, generatorA, inverseNumberTheoreticTransform);
        while (true) {
            int i;
            Sample.sampleY(Y, randomness, 0, ++nonce, n, q, b, bBit);
            Polynomial.polynomialNumberTheoreticTransform(numberTheoreticTransformY, Y, n);
            for (i = 0; i < k; ++i) {
                Polynomial.polynomialMultiplication(V, n * i, A, n * i, numberTheoreticTransformY, 0, n, q, qInverse);
            }
            QTESLA.hashFunction(C, 0, V, randomnessInput, 64, n, k, d, q);
            Sample.encodeC(positionList, signList, C, 0, n, h);
            Polynomial.sparsePolynomialMultiplication8(SC, 0, privateKey, 0, positionList, signList, n, h);
            Polynomial.polynomialAddition(Z, 0, Y, 0, SC, 0, n);
            if (QTESLA.testRejection(Z, n, b, u)) continue;
            for (i = 0; i < k; ++i) {
                Polynomial.sparsePolynomialMultiplication8(EC2, n * i, privateKey, n * (i + 1), positionList, signList, n, h);
                Polynomial.polynomialSubtraction(V, n * i, V, n * i, EC2, n * i, n, q, barrettMultiplication, barrettDivision);
                response = QTESLA.testV(V, n * i, n, d, q, rejection);
                if (response) break;
            }
            if (!response) break;
        }
        if (q == 485978113) {
            Pack.encodeSignatureIP(signature, 0, C, 0, Z);
        }
        if (q == 1129725953) {
            Pack.encodeSignatureIIIP(signature, 0, C, 0, Z);
        }
        return 0;
    }

    public static int signingIP(byte[] signature, byte[] message, int messageOffset, int messageLength, byte[] privateKey, SecureRandom secureRandom) {
        return QTESLA.signing(signature, message, messageOffset, messageLength, privateKey, secureRandom, 1024, 4, 25, 485978113, 3421990911L, 29, 0x1FFFFF, 21, 22, 554, 554, 108, 472064468, 5184, 1, 29);
    }

    public static int signingIIIP(byte[] signature, byte[] message, int messageOffset, int messageLength, byte[] privateKey, SecureRandom secureRandom) {
        return QTESLA.signing(signature, message, messageOffset, messageLength, privateKey, secureRandom, 2048, 5, 40, 1129725953, 861290495L, 31, 0x7FFFFF, 23, 24, 901, 901, 180, 851423148, 12352, 15, 34);
    }

    private static int verifying(byte[] message, byte[] signature, int signatureOffset, int signatureLength, byte[] publicKey, int n, int h, int q, long qInverse, int qLogarithm, int b, int d, int u, int r, int signatureSize, int generatorA, int inverseNumberTheoreticTransform, int barrettMultiplication, int barrettDivision, int[] zeta) {
        byte[] C = new byte[32];
        byte[] cSignature = new byte[32];
        byte[] seed = new byte[32];
        byte[] hashMessage = new byte[64];
        int[] newPublicKey = new int[n];
        int[] positionList = new int[h];
        short[] signList = new short[h];
        int[] W = new int[n];
        int[] Z = new int[n];
        int[] TC = new int[n];
        int[] A = new int[n];
        if (signatureLength < signatureSize) {
            return -1;
        }
        if (q == 4205569 || q == 4206593) {
            Pack.decodeSignature(C, Z, signature, signatureOffset, n, d);
        }
        if (q == 8404993) {
            Pack.decodeSignatureIIISpeed(C, Z, signature, signatureOffset);
        }
        if (QTESLA.testZ(Z, n, b, u)) {
            return -2;
        }
        if (q == 4205569 || q == 4206593) {
            Pack.decodePublicKey(newPublicKey, seed, 0, publicKey, n, qLogarithm);
        }
        if (q == 8404993) {
            Pack.decodePublicKeyIIISpeed(newPublicKey, seed, 0, publicKey);
        }
        Polynomial.polynomialUniform(A, seed, 0, n, q, qInverse, qLogarithm, generatorA, inverseNumberTheoreticTransform);
        Sample.encodeC(positionList, signList, C, 0, n, h);
        Polynomial.sparsePolynomialMultiplication32(TC, newPublicKey, positionList, signList, n, h);
        Polynomial.polynomialMultiplication(W, A, Z, n, q, qInverse, zeta);
        Polynomial.polynomialSubtractionMontgomery(W, W, TC, n, q, qInverse, r);
        if (q == 4205569) {
            HashUtils.secureHashAlgorithmKECCAK128(hashMessage, 0, 64, message, 0, message.length);
        }
        if (q == 4206593 || q == 8404993) {
            HashUtils.secureHashAlgorithmKECCAK256(hashMessage, 0, 64, message, 0, message.length);
        }
        QTESLA.hashFunction(cSignature, 0, W, hashMessage, 0, n, d, q);
        if (!CommonFunction.memoryEqual(C, 0, cSignature, 0, 32)) {
            return -3;
        }
        return 0;
    }

    static int verifyingI(byte[] message, byte[] signature, int signatureOffset, int signatureLength, byte[] publicKey) {
        return QTESLA.verifying(message, signature, signatureOffset, signatureLength, publicKey, 512, 30, 4205569, 3098553343L, 23, 1048575, 21, 1586, 1081347, 1376, 19, 113307, 1021, 32, PolynomialHeuristic.ZETA_I);
    }

    static int verifyingIIISize(byte[] message, byte[] signature, int signatureOffset, int signatureLength, byte[] publicKey) {
        return QTESLA.verifying(message, signature, signatureOffset, signatureLength, publicKey, 1024, 48, 4206593, 4148178943L, 23, 1048575, 21, 910, 35843, 2720, 38, 1217638, 1021, 32, PolynomialHeuristic.ZETA_III_SIZE);
    }

    static int verifyingIIISpeed(byte[] message, byte[] signature, int signatureOffset, int signatureLength, byte[] publicKey) {
        return QTESLA.verifying(message, signature, signatureOffset, signatureLength, publicKey, 1024, 48, 8404993, 4034936831L, 24, 0x1FFFFF, 22, 1233, 15873, 2848, 38, 237839, 511, 32, PolynomialHeuristic.ZETA_III_SPEED);
    }

    private static int verifying(byte[] message, byte[] signature, int signatureOffset, int signatureLength, byte[] publicKey, int n, int k, int h, int q, long qInverse, int qLogarithm, int b, int d, int u, int signatureSize, int generatorA, int inverseNumberTheoreticTransform, int barrettMultiplication, int barrettDivision, long[] zeta) {
        byte[] C = new byte[32];
        byte[] cSignature = new byte[32];
        byte[] seed = new byte[32];
        byte[] hashMessage = new byte[64];
        int[] newPublicKey = new int[n * k];
        int[] positionList = new int[h];
        short[] signList = new short[h];
        long[] W = new long[n * k];
        long[] Z = new long[n];
        long[] numberTheoreticTransformZ = new long[n];
        long[] TC = new long[n * k];
        long[] A = new long[n * k];
        if (signatureLength < signatureSize) {
            return -1;
        }
        if (q == 485978113) {
            Pack.decodeSignatureIP(C, Z, signature, signatureOffset);
        }
        if (q == 1129725953) {
            Pack.decodeSignatureIIIP(C, Z, signature, signatureOffset);
        }
        if (QTESLA.testZ(Z, n, b, u)) {
            return -2;
        }
        if (q == 485978113) {
            Pack.decodePublicKeyIP(newPublicKey, seed, 0, publicKey);
        }
        if (q == 1129725953) {
            Pack.decodePublicKeyIIIP(newPublicKey, seed, 0, publicKey);
        }
        Polynomial.polynomialUniform(A, seed, 0, n, k, q, qInverse, qLogarithm, generatorA, inverseNumberTheoreticTransform);
        Sample.encodeC(positionList, signList, C, 0, n, h);
        Polynomial.polynomialNumberTheoreticTransform(numberTheoreticTransformZ, Z, n);
        for (int i = 0; i < k; ++i) {
            Polynomial.polynomialMultiplication(W, n * i, A, n * i, numberTheoreticTransformZ, 0, n, q, qInverse);
            Polynomial.sparsePolynomialMultiplication32(TC, n * i, newPublicKey, n * i, positionList, signList, n, h, q, barrettMultiplication, barrettDivision);
            Polynomial.polynomialSubtraction(W, n * i, W, n * i, TC, n * i, n, q, barrettMultiplication, barrettDivision);
        }
        if (q == 485978113) {
            HashUtils.secureHashAlgorithmKECCAK128(hashMessage, 0, 64, message, 0, message.length);
        }
        if (q == 1129725953) {
            HashUtils.secureHashAlgorithmKECCAK256(hashMessage, 0, 64, message, 0, message.length);
        }
        QTESLA.hashFunction(cSignature, 0, W, hashMessage, 0, n, k, d, q);
        if (!CommonFunction.memoryEqual(C, 0, cSignature, 0, 32)) {
            return -3;
        }
        return 0;
    }

    static int verifyingPI(byte[] message, byte[] signature, int signatureOffset, int signatureLength, byte[] publicKey) {
        return QTESLA.verifying(message, signature, signatureOffset, signatureLength, publicKey, 1024, 4, 25, 485978113, 3421990911L, 29, 0x1FFFFF, 22, 554, 2848, 108, 472064468, 1, 29, PolynomialProvablySecure.ZETA_I_P);
    }

    static int verifyingPIII(byte[] message, byte[] signature, int signatureOffset, int signatureLength, byte[] publicKey) {
        return QTESLA.verifying(message, signature, signatureOffset, signatureLength, publicKey, 2048, 5, 40, 1129725953, 861290495L, 31, 0x7FFFFF, 24, 901, 6176, 180, 851423148, 15, 34, PolynomialProvablySecure.ZETA_III_P);
    }
}

