/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.framework.config;

import com.ygsoft.ecp.framework.config.ServerPropSource;
import javax.servlet.ServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public final class PropSourceRegister {
    private PropSourceRegister() {
    }

    public static PropertySource getServerPropSource() {
        return new ServerPropSource("ServerPropSource");
    }

    public static void registerPropSource(ServletContext servletContext) {
        WebApplicationContext webContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)servletContext);
        if (webContext instanceof ConfigurableApplicationContext) {
            ConfigurableApplicationContext context = (ConfigurableApplicationContext)webContext;
            PropSourceRegister.registerPropSource(context);
        }
    }

    public static void registerPropSource(ConfigurableApplicationContext applicationContext) {
        PropertySource propertySource = PropSourceRegister.getServerPropSource();
        MutablePropertySources mSources = applicationContext.getEnvironment().getPropertySources();
        if (!mSources.contains(propertySource.getName())) {
            mSources.addFirst(propertySource);
            Logger loggger = LoggerFactory.getLogger(PropSourceRegister.class);
            if (loggger.isInfoEnabled()) {
                loggger.info("\u5df2\u6dfb\u52a0\u81ea\u5b9a\u4e49\u5c5e\u6027\u6e90:" + propertySource.getName());
            }
        }
    }
}

