/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.framework.cons;

import com.ygsoft.ecp.framework.cons.ServerProps;

public final class MappConst {
    public static final String MAPP_SERVICEREGISTERURL = "mapp.serviceRegisterUrl";
    public static final String EDAS_ACCESSKEY = "aliyun.edas.accessKey";
    public static final String EDAS_SECRETKEY = "aliyun.edas.secretKey";
    public static final String EDAS_REGINOID = "aliyun.edas.regionId";
    public static final String EDAS_NAMESPACEID = "aliyun.edas.namespaceId";
    public static final String CSE_AKSK_ENABLE = "cse.aksk.enabled";
    public static final String CSE_ACCESS_KEY = "cse.access.key";
    public static final String CSE_SECRET_KEY = "cse.secret.key";
    public static final String CSE_AKSK_CIPHER = "cse.aksk.cipher";
    public static final String CSE_PROJECT_NAME = "cse.project.name";
    public static final String MAPP_REGIONNAME = "mapp.regionName";
    public static final String MAPP_REGION = "mapp.region";
    public static final String MAPP_NAME = "mapp.name";
    public static final String MAPP_AUTH_PROVIDER_ENABLED = "mapp.auth.provider.enabled";
    public static final String MAPP_AUTH_CONSUMER_ENABLED = "mapp.auth.consumer.enabled";
    public static final String MAPP_AUTH_CONSUMER_TOKEN = "mapp.auth.consumer.token";
    public static final String MAPP_AUTH_CONSUMER_TOKEN_IN_HEADER = "auth_token";
    public static final String MAPP_SERVICEREGISTERTYPE = "mapp.serviceRegisterType";
    public static final String MAPP_ISSERVICECROSSREGON = "mapp.isServiceCrossRegon";
    public static final String MAPP_CONFIG_PATH = "classpath*:/META-INF/ecp-mapp/mapp.properties";
    public static final String MAPP_ALL_CONFIG_PATH = "/WEB-INF/mapp-all.properties";
    public static final String MAPP_VIPADDRESS = "mapp.vipAddress";
    public static final String MAPP_STANDALONE = "mapp.standAlone";
    public static final String MAPP_MAINAPPLICATIONCLASS = "mapp.mainApplicationClass";
    public static final String MAPP_MARK_PATH = "/mapp/";
    public static final String WEB_SERVER_TYPE = "server.type";
    public static final String WEB_SERVER_TOMCAT = "tomcat";
    public static final String WEB_SERVER_UNDERTOW = "undertow";
    public static final String WEB_SERVER_PORT = "server.port";
    public static final int WEB_SERVER_PORT_DEFAULT = 8080;
    public static final String WEB_SERVER_HTTPS_PORT = "server.httpsPort";
    public static final int WEB_SERVER_HTTPS_PORT_DEFAULT = 0;
    public static final String WEB_SERVER_SPRING_NAME = "spring.application.name";
    public static final String WEB_SERVER_NAME = "server.name";
    public static final String WEB_SERVER_CONTEXTPATH = "server.contextpath";
    public static final String WEB_SERVER_CONTEXT_PATH = "server.context-path";
    public static final String WEB_SERVER_SESSION_TIMEOUT = "server.session-timeout";
    public static final String WEB_SERVER_CONTEXTPATH_DEFAULT = "/test";
    public static final String WEB_SERVER_REGION = "server.region";
    public static final String WEB_SERVER_VIPADDRESS = "server.vipaddress";
    public static final String GRAY_VERSION = "gray.version";
    public static final String TENANT_ORGCODE = "tenant.orgcode";
    public static final String WEB_SWAGGER_ENABLED = "swagger.enabled";
    public static final String WEB_SERVER_NAME_DEFAULT = "ECP-SERVER";
    public static final String MAPP_TRICE_TID = "trice_tid";
    public static final String MAPP_TRICE_PID = "trice_pid";
    public static final String MAPP_TRICE_USERNAME = "trice_userName";
    public static final String MAPP_TRICE_SOURCE_VIP = "trice_sourceVip";
    public static final String MAPP_TRICE_SOURCE_IP = "trice_sourceIp";
    public static final String MAPP_TRICE_SOURCE_PORT = "trice_soucePort";
    public static final String MAPP_TRICE_REGISTERURL = "trice_registerUrl";
    public static final String MAPP_VIP_KEY = "mappVip";
    public static final String MAPP_IP_KEY = "mappIp";
    public static final String MAPP_PORT_KEY = "mappPort";
    public static final String MAPP_DEVELOP_MODE_KEY = "develop.mode";
    public static final String APISTORE_SENDAPI_URL = "apistore.sendapi.url";
    public static final String APISTORE_SENDAPI_ENABLED = "apistore.sendapi.enabled";
    public static final String APISTORE_ZOOKEEPER_HOSTS = "apistore.zookeeper.hosts";
    public static final String APISTORE_ZOOKEEPER_CONNECT_TIMEOUT = "apistore.zookeeper.connectTimeout";
    public static final String APISTORE_ZOOKEEPER_SESSION_TIMEOUT = "apistore.zookeeper.sessionTimeout";
    public static final String APISTORE_ZOOKEEPER_MAX_RETRY = "apistore.zookeeper.maxRetry";
    public static final String APISTORE_ZOOKEEPER_DIGEST = "apistore.zookeeper.digest";
    public static final String APISTORE_SWAGGER_GROUP_NAME = "ecp-exposed-api";
    public static final String MAPP_SEND_MILLS = "mapp_send_mills";
    public static final String KEY_HTTP_CONNECT_TIMEOUT = "server.http.connectTimeout";
    public static final String KEY_HTTP_READ_TIMEOUT = "server.http.readTimeout";
    public static final int HTTP_CONNECT_TIMEOUT;
    public static final int HTTP_READ_TIMEOUT;
    public static final String KEY_REQUEST_USESUFFIXPATTERNMATCH = "jt.cloud.reuqest.useSuffixPatternMatch";
    public static final boolean REQUEST_USESUFFIXPATTERNMATCH;
    public static final String KEY_REQUEST_USETRAILINGSLASHMATCH = "jt.cloud.request.useTrailingSlashMatch";
    public static final boolean REQUEST_USETRAILINGSLASHMATCH;
    public static final String KEY_REQUEST_REMOVESEMICOLONCONTENT = "jt.cloud.request.removeSemicolonContent";
    public static final boolean REQUEST_REMOVESEMICOLONCONTENT;
    private static final String GW = "guowang";

    private MappConst() {
    }

    public static boolean isDevelopMode() {
        return "true".equalsIgnoreCase(ServerProps.getProperty(MAPP_DEVELOP_MODE_KEY));
    }

    public static int getServerPort() {
        int httpsPort = MappConst.getHttpsPort();
        if (httpsPort > 0) {
            return httpsPort;
        }
        String port = ServerProps.getProperty(WEB_SERVER_PORT);
        if (port == null) {
            ServerProps.setProperty(WEB_SERVER_PORT, String.valueOf(8080));
            return 8080;
        }
        return Integer.parseInt(port.toString());
    }

    public static int getHttpsPort() {
        String port = ServerProps.getProperty(WEB_SERVER_HTTPS_PORT);
        if (port == null) {
            String httpsPort = "0";
            ServerProps.setProperty(WEB_SERVER_HTTPS_PORT, "0");
            return 0;
        }
        return Integer.parseInt(port.toString());
    }

    public static String getServerName() {
        String serverName = ServerProps.getProperty(WEB_SERVER_NAME);
        if (serverName == null && (serverName = ServerProps.getProperty(WEB_SERVER_SPRING_NAME)) == null) {
            serverName = WEB_SERVER_NAME_DEFAULT;
        }
        ServerProps.setProperty(WEB_SERVER_NAME, serverName);
        return serverName;
    }

    public static String getServerContextPath() {
        String contextPath = ServerProps.getProperty(WEB_SERVER_CONTEXT_PATH);
        if (contextPath == null || contextPath.trim().length() == 0) {
            contextPath = ServerProps.getProperty(WEB_SERVER_CONTEXTPATH);
        }
        if (contextPath == null || contextPath.trim().length() == 0) {
            contextPath = WEB_SERVER_CONTEXTPATH_DEFAULT;
        }
        ServerProps.setProperty(WEB_SERVER_CONTEXTPATH, contextPath);
        return contextPath;
    }

    public static boolean isGW() {
        return GW.equalsIgnoreCase(ServerProps.getProperty("ygsoft.env"));
    }

    public static boolean orgCodeEnabled() {
        return "true".equalsIgnoreCase(ServerProps.getProperty("tenant.orgcode.enabled", "false"));
    }

    public static boolean orgCodeRefreshEnabled() {
        return "true".equalsIgnoreCase(ServerProps.getProperty("tenant.orgcode.refresh.enabled", "false"));
    }

    public static boolean isResponseAdvice() {
        return "true".equalsIgnoreCase(ServerProps.getProperty("response.advice.enabled", "true"));
    }

    public static boolean isVipaddressReg() {
        return "true".equalsIgnoreCase(ServerProps.getProperty("vipaddress.reg.enabled", "true"));
    }

    static {
        String httpConnectTimeout = ServerProps.getProperty(KEY_HTTP_CONNECT_TIMEOUT);
        HTTP_CONNECT_TIMEOUT = httpConnectTimeout == null ? 5000 : Integer.parseInt(httpConnectTimeout);
        String httpReadTimeout = ServerProps.getProperty(KEY_HTTP_READ_TIMEOUT);
        HTTP_READ_TIMEOUT = httpReadTimeout == null ? 1800000 : Integer.parseInt(httpReadTimeout);
        REQUEST_USESUFFIXPATTERNMATCH = "true".equals(ServerProps.getProperty(KEY_REQUEST_USESUFFIXPATTERNMATCH, "false"));
        REQUEST_USETRAILINGSLASHMATCH = "true".equals(ServerProps.getProperty(KEY_REQUEST_USETRAILINGSLASHMATCH, "true"));
        REQUEST_REMOVESEMICOLONCONTENT = "true".equals(ServerProps.getProperty(KEY_REQUEST_REMOVESEMICOLONCONTENT, "false"));
    }
}

