/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.framework.exception;

import com.ygsoft.ecp.framework.exception.ErrorCodeService;
import com.ygsoft.ecp.framework.exception.ExceptionEvent;
import com.ygsoft.ecp.framework.i18n.LocaleHolder;
import com.ygsoft.ecp.framework.spring.SpringContextHolder;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;

public class BaseRuntimeException
extends RuntimeException
implements ErrorCodeService {
    private static final long serialVersionUID = -1335537235693671811L;
    public static final String ERROR_CODE = "BASE_RUNTIME_EXCEPTION";
    private String errorCode = "BASE_RUNTIME_EXCEPTION";

    public BaseRuntimeException() {
        super("base runtime exception error happened!");
        this.raiseExceptionEvent();
    }

    public BaseRuntimeException(String newerrorCode) {
        super("base runtime exception error happened! Error code is: " + newerrorCode);
        this.errorCode = newerrorCode;
        this.raiseExceptionEvent();
    }

    public BaseRuntimeException(String newerrorCode, String message) {
        super(message);
        this.errorCode = newerrorCode;
        this.raiseExceptionEvent();
    }

    public BaseRuntimeException(Throwable cause) {
        super("base runtime exception error happened!", cause);
        this.raiseExceptionEvent();
    }

    public BaseRuntimeException(String newerrorCode, Throwable cause) {
        super("base runtime exception error happened! Error code is: " + newerrorCode, cause);
        this.errorCode = newerrorCode;
        this.raiseExceptionEvent();
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getStackTraceString() {
        StringWriter sw = new StringWriter(2048);
        PrintWriter pw = new PrintWriter(sw);
        this.printStackTrace(pw);
        String result = sw.toString();
        try {
            sw.close();
            pw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public ErrorCodeService getRootErrorCodedException() {
        ErrorCodeService root = this;
        while (root.getCause() != null && root.getCause() instanceof ErrorCodeService) {
            root = (ErrorCodeService)((Object)root.getCause());
        }
        return root;
    }

    public Throwable getRootCause() {
        Throwable root = this;
        while (!root.getClass().getName().startsWith("java.") && !root.getClass().getName().startsWith("javax.") && root.getCause() != null) {
            root = root.getCause();
        }
        return root;
    }

    public String toString() {
        return this.getMessage();
    }

    public Object[] getArguments() {
        return new Object[]{this.errorCode};
    }

    public String getMessage() {
        return SpringContextHolder.INSTANCE.getMessageSource().getMessage(this.errorCode, this.getArguments(), super.getMessage(), LocaleHolder.INSTANCE.getLocale());
    }

    private void raiseExceptionEvent() {
        Throwable cause = this.getCause();
        if (cause != null && cause instanceof ErrorCodeService) {
            return;
        }
        ApplicationContext applicationContext = SpringContextHolder.INSTANCE.getApplicationContext();
        ExceptionEvent event = new ExceptionEvent(this, ERROR_CODE, new Object());
        applicationContext.publishEvent((ApplicationEvent)event);
    }
}

