/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.framework.spring;

import java.lang.reflect.Field;
import java.lang.reflect.Proxy;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.framework.AopProxy;

public final class AopUtils {
    public static Object getTarget(Object proxy) {
        try {
            if (org.springframework.aop.support.AopUtils.isJdkDynamicProxy((Object)proxy)) {
                return AopUtils.getJdkDynamicProxyTargetObject(proxy);
            }
            if (org.springframework.aop.support.AopUtils.isCglibProxy((Object)proxy)) {
                return AopUtils.getCglibProxyTargetObject(proxy);
            }
            if (Proxy.isProxyClass(proxy.getClass())) {
                return AopUtils.getJdkOriginProxyTargetObject(proxy);
            }
            return proxy;
        }
        catch (Exception e) {
            return proxy;
        }
    }

    private static Object getCglibProxyTargetObject(Object proxy) throws Exception {
        Field h = proxy.getClass().getDeclaredField("CGLIB$CALLBACK_0");
        h.setAccessible(true);
        Object dynamicAdvisedInterceptor = h.get(proxy);
        Field advised = dynamicAdvisedInterceptor.getClass().getDeclaredField("advised");
        advised.setAccessible(true);
        Object target = ((AdvisedSupport)advised.get(dynamicAdvisedInterceptor)).getTargetSource().getTarget();
        return target;
    }

    private static Object getJdkDynamicProxyTargetObject(Object proxy) throws Exception {
        Field h = proxy.getClass().getSuperclass().getDeclaredField("h");
        h.setAccessible(true);
        AopProxy aopProxy = (AopProxy)h.get(proxy);
        Field advised = aopProxy.getClass().getDeclaredField("advised");
        advised.setAccessible(true);
        Object target = ((AdvisedSupport)advised.get(aopProxy)).getTargetSource().getTarget();
        return target;
    }

    private static Object getJdkOriginProxyTargetObject(Object proxy) throws Exception {
        Field h = proxy.getClass().getSuperclass().getDeclaredField("h");
        h.setAccessible(true);
        Object aopProxy = h.get(proxy);
        Field[] fields = aopProxy.getClass().getDeclaredFields();
        Field targetField = null;
        for (Field field : fields) {
            if (!field.getName().contains("val$")) continue;
            targetField = field;
            break;
        }
        if (targetField != null) {
            targetField.setAccessible(true);
            Object target = targetField.get(aopProxy);
            return target;
        }
        return proxy;
    }
}

