/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.framework.token;

import com.ygsoft.ecp.framework.actuator.TraceHolder;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class TokenHolder {
    private static final Log LOG = LogFactory.getLog(TokenHolder.class);
    private final ThreadLocal<String> TOKEN = new ThreadLocal();
    private final ThreadLocal<Boolean> MUL_DATASOURCE_SLAVE_TAG = new ThreadLocal();
    private final ThreadLocal<Boolean> MUL_DATASOURCE_SLAVE_ALLOW_DELAY_TAG = new ThreadLocal();
    private final ThreadLocal<Boolean> MUL_DATASOURCE_SLAVE_AFF_TAG = new ThreadLocal();
    private final ThreadLocal<String> CLIENT_IP = new ThreadLocal();
    private final ThreadLocal<String> threadTenantId = new ThreadLocal();
    private final ThreadLocal<String> ORGCODE = new ThreadLocal();
    public static final TokenHolder INSTANCE = new TokenHolder();

    private TokenHolder() {
    }

    public void setMulDatasourceSlaveTag(Boolean mulDatasourceSlaveTag) {
        if (mulDatasourceSlaveTag != null) {
            this.MUL_DATASOURCE_SLAVE_TAG.set(mulDatasourceSlaveTag);
        }
    }

    public void setMulDatasourceSlaveAllowDelayTag(Boolean mulDatasourceSlaveAllowDelayTag) {
        if (mulDatasourceSlaveAllowDelayTag != null) {
            this.MUL_DATASOURCE_SLAVE_ALLOW_DELAY_TAG.set(mulDatasourceSlaveAllowDelayTag);
        }
    }

    public void setMulDatasourceSlaveAffTag(Boolean mulDatasourceSlaveAffTag) {
        if (mulDatasourceSlaveAffTag != null) {
            this.MUL_DATASOURCE_SLAVE_AFF_TAG.set(mulDatasourceSlaveAffTag);
        }
    }

    public Boolean getMulDatasourceSlaveAffTag() {
        return this.MUL_DATASOURCE_SLAVE_AFF_TAG.get();
    }

    public void removeMulDatasourceSlaveAffTag() {
        this.MUL_DATASOURCE_SLAVE_AFF_TAG.remove();
    }

    public void removeMulDatasourceSlaveAllowDelayTag() {
        this.MUL_DATASOURCE_SLAVE_ALLOW_DELAY_TAG.remove();
    }

    public Boolean getMulDatasourceSlaveTag() {
        return this.MUL_DATASOURCE_SLAVE_TAG.get();
    }

    public Boolean getMulDatasourceSlaveAllowDelayTag() {
        return this.MUL_DATASOURCE_SLAVE_ALLOW_DELAY_TAG.get();
    }

    public void removeMulDatasourceSlaveTag() {
        this.MUL_DATASOURCE_SLAVE_TAG.remove();
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"\u5df2\u6e05\u7406\u7ebf\u7a0b\u53d8\u91cf-\u9009\u62e9\u4ece\u5e93\u6807\u8bb0");
        }
    }

    public void batchRemoveMulDatasourceSlaveAllTag() {
        this.removeMulDatasourceSlaveTag();
        this.removeMulDatasourceSlaveAffTag();
        this.removeMulDatasourceSlaveAllowDelayTag();
    }

    public void setTenantId(String tenantId) {
        if (tenantId != null) {
            this.threadTenantId.set(tenantId);
        }
    }

    public String getTenantId() {
        return this.threadTenantId.get();
    }

    public void clearTenantId() {
        this.threadTenantId.remove();
    }

    public String getToken() {
        return this.TOKEN.get();
    }

    public String getOrgCode() {
        return this.ORGCODE.get();
    }

    public void setToken(String token) {
        this.TOKEN.set(token);
    }

    public String getClientIP() {
        return this.CLIENT_IP.get();
    }

    public void setClientIP(String ip) {
        this.CLIENT_IP.set(ip);
    }

    public void setOrgCode(String orgcode) {
        this.ORGCODE.set(orgcode);
    }

    public void setToken(HttpServletRequest httpRequest) {
        try {
            Cookie[] cookies;
            String token = httpRequest.getHeader("ecp_token");
            if (token == null || token.trim().length() == 0) {
                token = httpRequest.getParameter("ecp_token");
            }
            if ((token == null || token.trim().length() == 0) && (cookies = httpRequest.getCookies()) != null) {
                for (int i = 0; i < cookies.length; ++i) {
                    if (!"ecp_token".equalsIgnoreCase(cookies[i].getName()) && !"ecpDataContext.tokenId".equalsIgnoreCase(cookies[i].getName())) continue;
                    token = cookies[i].getValue();
                    break;
                }
            }
            if (token != null && token.trim().length() > 0) {
                this.setToken(token);
            } else {
                this.setToken("");
            }
        }
        catch (Throwable e) {
            this.setToken("");
        }
    }

    public void setOrgCOde(HttpServletRequest request) {
        try {
            String orgCode = "";
            Cookie[] cookies = request.getCookies();
            if (cookies != null) {
                for (int i = 0; i < cookies.length; ++i) {
                    if (!"orgCode".equalsIgnoreCase(cookies[i].getName())) continue;
                    orgCode = cookies[i].getValue();
                    break;
                }
            }
            this.setOrgCode(orgCode);
        }
        catch (Throwable e) {
            this.setOrgCode("");
        }
    }

    public void setClientIP(HttpServletRequest request) {
        try {
            Cookie[] cookies;
            String remoteIp = request.getHeader("RemoteIp");
            if (this.isUnknown(remoteIp)) {
                remoteIp = request.getHeader("client_ip");
            }
            if (this.isUnknown(remoteIp) && (cookies = request.getCookies()) != null) {
                for (int i = 0; i < cookies.length; ++i) {
                    if (!"client_ip".equalsIgnoreCase(cookies[i].getName())) continue;
                    remoteIp = cookies[i].getValue();
                    break;
                }
            }
            if (this.isUnknown(remoteIp)) {
                remoteIp = request.getHeader("Proxy-Client-IP");
            }
            if (this.isUnknown(remoteIp)) {
                remoteIp = request.getHeader("x-forwarded-for");
            }
            if (this.isUnknown(remoteIp)) {
                remoteIp = request.getHeader("X-Real-IP");
            }
            if (this.isUnknown(remoteIp)) {
                remoteIp = request.getHeader("WL-Proxy-Client-IP");
            }
            if (this.isUnknown(remoteIp) && (remoteIp = request.getRemoteAddr()) != null && remoteIp.endsWith(".0") && (remoteIp = request.getHeader("host")) != null && remoteIp.indexOf(":") != -1) {
                remoteIp = remoteIp.substring(0, remoteIp.indexOf(":"));
            }
            if (this.isUnknown(remoteIp)) {
                remoteIp = request.getHeader("http_client_ip");
            }
            if (this.isUnknown(remoteIp)) {
                remoteIp = request.getHeader("HTTP_X_FORWARDED_FOR");
            }
            if (remoteIp != null && remoteIp.indexOf(",") != -1) {
                remoteIp = remoteIp.substring(0, remoteIp.indexOf(",")).trim();
            }
            this.setClientIP(remoteIp);
        }
        catch (Throwable e) {
            this.setClientIP("0.0.0.0");
        }
    }

    private boolean isUnknown(String remoteIp) {
        return remoteIp == null || remoteIp.length() == 0 || "unknown".equalsIgnoreCase(remoteIp);
    }

    public void clearToken() {
        this.TOKEN.remove();
    }

    public void clearClientIP() {
        this.CLIENT_IP.remove();
    }

    public void cleanOrgCode() {
        this.ORGCODE.remove();
    }

    public void setRequest(HttpServletRequest httpRequest) {
        INSTANCE.clearToken();
        TraceHolder.INSTANCE.clearPid();
        TraceHolder.INSTANCE.clearId();
        INSTANCE.clearClientIP();
        INSTANCE.cleanOrgCode();
        INSTANCE.clearTenantId();
        INSTANCE.setToken(httpRequest);
        TraceHolder.INSTANCE.setPid(httpRequest);
        INSTANCE.setClientIP(httpRequest);
        LOG.info((Object)("\u94fe\u8def\u4fe1\u606f\uff1a " + TraceHolder.INSTANCE.toString() + " \u8bf7\u6c42url: [" + httpRequest.getRequestURI() + "]"));
        LOG.info((Object)("\u94fe\u8def\u4fe1\u606f\uff1a " + INSTANCE.toString()));
    }

    public String toString() {
        return "TokenHolder [TOKEN=" + this.TOKEN.get() + ", CLIENT_IP=" + this.CLIENT_IP.get() + ", ORGCODE=" + this.ORGCODE.get() + "]";
    }

    public void batchSetMulDatasourceSlaveAllTag(boolean tag) {
        this.setMulDatasourceSlaveTag(tag);
        this.setMulDatasourceSlaveAffTag(tag);
        this.setMulDatasourceSlaveAllowDelayTag(tag);
    }
}

