/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.framework.util;

import javax.servlet.ServletContext;

public final class AppServerUtil {
    private static final AppServer APPSERVER = new AppServer();

    private AppServerUtil() {
    }

    public static final void initAppServer(ServletContext servletContext) {
        String serverInfo = servletContext.getServerInfo();
        AppServerUtil.APPSERVER.contextPath = servletContext.getContextPath();
        if (serverInfo == null || serverInfo.trim().length() == 0 || "ecp".equals(serverInfo)) {
            AppServerUtil.APPSERVER.serverType = ServerType.Tomcat;
            AppServerUtil.APPSERVER.serverName = System.getProperty("server.name");
        } else if (serverInfo.startsWith("IBM WebSphere Application")) {
            AppServerUtil.APPSERVER.serverType = ServerType.Websphere;
        } else if (serverInfo.startsWith("SAP")) {
            AppServerUtil.APPSERVER.serverType = ServerType.Netweaver;
        } else if (serverInfo.startsWith("Apusic")) {
            AppServerUtil.APPSERVER.serverType = ServerType.Apusic;
        } else if (serverInfo.startsWith("InforSuite")) {
            String serverName = System.getProperty("com.cvicse.las.instanceRoot");
            if (serverName != null && serverName.length() > 1) {
                serverName = serverName.substring(serverName.lastIndexOf("/") + 1);
            }
            AppServerUtil.APPSERVER.serverType = ServerType.Inforsuite;
            AppServerUtil.APPSERVER.serverName = serverName;
        } else if (serverInfo.startsWith("SMF Web")) {
            AppServerUtil.APPSERVER.serverType = ServerType.YGcloud;
            AppServerUtil.APPSERVER.serverName = System.getProperty("wlp.server.name");
        } else if (serverInfo.startsWith("Vsettan ToprowAS")) {
            AppServerUtil.APPSERVER.serverType = ServerType.YGcloud;
            AppServerUtil.APPSERVER.serverName = System.getProperty("wlp.server.name");
        } else if (serverInfo.startsWith("Apache Tomcat")) {
            String jbossServerName = System.getProperty("jboss.server.name");
            if (jbossServerName != null) {
                AppServerUtil.APPSERVER.serverType = ServerType.Jboss;
                AppServerUtil.APPSERVER.serverName = jbossServerName;
            } else {
                AppServerUtil.APPSERVER.serverType = ServerType.Tomcat;
                AppServerUtil.APPSERVER.serverName = serverInfo;
            }
        } else if (serverInfo.startsWith("jetty")) {
            AppServerUtil.APPSERVER.serverType = ServerType.Jetty;
            AppServerUtil.APPSERVER.serverName = serverInfo;
        } else {
            AppServerUtil.APPSERVER.serverType = ServerType.Weblogic;
            AppServerUtil.APPSERVER.serverName = System.getProperty("weblogic.Name");
        }
        String path = System.getProperty("user.dir");
        if (path != null) {
            String str = "/" + AppServerUtil.APPSERVER.serverName + "/";
            if (path.indexOf(str) == -1) {
                AppServerUtil.APPSERVER.serverPath = path;
                return;
            }
            int index = path.indexOf(str) + str.length();
            if (ServerType.Weblogic.equals((Object)AppServerUtil.APPSERVER.serverType) || ServerType.YGcloud.equals((Object)AppServerUtil.APPSERVER.serverType) || ServerType.Websphere.equals((Object)AppServerUtil.APPSERVER.serverType)) {
                str = "/servers/" + AppServerUtil.APPSERVER.serverName + "/";
                index = path.indexOf(str) + str.length();
            } else if (ServerType.Inforsuite.equals((Object)AppServerUtil.APPSERVER.serverType)) {
                str = "/domains/" + AppServerUtil.APPSERVER.serverName + "/";
                index = path.indexOf(str) + str.length();
            }
            if (index > 0 && path.length() > index) {
                AppServerUtil.APPSERVER.serverPath = path.substring(0, index);
            }
        }
    }

    public static AppServer getAppServer() {
        return APPSERVER;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ServerType {
        Weblogic,
        Websphere,
        YGcloud,
        Jboss,
        SGAPS,
        Apusic,
        Inforsuite,
        Netweaver,
        Tomcat,
        Jetty,
        Junit;

    }

    public static class AppServer {
        String serverPath;
        ServerType serverType;
        String serverName;
        String contextPath;

        public ServerType getServerType() {
            return this.serverType;
        }
    }
}

