/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.framework.util;

import com.ygsoft.ecp.framework.util.KeyEncoderUtil;
import com.ygsoft.ecp.framework.util.SM4Util;
import org.springframework.util.StringUtils;

public class CryptUtil {
    public static final String SM4 = "SMF_";
    public static final String SM4CBC = "SMFC_";
    private static final String SM4_DEFAULT_KEY = KeyEncoderUtil.getCustomBackKey();
    private static final String SM4CBC_DEFAULT_KEY = System.getProperty("sm4key", SM4_DEFAULT_KEY);

    public static final String encodeSM4CBC(String key, String message) {
        String k = key;
        if (StringUtils.isEmpty((Object)key)) {
            k = SM4CBC_DEFAULT_KEY;
        }
        try {
            String result = SM4Util.protectMsg(k, message);
            if (!StringUtils.isEmpty((Object)result)) {
                return result;
            }
            return message;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return message;
        }
    }

    public static final String decodeSM4CBC(String key, String message) {
        String k = key;
        if (StringUtils.isEmpty((Object)key)) {
            k = SM4CBC_DEFAULT_KEY;
        }
        try {
            String result = SM4Util.uncoverMsg(k, message);
            if (!StringUtils.isEmpty((Object)result)) {
                return result;
            }
            return message;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return message;
        }
    }
}

