/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.framework.util;

import com.ygsoft.ecp.framework.util.ByteUtils;
import com.ygsoft.ecp.framework.util.ClassUtil;
import com.ygsoft.ecp.framework.util.SecurityKeyUtil;
import java.lang.reflect.Constructor;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SM4Util {
    private static final String ENCODING = "UTF-8";
    public static final String ALGORITHM_NAME = "SM4";
    public static final String ALGORITHM_NAME_CBC_PADDING = "SM4/CBC/PKCS5Padding";
    public static final int DEFAULT_KEY_SIZE = 128;

    public static byte[] generateKey() throws Exception {
        return SM4Util.generateKey(128);
    }

    public static String generateKeyString() throws Exception {
        return ByteUtils.toHexString(SM4Util.generateKey());
    }

    public static byte[] generateKey(int keySize) throws Exception {
        KeyGenerator kg = KeyGenerator.getInstance(ALGORITHM_NAME, "BC");
        kg.init(keySize, new SecureRandom());
        return kg.generateKey().getEncoded();
    }

    public static String protectMsg(String hexKey, String paramStr) throws Exception {
        String result = "";
        byte[] keyData = ByteUtils.fromHexString(hexKey);
        byte[] srcData = paramStr.getBytes(ENCODING);
        byte[] cipherArray = SM4Util.encrypt_Cbc_Padding(keyData, srcData);
        result = ByteUtils.toHexString(cipherArray);
        return result;
    }

    public static String protectMsg(byte[] key1, byte[] key2, String paramStr) throws Exception {
        String result = "";
        byte[] keyData = ByteUtils.fromHexString(new String(SM4Util.byteMergerAll(key1, key2)));
        Arrays.fill(key1, (byte)0);
        Arrays.fill(key2, (byte)0);
        byte[] srcData = paramStr.getBytes(ENCODING);
        paramStr = null;
        byte[] cipherArray = SM4Util.encrypt_Cbc_Padding(keyData, srcData);
        Arrays.fill(keyData, (byte)0);
        Arrays.fill(srcData, (byte)0);
        result = ByteUtils.toHexString(cipherArray);
        Arrays.fill(cipherArray, (byte)0);
        return result;
    }

    public static byte[] encrypt_Cbc_Padding(byte[] key, byte[] data) throws Exception {
        Cipher cipher = SM4Util.generateCbcCipher(ALGORITHM_NAME_CBC_PADDING, 1, key);
        return cipher.doFinal(data);
    }

    private static Cipher generateCbcCipher(String algorithmName, int mode, byte[] key) throws Exception {
        Cipher cipher = (Cipher)ClassUtil.callMethod(Cipher.class, "getInstance", new Object[]{algorithmName, "BC"});
        SecretKeySpec sm4Key = new SecretKeySpec(key, ALGORITHM_NAME);
        cipher.init(mode, (Key)sm4Key, SM4Util.generateIV());
        return cipher;
    }

    public static AlgorithmParameters generateIV() throws Exception {
        byte[] iv = new byte[16];
        String sm4cbcIv = SecurityKeyUtil.getSM4CBCIv();
        if (!StringUtils.isEmpty((Object)sm4cbcIv)) {
            iv = SM4Util.hexToByte(sm4cbcIv);
            if (iv.length != 16) {
                throw new RuntimeException("iv\u503c\u9519\u8bef\uff0c\u957f\u5ea6\u5e76\u4e0d\u7b49\u4e8e16");
            }
        } else {
            Arrays.fill(iv, (byte)0);
        }
        AlgorithmParameters params = AlgorithmParameters.getInstance(ALGORITHM_NAME);
        params.init(SM4Util.getIvParameterSpec(iv));
        return params;
    }

    public static IvParameterSpec getIvParameterSpec(byte[] iv) throws Exception {
        Constructor<?> constructor = SM4Util.findConstructor(IvParameterSpec.class, new Object[]{iv});
        return (IvParameterSpec)constructor.newInstance(new Object[]{iv});
    }

    private static Constructor<?> findConstructor(Class<?> type, Object ... constructorArguments) {
        for (Constructor<?> candidate : type.getDeclaredConstructors()) {
            Class<?>[] parameterTypes = candidate.getParameterTypes();
            if (!SM4Util.argumentsMatch(parameterTypes, constructorArguments)) continue;
            return candidate;
        }
        return null;
    }

    private static final boolean argumentsMatch(Class<?>[] parameterTypes, Object[] arguments) {
        if (parameterTypes.length != arguments.length) {
            return false;
        }
        int index = 0;
        for (Class<?> argumentType : parameterTypes) {
            Object argument = arguments[index];
            if (argumentType.isPrimitive() && argument == null) {
                return false;
            }
            ++index;
        }
        return true;
    }

    public static byte[] hexToByte(String hex) {
        int m = 0;
        int n = 0;
        int byteLen = hex.length() / 2;
        byte[] ret = new byte[byteLen];
        for (int i = 0; i < byteLen; ++i) {
            m = i * 2 + 1;
            n = m + 1;
            int intVal = Integer.decode("0x" + hex.substring(i * 2, m) + hex.substring(m, n));
            ret[i] = (byte)intVal;
        }
        return ret;
    }

    public static String uncoverMsg(String hexKey, String text) throws Exception {
        String result = "";
        byte[] keyData = ByteUtils.fromHexString(hexKey);
        byte[] resultData = ByteUtils.fromHexString(text);
        byte[] srcData = SM4Util.decrypt_Cbc_Padding(keyData, resultData);
        result = new String(srcData, ENCODING);
        return result;
    }

    public static byte[] decrypt_Cbc_Padding(byte[] key, byte[] cipherText) throws Exception {
        Cipher cipher = SM4Util.generateCbcCipher(ALGORITHM_NAME_CBC_PADDING, 2, key);
        return cipher.doFinal(cipherText);
    }

    private static byte[] byteMergerAll(byte[] ... values) {
        int length_byte = 0;
        for (int i = 0; i < values.length; ++i) {
            length_byte += values[i].length;
        }
        byte[] all_byte = new byte[length_byte];
        int countLength = 0;
        for (int i = 0; i < values.length; ++i) {
            byte[] b = values[i];
            System.arraycopy(b, 0, all_byte, countLength, b.length);
            countLength += b.length;
        }
        return all_byte;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

