/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.framework.util;

import com.ygsoft.ecp.framework.util.ZoneNameId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TimeZoneUtil {
    private static final Map<String, String> NAMES_IDS = new HashMap<String, String>();

    private TimeZoneUtil() {
    }

    private static void initGeneralTimeZone() {
        NAMES_IDS.put("\u96f6\u65f6\u533a", "Z");
        NAMES_IDS.put("\u897f1\u533a", "GMT-1");
        NAMES_IDS.put("\u897f2\u533a", "GMT-2");
        NAMES_IDS.put("\u897f3\u533a", "GMT-3");
        NAMES_IDS.put("\u897f4\u533a", "GMT-4");
        NAMES_IDS.put("\u897f5\u533a", "GMT-5");
        NAMES_IDS.put("\u897f6\u533a", "GMT-6");
        NAMES_IDS.put("\u897f7\u533a", "GMT-7");
        NAMES_IDS.put("\u897f8\u533a", "GMT-8");
        NAMES_IDS.put("\u897f9\u533a", "GMT-9");
        NAMES_IDS.put("\u897f10\u533a", "GMT-10");
        NAMES_IDS.put("\u897f11\u533a", "GMT-11");
        NAMES_IDS.put("\u897f12\u533a", "GMT-12");
        NAMES_IDS.put("\u4e1c1\u533a", "GMT+1");
        NAMES_IDS.put("\u4e1c2\u533a", "GMT+2");
        NAMES_IDS.put("\u4e1c3\u533a", "GMT+3");
        NAMES_IDS.put("\u4e1c4\u533a", "GMT+4");
        NAMES_IDS.put("\u4e1c5\u533a", "GMT+5");
        NAMES_IDS.put("\u4e1c6\u533a", "GMT+6");
        NAMES_IDS.put("\u4e1c7\u533a", "GMT+7");
        NAMES_IDS.put("\u4e1c8\u533a", "GMT+8");
        NAMES_IDS.put("\u4e1c9\u533a", "GMT+9");
        NAMES_IDS.put("\u4e1c10\u533a", "GMT+10");
        NAMES_IDS.put("\u4e1c11\u533a", "GMT+11");
        NAMES_IDS.put("\u4e1c12\u533a", "GMT+12");
    }

    public static List<ZoneNameId> getAvailableTimeZones() {
        ArrayList<ZoneNameId> rt = new ArrayList<ZoneNameId>();
        for (String name : NAMES_IDS.keySet()) {
            String id = NAMES_IDS.get(name);
            rt.add(new ZoneNameId(name, id));
        }
        return rt;
    }

    public static TimeZone getTimeZoneById(String id) {
        return TimeZone.getTimeZone(id);
    }

    public static TimeZone getTimeZoneByName(String name) {
        String id = NAMES_IDS.get(name);
        return TimeZoneUtil.getTimeZoneById(id);
    }

    static {
        NAMES_IDS.put("\u4e2d\u592e\u6807\u51c6\u65f6\u95f4\uff08\u5317\u9886\u5730\uff09", "ACT");
        NAMES_IDS.put("\u4e1c\u90e8\u6807\u51c6\u65f6\u95f4\uff08\u65b0\u5357\u5a01\u5c14\u65af\uff09", "AET");
        NAMES_IDS.put("\u963f\u6839\u5ef7\u65f6\u95f4", "AGT");
        NAMES_IDS.put("\u4e1c\u6b27\u65f6\u95f4", "ART");
        NAMES_IDS.put("\u963f\u62c9\u65af\u52a0\u6807\u51c6\u65f6\u95f4", "AST");
        NAMES_IDS.put("\u5df4\u897f\u5229\u4e9a\u65f6\u95f4", "BET");
        NAMES_IDS.put("\u5b5f\u52a0\u62c9\u65f6\u95f4", "BST");
        NAMES_IDS.put("\u4e2d\u975e\u65f6\u95f4", "CAT");
        NAMES_IDS.put("\u7ebd\u82ac\u5170\u6807\u51c6\u65f6\u95f4", "CNT");
        NAMES_IDS.put("\u4e2d\u592e\u6807\u51c6\u65f6\u95f4", "CST");
        NAMES_IDS.put("\u4e2d\u56fd\u6807\u51c6\u65f6\u95f4", "CTT");
        NAMES_IDS.put("\u4e1c\u975e\u65f6\u95f4", "EAT");
        NAMES_IDS.put("\u4e2d\u6b27\u65f6\u95f4", "ECT");
        NAMES_IDS.put("\u4e1c\u90e8\u6807\u51c6\u65f6\u95f4", "IET");
        NAMES_IDS.put("\u5370\u5ea6\u6807\u51c6\u65f6\u95f4", "IST");
        NAMES_IDS.put("\u65e5\u672c\u6807\u51c6\u65f6\u95f4", "JST");
        NAMES_IDS.put("\u897f\u8428\u6469\u4e9a\u65f6\u95f4", "MIT");
        NAMES_IDS.put("\u4e9a\u7f8e\u5c3c\u4e9a\u65f6\u95f4", "NET");
        NAMES_IDS.put("\u65b0\u897f\u5170\u6807\u51c6\u65f6\u95f4", "NST");
        NAMES_IDS.put("\u5df4\u57fa\u65af\u5766\u65f6\u95f4", "PLT");
        NAMES_IDS.put("Mountain \u6807\u51c6\u65f6\u95f4", "PNT");
        NAMES_IDS.put("\u5927\u897f\u6d0b\u6807\u51c6\u65f6\u95f4", "PRT");
        NAMES_IDS.put("\u592a\u5e73\u6d0b\u6807\u51c6\u65f6\u95f4", "PST");
        NAMES_IDS.put("\u6240\u7f57\u95e8\u7fa4\u5c9b\u65f6\u95f4", "SST");
        NAMES_IDS.put("\u5370\u5ea6\u652f\u90a3\u65f6\u95f4", "VST");
        NAMES_IDS.put("\u4e1c\u90e8\u6807\u51c6\u65f6\u95f4", "EST");
        NAMES_IDS.put("Mountain \u6807\u51c6\u65f6\u95f4", "MST");
        NAMES_IDS.put("\u590f\u5a01\u5937\u6807\u51c6\u65f6\u95f4", "HST");
        TimeZoneUtil.initGeneralTimeZone();
    }
}

