/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.ascpect;

import com.ygsoft.abc.service.exception.RepeatSubmitException;
import com.ygsoft.abc.service.tool.RedisLockUtil;
import com.ygsoft.ecp.framework.token.TokenHolder;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class RepeatSubmitAspect {
    static final Logger LOGGER = LoggerFactory.getLogger(RepeatSubmitAspect.class);

    @Pointcut(value="@within(com.ygsoft.abc.service.annotation.NoRepeatSubmit) || @annotation(com.ygsoft.abc.service.annotation.NoRepeatSubmit)")
    public void pointCut() {
    }

    @Around(value="pointCut()")
    public Object around(ProceedingJoinPoint pjp) throws Throwable {
        return this.checkSubmit(pjp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object checkSubmit(ProceedingJoinPoint pjp) throws Throwable {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        assert (attributes != null);
        HttpServletRequest request = attributes.getRequest();
        Assert.notNull((Object)request, (String)"request can not null");
        String token = TokenHolder.INSTANCE.getToken();
        String path = String.valueOf(request.getRequestURL());
        String key = token + path;
        System.out.println("+++++++++key=" + key + ",Thread=" + Thread.currentThread().getName());
        RedisLockUtil lockUtil = RedisLockUtil.getInstance();
        try {
            boolean flag = lockUtil.tryLock(key, 1L);
            if (!flag) {
                throw RepeatSubmitException.newInstance("\u91cd\u590d\u8bf7\u6c42\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002");
            }
            Object object = pjp.proceed();
            return object;
        }
        finally {
            lockUtil.unlock();
        }
    }
}

