/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.ascpect;

import com.github.rholder.retry.Attempt;
import com.github.rholder.retry.Retryer;
import com.github.rholder.retry.RetryerBuilder;
import com.github.rholder.retry.StopStrategy;
import com.github.rholder.retry.WaitStrategies;
import com.ygsoft.abc.service.annotation.Retrying;
import com.ygsoft.abc.service.exception.AbcServiceException;
import com.ygsoft.ecp.service.exception.EcpRuntimeException;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class RetryingAspect {
    private static final IEcpLog LOG = EcpLogFactory.getLog(RetryingAspect.class);

    @Pointcut(value="@within(com.ygsoft.abc.service.annotation.Retrying) || @annotation(com.ygsoft.abc.service.annotation.Retrying)")
    public void pointCut() {
    }

    private Retrying getAnnotation(ProceedingJoinPoint joinPoint) {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Retrying trace = signature.getMethod().getAnnotation(Retrying.class);
        if (!Objects.isNull(trace)) {
            return trace;
        }
        trace = joinPoint.getTarget().getClass().getAnnotation(Retrying.class);
        return trace;
    }

    @Around(value="pointCut()")
    public Object around(final ProceedingJoinPoint joinPoint) throws Throwable {
        final Retrying retrying = this.getAnnotation(joinPoint);
        StopStrategy stopStrategy = new StopStrategy(){

            public boolean shouldStop(Attempt attempt) {
                long maxAttempt = retrying.attempt();
                if (attempt.getAttemptNumber() >= maxAttempt) {
                    return true;
                }
                Class<? extends Throwable>[] clazzs = retrying.stopTypes();
                if (clazzs == null || clazzs.length == 0) {
                    return false;
                }
                Class<?> cause = attempt.getExceptionCause().getClass();
                for (Class<? extends Throwable> clazz : clazzs) {
                    if (!clazz.equals(cause)) continue;
                    return true;
                }
                return false;
            }
        };
        Retryer retryer = RetryerBuilder.newBuilder().retryIfExceptionOfType(retrying.retryType()).withWaitStrategy(WaitStrategies.fixedWait((long)retrying.fixedWait(), (TimeUnit)TimeUnit.MILLISECONDS)).withStopStrategy(stopStrategy).build();
        if (LOG.isInfoEnabled()) {
            String msg = String.format("\u91cd\u8bd5\u6267\u884c\uff0c\u5f02\u5e38\uff08%s\uff09\uff0c\u95f4\u9694\uff08%s\uff09\uff0c\u6700\u5927\u6b21\u6570\uff08%s\uff09", retrying.retryType(), retrying.fixedWait(), retrying.attempt());
            LOG.info((Object)msg);
        }
        Callable<Object> callable = new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try {
                    return joinPoint.proceed();
                }
                catch (Throwable e) {
                    if (e instanceof EcpRuntimeException) {
                        throw (EcpRuntimeException)e;
                    }
                    throw AbcServiceException.newInstance(e.getMessage(), e);
                }
            }
        };
        Object result = retryer.call((Callable)callable);
        return result;
    }
}

