/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.attachment.io;

import com.ygsoft.abc.service.exception.AbcIOException;
import com.ygsoft.abc.service.tool.BlockIOUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.springframework.web.multipart.MultipartFile;

public class ExtMultipartFile
implements MultipartFile {
    private String name;
    private String originalFilename;
    private String contentType;
    private Long size;
    private byte[] bytes;
    private InputStream inputStream;
    private File file;

    public static ExtMultipartFile createFrom(File file, String fileName, String contentType) {
        try {
            ExtMultipartFile extMultipartFile = new ExtMultipartFile();
            extMultipartFile.name = fileName;
            extMultipartFile.originalFilename = fileName;
            extMultipartFile.contentType = contentType;
            extMultipartFile.size = file.length();
            extMultipartFile.file = file;
            return extMultipartFile;
        }
        catch (Exception e) {
            throw AbcIOException.newInstance("\u521b\u5efaExtMultipartFile\uff0c\u8bfb\u53d6\u9644\u4ef6size\u5931\u8d25\u3002", e);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getOriginalFilename() {
        return this.originalFilename;
    }

    public String getContentType() {
        return this.contentType;
    }

    public boolean isEmpty() {
        return this.size == 0L;
    }

    public long getSize() {
        return this.size;
    }

    public byte[] getBytes() throws IOException {
        if (Objects.isNull(this.bytes)) {
            this.bytes = BlockIOUtil.toByteArray(this.inputStream);
        }
        return this.bytes;
    }

    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    public void transferTo(File newDest) throws IOException, IllegalStateException {
    }

    public String getFilePath() {
        if (this.file == null) {
            return null;
        }
        return this.file.getPath();
    }
}

