/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.base.framework.domain.factory;

import com.ygsoft.abc.service.tool.CommonUtil;
import com.ygsoft.abc.service.tool.UrlUtils;
import com.ygsoft.ecp.core.framework.internal.context.LoginContext;
import com.ygsoft.ecp.mapp.common.service.util.LoginContextUtil;
import java.net.InetAddress;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public abstract class AbstractEntityFactory<T> {
    private static final String NO_URL = "-";
    private static volatile String ipAddress;

    public abstract T create();

    protected String getCurrentUserId() {
        LoginContext loginContext = (LoginContext)LoginContextUtil.getLoginContext();
        if (Objects.isNull(loginContext)) {
            return "sys";
        }
        return loginContext.getUserId();
    }

    protected String getCurrentIP() {
        if (Objects.isNull(ipAddress)) {
            InetAddress inetAddress = CommonUtil.getLocalAddress();
            ipAddress = Objects.isNull(inetAddress) ? "" : inetAddress.getHostAddress();
        }
        return ipAddress;
    }

    protected String getRequestUrl() {
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (Objects.isNull(requestAttributes)) {
            return NO_URL;
        }
        HttpServletRequest request = requestAttributes.getRequest();
        if (Objects.isNull(request)) {
            return NO_URL;
        }
        String url = UrlUtils.buildRequestUrl(request);
        return url;
    }
}

