/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.cache;

import com.ygsoft.abc.service.domain.bo.ChainSkeletonBO;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.JSONUtil;
import com.ygsoft.ecp.service.tool.RedisUtil;
import com.ygsoft.ecp.service.tool.StringUtil;
import java.util.Objects;

public class ChainSkeletonCacheClient {
    private static final IEcpLog LOG = EcpLogFactory.getLog(ChainSkeletonCacheClient.class);
    private static String CACHE_KEY = "abc:chain:skeleton";
    private static final ChainSkeletonCacheClient INSTANCE = new ChainSkeletonCacheClient();

    private ChainSkeletonCacheClient() {
    }

    public static ChainSkeletonCacheClient getInstance() {
        return INSTANCE;
    }

    public void setObject(ChainSkeletonBO chainSkeleton) {
        if (Objects.isNull((Object)chainSkeleton)) {
            this.logInfo("chainSkeleton\u4e3a\u7a7a\uff0c\u65e0\u9700\u8bbe\u7f6e\u7f13\u5b58\u3002");
            return;
        }
        String json = JSONUtil.toJsonString((Object)((Object)chainSkeleton));
        RedisUtil.getRedisService().set("abc", CACHE_KEY, json);
    }

    public ChainSkeletonBO getObject() {
        String json = RedisUtil.getRedisService().get("abc", CACHE_KEY);
        if (StringUtil.isNullOrTrimEmptyString((String)json)) {
            return null;
        }
        ChainSkeletonBO chainSkeleton = (ChainSkeletonBO)((Object)JSONUtil.fromJsonString((String)json, ChainSkeletonBO.class));
        return chainSkeleton;
    }

    protected void logInfo(Object obj) {
        if (LOG.isInfoEnabled()) {
            LOG.info(obj);
        }
    }

    protected void logError(Object obj, Throwable e) {
        if (LOG.isErrorEnabled()) {
            if (null == e) {
                LOG.error(obj);
            } else {
                LOG.error(obj, e);
            }
        }
    }
}

