/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.cache;

import com.ygsoft.ecp.framework.session.CommonSessionRepository;
import com.ygsoft.ecp.service.tool.RedisUtil;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public final class ContextContainerRedisClient {
    protected static int EXPIRE_SECONDS = 1800;
    private static final int TOKEN_EXPIRE_SECONDS = 28800;
    private static final int OPENID_EXPIRE_SECONDS = 43200;
    public static String TOKEN_KEY = "abc:lgncxt:tkn";
    public static String OPENID_KEY = "abc:lgncxt:opid";
    public static final ContextContainerRedisClient INSTANCE = new ContextContainerRedisClient();

    private ContextContainerRedisClient() {
    }

    @PostConstruct
    private void init() {
        EXPIRE_SECONDS = CommonSessionRepository.MAX_INACTIVE_INTERVAL_SECONDS;
    }

    public void setToken(String token, String userId) {
        Assert.notNull((Object)token, (String)"token\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        Assert.notNull((Object)userId, (String)"userId\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        String key = TOKEN_KEY + ":" + token;
        RedisUtil.getRedisService().setex("abc", key, 28800, userId);
    }

    public void setOpenId(String openId, String userGid) {
        String key = OPENID_KEY + ":" + openId;
        RedisUtil.getRedisService().setex("abc", key, 43200, userGid);
    }

    public String getToken(String token) {
        Assert.notNull((Object)token, (String)"token\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        String userId = RedisUtil.getRedisService().get("abc", TOKEN_KEY + ":" + token);
        return userId;
    }

    public String getOpenId(String openId) {
        String userGid = RedisUtil.getRedisService().get("abc", OPENID_KEY + ":" + openId);
        return userGid;
    }

    public void delToken(String token) {
        Assert.notNull((Object)token, (String)"token\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        RedisUtil.getRedisService().del("abc", TOKEN_KEY + ":" + token);
    }

    public void delOpenId(String openId) {
        RedisUtil.getRedisService().del("abc", OPENID_KEY + ":" + openId);
    }
}

