/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.cache;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.ygsoft.abc.service.exception.AbcJsonParseException;
import com.ygsoft.abc.service.exception.EmptyValueException;
import com.ygsoft.abc.service.exception.RecordNoneExistException;
import com.ygsoft.abc.service.login.domain.vo.ExtendLoginContext;
import com.ygsoft.abc.service.login.domain.vo.LoginContextVO;
import com.ygsoft.abc.service.tool.CastUtil;
import com.ygsoft.abc.service.tool.PropertyConfigUtil;
import com.ygsoft.alibaba.fastjson.JSON;
import com.ygsoft.ecp.service.cache.IRedisService;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.EcpI18nUtil;
import com.ygsoft.ecp.service.tool.RedisUtil;
import com.ygsoft.ecp.service.tool.StringUtil;
import java.util.Map;
import java.util.Objects;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Component;

@Component
public final class LoginContextRedisClient {
    private static IEcpLog LOG = EcpLogFactory.getLog(LoginContextRedisClient.class);
    private static ObjectMapper om = new ObjectMapper();
    public static String OBJECT_PREFIX = "abc:lgncxt:obj:";
    private static final int LOGIN_CONTEXT_EXPIRE_SECONDS = 28800;

    @PostConstruct
    private void init() {
    }

    private LoginContextRedisClient() {
    }

    public static void setCache(LoginContextVO loginContextVO) {
        if (null == loginContextVO) {
            String msg = EcpI18nUtil.localizedString((String)"LoginContextRedisClient_setCache_96", (String)"\u53c2\u6570\u9519\u8bef\uff1aloginContextVO\u4e3a\u7a7a\u3002");
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)msg);
            }
            throw new EmptyValueException("ABC.0001", msg);
        }
        if (StringUtil.isNullOrTrimEmptyString((String)loginContextVO.getUserId())) {
            String msg = EcpI18nUtil.localizedString((String)"LoginContextRedisClient_setCache_103", (String)"\u53c2\u6570\u9519\u8bef\uff1aloginContextVO\u7684userId\u4e3a\u7a7a\u3002");
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)msg);
            }
            throw new EmptyValueException("ABC.0001", msg);
        }
        IRedisService redis = RedisUtil.getRedisService();
        String objectKey = OBJECT_PREFIX + loginContextVO.getUserId();
        redis.set("abc", objectKey, JSON.toJSONString((Object)loginContextVO));
    }

    public static LoginContextVO getObject(String userId, boolean check) {
        if (StringUtil.isNullOrTrimEmptyString((String)userId)) {
            String msg = EcpI18nUtil.localizedString((String)"LoginContextRedisClient_getObject_141", (String)"\u53c2\u6570\u9519\u8bef\uff1auserId\u4e3a\u7a7a\u3002");
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)msg);
            }
            throw new EmptyValueException("ABC.0001", msg);
        }
        IRedisService redis = RedisUtil.getRedisService();
        String objectKey = OBJECT_PREFIX + userId;
        String voJson = redis.get("abc", objectKey);
        if (check && StringUtil.isNullOrTrimEmptyString((String)voJson)) {
            String msg = EcpI18nUtil.localizedString((String)"LoginContextRedisClient_getObject_154", (String)"\u9519\u8bef\uff1a\u6307\u5b9auserId\u767b\u5f55\u4e0a\u4e0b\u6587\u5bf9\u8c61\u4e0d\u5b58\u5728\u3002");
            throw new RecordNoneExistException("ABC.0004", msg);
        }
        if (StringUtil.isNullOrTrimEmptyString((String)voJson)) {
            return null;
        }
        LoginContextVO vo = (LoginContextVO)JSON.parseObject((String)voJson, LoginContextVO.class);
        return vo;
    }

    public static void setLoginContext(ExtendLoginContext extendLoginContext) {
        if (null == extendLoginContext) {
            String msg = EcpI18nUtil.localizedString((String)"LoginContextRedisClient_setLoginContext_179", (String)"\u53c2\u6570\u9519\u8bef\uff1aextendLoginContext\u4e3a\u7a7a\u3002");
            throw new EmptyValueException("ABC.0001", msg);
        }
        String userId = extendLoginContext.getUserId();
        if (StringUtil.isNullOrTrimEmptyString((String)userId)) {
            String msg = EcpI18nUtil.localizedString((String)"LoginContextRedisClient_setLoginContext_184", (String)"\u767b\u5f55\u4e0a\u4e0b\u6587\u4e2duserId\u4e3a\u7a7a\u3002");
            throw new EmptyValueException("ABC.0001", msg);
        }
        IRedisService redis = RedisUtil.getRedisService();
        String objectKey = OBJECT_PREFIX + userId;
        String ret = redis.hmset("abc", objectKey, extendLoginContext.toExtendMap());
        IRedisService redis2 = RedisUtil.getRedisService();
        Long ret2 = redis2.expire("abc", objectKey, LoginContextRedisClient.getLoginContextExpireSeconds());
        if (null == ret || null == ret2) {
            throw new AbcJsonParseException("ABC.0017", "\u7f13\u5b58\u767b\u5f55\u4e0a\u4e0b\u6587\u5931\u8d25\u3002");
        }
    }

    private static int getLoginContextExpireSeconds() {
        String value = PropertyConfigUtil.getProperty("abc.basic4a.login_context_expire");
        if (StringUtil.isNullOrTrimEmptyString((String)value)) {
            return 28800;
        }
        return CastUtil.getInteger(value);
    }

    public static ExtendLoginContext getLoginContext(String userId, boolean check) {
        if (StringUtil.isNullOrTrimEmptyString((String)userId)) {
            String msg = EcpI18nUtil.localizedString((String)"LoginContextRedisClient_getLoginContext_214", (String)"\u53c2\u6570\u9519\u8bef\uff1auserId\u4e3a\u7a7a\u3002");
            throw new EmptyValueException("ABC.0001", msg);
        }
        IRedisService redis = RedisUtil.getRedisService();
        String objectKey = OBJECT_PREFIX + userId;
        Map map = redis.hgetAll("abc", objectKey);
        if (check && Objects.isNull(map)) {
            String msg = EcpI18nUtil.localizedString((String)"LoginContextRedisClient_getLoginContext_226", (String)"\u9519\u8bef\uff1a\u6307\u5b9auserId\u767b\u5f55\u4e0a\u4e0b\u6587\u5bf9\u8c61\u4e0d\u5b58\u5728\u3002");
            throw new RecordNoneExistException("ABC.0004", msg);
        }
        if (Objects.isNull(map) || map.isEmpty()) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("###>\u6307\u5b9auserId(" + userId + ")\u767b\u5f55\u4e0a\u4e0b\u6587\u5bf9\u8c61\u4e0d\u5b58\u5728\u3002"));
            }
            return null;
        }
        return ExtendLoginContext.fromMap(map);
    }
}

