/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.common.domain.bo;

import com.google.common.base.Joiner;
import com.ygsoft.abc.service.common.domain.bo.LargeObjectFragSummary;
import com.ygsoft.abc.service.exception.CheckFailedException;
import com.ygsoft.abc.service.exception.EmptyValueException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class LargeObjectFragDetail
implements Serializable {
    private static final long serialVersionUID = -3458339566713234458L;
    private static final String EMPTY_STRING = "";
    private static final LargeObjectFragDetail EMPTY_INSTANCE = new LargeObjectFragDetail(new ArrayList<String>(), null);
    private final List<String> frags;
    private final String original;

    public static LargeObjectFragDetail getEmptyInstance() {
        return EMPTY_INSTANCE;
    }

    public static LargeObjectFragDetail newInstance(List<String> frags, String original) {
        if (Objects.isNull(original)) {
            return EMPTY_INSTANCE;
        }
        if (Objects.isNull(frags)) {
            throw EmptyValueException.newInstance("\u53c2\u6570\u9519\u8bef\uff1afrags\u4e3a\u7a7a\u3002");
        }
        String joinString = Joiner.on((String)EMPTY_STRING).join(frags);
        if (!original.equals(joinString)) {
            throw CheckFailedException.newInstance("\u5207\u5272\u540e\u5b57\u7b26\u4e32\u4e0e\u539f\u5b57\u7b26\u4e32\u4e0d\u76f8\u7b49\u3002");
        }
        return new LargeObjectFragDetail(frags, original);
    }

    private LargeObjectFragDetail(List<String> frags, String original) {
        this.frags = frags;
        this.original = original;
    }

    public LargeObjectFragSummary getSummary() {
        LargeObjectFragSummary summary = new LargeObjectFragSummary();
        summary.setFragSize(this.frags.size());
        if (Objects.isNull(this.original)) {
            summary.setOriginalLength(0);
            summary.setOriginalHash(0);
        } else {
            summary.setOriginalLength(this.original.length());
            summary.setOriginalHash(this.original.hashCode());
        }
        return summary;
    }

    public String getFirst() {
        return this.frags.get(0);
    }

    public List<String> getFrags() {
        return this.frags;
    }

    public String getOriginal() {
        return this.original;
    }
}

