/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.common.types;

import com.google.common.collect.ImmutableMap;
import java.util.Map;

public enum EcpStorageType {
    DB{

        @Override
        public boolean isDB() {
            return true;
        }
    }
    ,
    FILE{

        @Override
        public boolean isFile() {
            return true;
        }
    }
    ,
    SFTP{

        @Override
        public boolean isSftp() {
            return true;
        }
    }
    ,
    COS{

        @Override
        public boolean isCos() {
            return true;
        }
    }
    ,
    SWIFT{

        @Override
        public boolean isSwift() {
            return true;
        }
    }
    ,
    HDFS{

        @Override
        public boolean isHdfs() {
            return true;
        }
    };

    public static final String[] CAPTIONS;
    private static final Map<String, EcpStorageType> NAME_TO_ENUM;

    public static EcpStorageType parse(String name) {
        return NAME_TO_ENUM.get(name);
    }

    public boolean isDB() {
        return false;
    }

    public boolean isFile() {
        return false;
    }

    public boolean isSftp() {
        return false;
    }

    public boolean isCos() {
        return false;
    }

    public boolean isSwift() {
        return false;
    }

    public boolean isHdfs() {
        return false;
    }

    static {
        CAPTIONS = new String[]{"DB", "FILE", "SFTP", "COS", "SWIFT", "HDFS"};
        NAME_TO_ENUM = ImmutableMap.builder().put((Object)"DB", (Object)DB).put((Object)"FILE", (Object)FILE).put((Object)"SFTP", (Object)SFTP).put((Object)"COS", (Object)COS).put((Object)"SWIFT", (Object)SWIFT).put((Object)"HDFS", (Object)HDFS).build();
    }
}

