/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.common.util;

import com.ygsoft.abc.service.exception.AbcIOException;
import com.ygsoft.abc.service.exception.DocumentParseException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class Dom4jUtil {
    private Dom4jUtil() {
    }

    public static Document load(Path path) {
        try {
            SAXReader saxReader = new SAXReader();
            return saxReader.read(path.toFile());
        }
        catch (Exception e) {
            throw DocumentParseException.newInstance("\u8bfb\u53d6\u5e76\u89e3\u6790xml\u5931\u8d25\u3002", e);
        }
    }

    public static void write(Document doc, Path path) {
        XMLWriter writer = null;
        try {
            writer = new XMLWriter((Writer)new FileWriter(path.toFile()));
            writer.write(doc);
        }
        catch (Exception e) {
            throw AbcIOException.newInstance("\u5199XML\u6587\u6863\u5931\u8d25\u3002", e);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

