/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.config;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.ygsoft.abc.service.common.domain.vo.ThreadPoolSettingVO;
import com.ygsoft.abc.service.devops.domain.vo.ThreadPoolStateVO;
import com.ygsoft.abc.service.tool.CastUtil;
import com.ygsoft.abc.service.tool.PropertyConfigUtil;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.StringUtil;
import java.util.ArrayList;
import java.util.IntSummaryStatistics;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@Component
public class ThreadPoolExecutorConfig {
    static final IEcpLog LOG = EcpLogFactory.getLog(ThreadPoolExecutorConfig.class);
    private static final int DEFAULT_CORE_POOL_SIZE = 20;
    private static final int DEFAULT_MAX_POOL_SIZE = 100;
    private static final int DEFAULT_ALIVE_TIME = 180;
    private static final int DEFAULT_QUEUE_SIZE = 20000;
    private static final int DEFAULT_AWAIT_TIME = 60;
    private static final int MAX_PLUS_THREAD_SIZE = 20;
    private static volatile int counter = 0;
    private static final String DEFAULT_THREAD_PREFIX = "abc-threadpool-";
    private int corePoolSize;
    private int maximumPoolSize;
    private int keepAliveTime;
    private int queueSize;
    private int awaitTerminationTime;
    private String threadNamePrefix;
    private static ThreadPoolExecutor executor;
    private static final int STATISTICS_LIMIT_SIZE = 200;
    private static BlockingQueue<ThreadPoolSettingVO> statisticsQueue;
    private static ScheduledExecutorService scheduledExecutorService;

    public int getCorePoolSize() {
        if (this.corePoolSize != 0) {
            return this.corePoolSize;
        }
        String value = PropertyConfigUtil.getProperty("pool.thread.coreSize");
        if (StringUtil.isNullOrTrimEmptyString((String)value)) {
            this.corePoolSize = 20;
            return this.corePoolSize;
        }
        this.corePoolSize = CastUtil.getInteger(value);
        return this.corePoolSize;
    }

    public int getMaximumPoolSize() {
        if (this.maximumPoolSize != 0) {
            return this.maximumPoolSize;
        }
        String value = PropertyConfigUtil.getProperty("pool.thread.maxSize");
        if (StringUtil.isNullOrTrimEmptyString((String)value)) {
            this.maximumPoolSize = 100;
            return this.maximumPoolSize;
        }
        this.maximumPoolSize = CastUtil.getInteger(value);
        return this.maximumPoolSize;
    }

    public int getKeepAliveTime() {
        if (this.keepAliveTime != 0) {
            return this.keepAliveTime;
        }
        String value = PropertyConfigUtil.getProperty("pool.thread.aliveTime");
        if (StringUtil.isNullOrTrimEmptyString((String)value)) {
            this.keepAliveTime = 180;
            return this.keepAliveTime;
        }
        this.keepAliveTime = CastUtil.getInteger(value);
        return this.keepAliveTime;
    }

    public int getQueueSize() {
        if (this.queueSize != 0) {
            return this.queueSize;
        }
        String value = PropertyConfigUtil.getProperty("pool.thread.queueSize");
        if (StringUtil.isNullOrTrimEmptyString((String)value)) {
            this.queueSize = 20000;
            return this.queueSize;
        }
        this.queueSize = CastUtil.getInteger(value);
        return this.queueSize;
    }

    public int getAwaitTerminationTime() {
        if (this.awaitTerminationTime != 0) {
            return this.awaitTerminationTime;
        }
        String value = PropertyConfigUtil.getProperty("pool.thread.awaitTime");
        if (StringUtil.isNullOrTrimEmptyString((String)value)) {
            this.awaitTerminationTime = 60;
            return this.awaitTerminationTime;
        }
        this.awaitTerminationTime = CastUtil.getInteger(value);
        return this.awaitTerminationTime;
    }

    public String getThreadNamePrefix() {
        if (this.threadNamePrefix != null) {
            return this.threadNamePrefix;
        }
        String value = PropertyConfigUtil.getProperty("pool.thread.prefix");
        if (StringUtil.isNullOrTrimEmptyString((String)value)) {
            this.threadNamePrefix = DEFAULT_THREAD_PREFIX;
            return this.threadNamePrefix;
        }
        this.threadNamePrefix = value;
        return this.threadNamePrefix;
    }

    @Bean(name={"abcThreaPoolExecutor"})
    public Executor getThreaPoolExecutor() {
        ThreadFactory factory = new ThreadFactoryBuilder().setNameFormat(this.getThreadNamePrefix() + "%s").build();
        executor = new ThreadPoolExecutor(this.getCorePoolSize(), this.getMaximumPoolSize(), this.getKeepAliveTime(), TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(this.getQueueSize()), factory, new ThreadPoolExecutor.CallerRunsPolicy());
        this.start();
        this.addShutdownHook();
        return executor;
    }

    private void start() {
        this.initScheduledExecutorService();
    }

    private void initScheduledExecutorService() {
        scheduledExecutorService = new ScheduledThreadPoolExecutor(1, runnable -> {
            Thread thread = new Thread(runnable, "ABCThreadPoolMonitorSchedule");
            thread.setDaemon(true);
            return thread;
        });
        scheduledExecutorService.scheduleAtFixedRate(() -> {
            block2: {
                try {
                    this.monitorThreadPool();
                }
                catch (Exception e) {
                    if (!LOG.isErrorEnabled()) break block2;
                    LOG.error((Object)"ABC\u7ebf\u7a0b\u6c60\u76d1\u542c\u4efb\u52a1\u5f02\u5e38...", (Throwable)e);
                }
            }
        }, 1L, 250L, TimeUnit.MILLISECONDS);
    }

    private void addCounter() {
        if (++counter > 10000) {
            counter = 1;
        }
    }

    private void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)"abc-ThreadPool \u5f00\u59cb\u5173\u95ed...");
            }
            executor.shutdown();
            try {
                if (!executor.awaitTermination(30L, TimeUnit.SECONDS)) {
                    executor.shutdownNow();
                }
            }
            catch (Exception e) {
                executor.shutdownNow();
            }
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)"abc-ThreadPool \u5173\u95ed\u5b8c\u6210\u3002");
            }
        }));
    }

    public static List<ThreadPoolStateVO> getThreadPoolStates() {
        ArrayList<ThreadPoolStateVO> list = new ArrayList<ThreadPoolStateVO>();
        for (ThreadPoolSettingVO settingVO : statisticsQueue) {
            list.add(ThreadPoolStateVO.from(settingVO));
        }
        return list;
    }

    private boolean canAddCorePoolSize() {
        int size = statisticsQueue.size();
        return size >= 8;
    }

    private boolean canSubtractCorePoolSize() {
        int size = statisticsQueue.size();
        return size >= 120;
    }

    private void monitorThreadPool() {
        int avg;
        this.addCounter();
        ThreadPoolSettingVO currentSetting = ThreadPoolSettingVO.readFrom(executor);
        statisticsQueue.offer(currentSetting);
        if (this.isLimitSize()) {
            statisticsQueue.poll();
        }
        if (this.canAddCorePoolSize() && counter % 8 == 0 && (avg = this.getLastAverage(8)) > 0) {
            int plusPoolSize = Math.min(avg, 20);
            int corePoolSize = Math.min(executor.getCorePoolSize() + plusPoolSize, this.getMaximumPoolSize());
            System.out.println("\u65b0\u589e\u7ebf\u7a0b\u540e\uff0c\u8bbe\u7f6ecorePoolSize\uff1a" + corePoolSize);
            executor.setCorePoolSize(corePoolSize);
        }
        if (this.canSubtractCorePoolSize() && counter % 120 == 0 && (avg = this.getLastAverage(120)) == 0) {
            int corePoolSize = Math.max(executor.getCorePoolSize() - 1, this.getCorePoolSize());
            System.out.println("\u51cf\u5c11\u7ebf\u7a0b\u540e\uff0c\u8bbe\u7f6ecorePoolSize\uff1a" + corePoolSize);
            executor.setCorePoolSize(corePoolSize);
        }
    }

    private boolean isLimitSize() {
        int elementCount = statisticsQueue.size();
        return elementCount >= 200;
    }

    private int getLastAverage(int count) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (ThreadPoolSettingVO setting : statisticsQueue) {
            if (setting == null) continue;
            list.add(setting.getQueueElementCount());
        }
        List last10List = Lists.reverse(list).subList(0, count);
        IntSummaryStatistics statistics = last10List.stream().mapToInt(ele -> ele).summaryStatistics();
        int avg = (int)statistics.getAverage();
        return avg;
    }

    private int computePoolSize(int poolSize) {
        return Math.min(poolSize, this.getMaximumPoolSize());
    }

    static {
        statisticsQueue = new LinkedBlockingQueue<ThreadPoolSettingVO>(200);
        scheduledExecutorService = null;
    }
}

