/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.document.function.impl;

import com.ygsoft.abc.service.document.function.ExcelTransferFunction;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.StreamUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.poi.hssf.converter.ExcelToHtmlConverter;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public final class Excel2003TransferFunction
implements ExcelTransferFunction {
    private static final IEcpLog LOG = EcpLogFactory.getLog(Excel2003TransferFunction.class);
    public static final Excel2003TransferFunction INSTANCE = new Excel2003TransferFunction();

    private Excel2003TransferFunction() {
    }

    @Override
    public String transfer2Html(String templatePath, String fontName) {
        HSSFWorkbook document = this.getHSSFWorkbook(templatePath);
        return this.excel2Html(document, fontName);
    }

    public String transfer2Html(HSSFWorkbook excelBook, String fontName) {
        return this.excel2Html(excelBook, fontName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String excel2Html(HSSFWorkbook excelDocument, String fontName) {
        String content = "";
        ByteArrayOutputStream os = null;
        try {
            ExcelToHtmlConverter excelToHtmlConverter = new ExcelToHtmlConverter(DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument());
            excelToHtmlConverter.processWorkbook(excelDocument);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer serializer = tf.newTransformer();
            serializer.setOutputProperty("encoding", "utf-8");
            serializer.setOutputProperty("indent", "yes");
            serializer.setOutputProperty("method", "html");
            DOMSource domSource = new DOMSource(excelToHtmlConverter.getDocument());
            os = new ByteArrayOutputStream();
            StreamResult streamResult = new StreamResult(os);
            serializer.transform(domSource, streamResult);
            content = new String(os.toByteArray(), StandardCharsets.UTF_8);
            StreamUtil.closeStream((OutputStream)os);
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        finally {
            StreamUtil.closeStream(os);
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private HSSFWorkbook getHSSFWorkbook(String path) {
        HSSFWorkbook hSSFWorkbook;
        FileInputStream is = null;
        try {
            is = new FileInputStream(new File(path));
            hSSFWorkbook = new HSSFWorkbook((InputStream)is);
        }
        catch (Exception e) {
            block4: {
                try {
                    if (!LOG.isErrorEnabled()) break block4;
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    StreamUtil.closeStream(is);
                    throw throwable;
                }
            }
            StreamUtil.closeStream((InputStream)is);
            return null;
        }
        StreamUtil.closeStream((InputStream)is);
        return hSSFWorkbook;
    }
}

