/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.document.function.impl;

import com.ygsoft.abc.service.document.function.WordTransferFunction;
import com.ygsoft.abc.service.document.xhtml.AbcXHTMLConverter;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.StreamUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.poi.xwpf.usermodel.XWPFDocument;

public final class Word2007TransferFunction
implements WordTransferFunction {
    private static final IEcpLog LOG = EcpLogFactory.getLog(Word2007TransferFunction.class);
    public static final Word2007TransferFunction INSTANCE = new Word2007TransferFunction();

    private Word2007TransferFunction() {
    }

    @Override
    public String transfer2Html(String templatePath) {
        XWPFDocument document = Word2007TransferFunction.getXWPFDocument(templatePath);
        return Word2007TransferFunction.docx2Html(document);
    }

    @Override
    public String transfer2Html(InputStream is) {
        XWPFDocument document = Word2007TransferFunction.getXWPFDocument(is);
        return Word2007TransferFunction.docx2Html(document);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String docx2Html(XWPFDocument document) {
        String content = null;
        InputStream is = null;
        ByteArrayOutputStream os = null;
        try {
            os = new ByteArrayOutputStream();
            AbcXHTMLConverter.getInstance().convert(document, (OutputStream)os, null);
            content = new String(os.toByteArray(), "utf-8");
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)e);
            }
        }
        finally {
            StreamUtil.closeStream((OutputStream)os);
            StreamUtil.closeStream(is);
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static XWPFDocument getXWPFDocument(String path) {
        XWPFDocument xWPFDocument;
        FileInputStream is = null;
        try {
            XWPFDocument doc;
            is = new FileInputStream(new File(path));
            xWPFDocument = doc = new XWPFDocument((InputStream)is);
        }
        catch (Exception e) {
            try {
                LOG.error((Object)e);
            }
            catch (Throwable throwable) {
                StreamUtil.closeStream(is);
                throw throwable;
            }
            StreamUtil.closeStream((InputStream)is);
            return null;
        }
        StreamUtil.closeStream((InputStream)is);
        return xWPFDocument;
    }

    private static XWPFDocument getXWPFDocument(InputStream is) {
        try {
            XWPFDocument doc = new XWPFDocument(is);
            return doc;
        }
        catch (Exception e) {
            LOG.error((Object)e);
            return null;
        }
    }
}

