/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.document.listener;

import com.itextpdf.text.Chunk;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Image;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfPageEventHelper;
import com.itextpdf.text.pdf.PdfWriter;
import com.ygsoft.abc.service.document.util.ITextPdfUtil;
import com.ygsoft.abc.service.document.vo.HeaderConfigVO;
import com.ygsoft.abc.service.document.vo.PageConfigVO;
import com.ygsoft.abc.service.types.YesnoEnum;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;

public class ITextPdfDefaultHeaderEvent
extends PdfPageEventHelper {
    private static final IEcpLog LOG = EcpLogFactory.getLog(ITextPdfDefaultHeaderEvent.class);
    private PageConfigVO pageConfigVO;
    private HeaderConfigVO headerConfigVO;
    private static Font FONT;

    public ITextPdfDefaultHeaderEvent() {
        this.pageConfigVO = new PageConfigVO();
        this.headerConfigVO = new HeaderConfigVO();
        this.createBaseFont();
    }

    public ITextPdfDefaultHeaderEvent(PageConfigVO pageConfigVO, HeaderConfigVO headerConfigVO) {
        this.pageConfigVO = pageConfigVO;
        this.headerConfigVO = headerConfigVO;
        this.createBaseFont();
    }

    public void onEndPage(PdfWriter writer, Document document) {
        try {
            this.addPageHeader(writer);
        }
        catch (Exception e) {
            LOG.error((Object)"\u6dfb\u52a0\u9875\u7709\u51fa\u9519", (Throwable)e);
        }
    }

    private void addPageHeader(PdfWriter writer) throws IOException, DocumentException {
        Rectangle rectangle = ITextPdfUtil.getRectangle(this.pageConfigVO);
        PdfPTable table = this.headerConfigVO.getLogoData() != null && StringUtils.isNotEmpty((CharSequence)this.headerConfigVO.getText()) ? new PdfPTable(2) : new PdfPTable(1);
        table.setTotalWidth(rectangle.getWidth() - (this.pageConfigVO.getMarginLeft().floatValue() + this.pageConfigVO.getMarginRight().floatValue()));
        if (this.headerConfigVO.getLogoData() != null) {
            Image logo = Image.getInstance((byte[])this.headerConfigVO.getLogoData());
            Phrase logoP = new Phrase("", FONT);
            logoP.add((Element)new Chunk(logo, 0.0f, 0.0f));
            PdfPCell logoCell = new PdfPCell(logoP);
            this.setUnderline(logoCell);
            logoCell.setFixedHeight(this.headerConfigVO.getHeaderHeight().floatValue());
            logoCell.setHorizontalAlignment(0);
            logoCell.setVerticalAlignment(6);
            table.addCell(logoCell);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.headerConfigVO.getText())) {
            Phrase nameP = new Phrase(this.headerConfigVO.getText(), FONT);
            PdfPCell nameCell = new PdfPCell(nameP);
            this.setUnderline(nameCell);
            nameCell.setFixedHeight(this.headerConfigVO.getHeaderHeight().floatValue());
            nameCell.setHorizontalAlignment(2);
            nameCell.setVerticalAlignment(6);
            table.addCell(nameCell);
        }
        table.writeSelectedRows(0, -1, this.pageConfigVO.getMarginLeft().floatValue(), rectangle.getHeight(), writer.getDirectContent());
    }

    private void setUnderline(PdfPCell cell) {
        if (this.headerConfigVO.getIsShowUnderline() == YesnoEnum.YES) {
            cell.disableBorderSide(1);
            cell.disableBorderSide(4);
            cell.disableBorderSide(8);
        } else {
            cell.disableBorderSide(1);
            cell.disableBorderSide(4);
            cell.disableBorderSide(2);
            cell.disableBorderSide(8);
        }
    }

    private void createBaseFont() {
        try {
            BaseFont BASE_FONT = StringUtils.isNotEmpty((CharSequence)this.headerConfigVO.getFontPath()) ? BaseFont.createFont((String)this.headerConfigVO.getFontPath(), (String)"Identity-H", (boolean)false) : BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
            FONT = new Font(BASE_FONT, this.headerConfigVO.getFontSize().floatValue());
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

